/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.zm;

import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;
import java.util.HashMap;

public class ZonePortVsanTableModel
extends SnmpTableModel {
    static final int PORT_INDEX = 0;
    static final int FLOGI_INDEX = 1;
    static final int DESC_INDEX = 2;
    static final int STATE_INDEX = 3;
    static final int VSAN_INDEX = 4;
    private String[] baseHeader = new String[]{"Port", "Device", "Description", "Enable", "VSAN"};
    private Array fullData;
    private int visibleVsan;

    public ZonePortVsanTableModel(ArrayList portList) {
        int i;
        this.setHeaders(this.baseHeader);
        boolean[] editable = new boolean[this.baseHeader.length];
        for (int i2 = 1; i2 < this.baseHeader.length; ++i2) {
            editable[i2] = true;
        }
        editable[4] = this.visibleVsan == 0;
        editable[1] = false;
        this.setEditable(editable);
        Array data = new Array();
        for (i = 0; i < portList.size(); ++i) {
            Object[] o = new Object[this.baseHeader.length + 2];
            o[0] = portList.get(i);
            data.addElement((Object)o);
        }
        this.setData(data);
        this.fullData = new Array();
        for (i = 0; i < data.size(); ++i) {
            this.fullData.addElement(data.elementAt(i));
        }
    }

    Array getFullData() {
        return this.fullData;
    }

    void updateData(HashMap fullPortsData, HashMap switchPortFlogiInfo) {
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object[] rowData = (Object[])this.fullData.elementAt(i);
            Integer portIndex = (Integer)rowData[0];
            Object[] mapData = (Object[])fullPortsData.get(portIndex);
            if (mapData == null) continue;
            rowData[2] = mapData[0];
            rowData[3] = mapData[1];
            rowData[4] = new Integer(((int[])mapData[2])[0]);
            rowData[rowData.length - 1] = rowData;
            Object[] flogi = (Object[])switchPortFlogiInfo.get(portIndex);
            if (flogi == null) continue;
            rowData[1] = WwnDictionary.getWwnAlias((byte[])((byte[])flogi[0]));
        }
        this.fireTableDataChanged();
        this.resetChanges(false);
    }

    void updateDataForVsan(int vsan) {
        this.visibleVsan = vsan;
        Array data = new Array();
        for (int k = 0; k < this.fullData.size(); ++k) {
            int rowVsan;
            Object[] rowData = (Object[])this.fullData.elementAt(k);
            int n = rowVsan = vsan == 0 ? 0 : (Integer)rowData[4];
            if (rowVsan != vsan) continue;
            data.addElement((Object)rowData);
        }
        this.getEditable()[4] = this.visibleVsan == 0;
        this.setData(data);
        this.fireTableDataChanged();
    }

    static int convertVisibleTableDataRowToFullDataRow(int row, ZonePortVsanTableModel dependencyTableModel) {
        int ifIndexRow = (Integer)dependencyTableModel.getValueAt(row, 0);
        int fulldataRow = ZonePortVsanTableModel.findRowColIndexFromInfIndex(ifIndexRow, dependencyTableModel);
        return fulldataRow;
    }

    static int convertFullTableDataRowToVisibleDataRow(int row, ZonePortVsanTableModel dependencyTableModel) {
        Object[] rowData = (Object[])dependencyTableModel.getFullData().elementAt(row);
        int ifIndex = (Integer)rowData[0];
        Array visibleDepData = dependencyTableModel.getData();
        int rowCount = visibleDepData.size();
        for (int i = 0; i < rowCount; ++i) {
            Object[] depFullRowData = (Object[])visibleDepData.elementAt(i);
            Integer ifStored = (Integer)depFullRowData[0];
            if (ifStored != ifIndex) continue;
            return i;
        }
        return -1;
    }

    static int findRowColIndexFromInfIndex(int ifIndex, ZonePortVsanTableModel dependencyTableModel) {
        Array fullDepData = dependencyTableModel.getFullData();
        int rowCount = fullDepData.size();
        for (int i = 0; i < rowCount; ++i) {
            Object[] depFullRowData = (Object[])fullDepData.elementAt(i);
            Integer ifStored = (Integer)depFullRowData[0];
            if (ifStored != ifIndex) continue;
            return i;
        }
        return -1;
    }

    public Array getChanged(Array fullData) {
        if (fullData == null) {
            return null;
        }
        Array cells = null;
        for (int r = 0; r < fullData.size(); ++r) {
            Object[] changed = (Object[])((Object[])fullData.elementAt(r))[this.getHeaders().length];
            if (changed == null) continue;
            if (cells == null) {
                cells = new Array();
            }
            for (int c = 0; c < this.getHeaders().length; ++c) {
                if (changed[c] == null) continue;
                cells.addElement((Object)new Cell(r, c));
            }
        }
        return cells;
    }

    public HashMap getChangedData() {
        Array changedCells = this.getChanged(this.fullData);
        HashMap<Integer, Object[]> changeMap = new HashMap<Integer, Object[]>();
        if (changedCells != null) {
            for (int cellCount = 0; cellCount < changedCells.size(); ++cellCount) {
                Cell cel = (Cell)changedCells.elementAt(cellCount);
                Object[] rowData = (Object[])this.fullData.elementAt(cel._row);
                Integer portIfIndex = (Integer)rowData[0];
                Object[] changeData = (Object[])changeMap.get(portIfIndex);
                if (changeData == null) {
                    changeData = new Object[3];
                }
                changeData[cel._col - 2] = rowData[cel._col];
                changeMap.put(portIfIndex, changeData);
            }
        }
        return changeMap;
    }
}

