/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.zm;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.DmZoneWizard;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.IfIndexZoneMember;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zm.ZonePortVsanTableModel;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ZoneSwitchPortsPairTableModel
extends KTableModel {
    private int zoneInfoCol;
    private ZonePortVsanTableModel dependencyTableModel;
    private Array fullData;

    public ZoneSwitchPortsPairTableModel(ArrayList portList, ZonePortVsanTableModel vsanTableModel) {
        this.dependencyTableModel = vsanTableModel;
        String[] switchPorts = new String[portList.size()];
        for (int i = 0; i < portList.size(); ++i) {
            int portIfIndex = (Integer)portList.get(i);
            switchPorts[i] = DmZoneWizard.getShortenedIfIndex2Name((IfIndexIf)Discover.getRoot(), portIfIndex);
        }
        this.setHeaders(switchPorts);
        boolean[] editable = new boolean[switchPorts.length];
        for (int i = 0; i < switchPorts.length; ++i) {
            editable[i] = true;
        }
        this.setEditable(editable);
        Array data = new Array();
        this.zoneInfoCol = switchPorts.length + 1;
        for (int row = 0; row < portList.size(); ++row) {
            Object[] o = new Object[switchPorts.length + 2];
            for (int col = 0; col < portList.size(); ++col) {
                o[col] = Boolean.FALSE;
            }
            o[this.zoneInfoCol] = new ArrayList();
            data.addElement((Object)o);
        }
        this.setData(data);
        this.fullData = new Array();
        for (int i = 0; i < data.size(); ++i) {
            this.fullData.addElement(data.elementAt(i));
        }
    }

    public void setValueAt(Object aValue, int row, int modelColIndex) {
        int fullRowVal = ZonePortVsanTableModel.convertVisibleTableDataRowToFullDataRow(row, this.dependencyTableModel);
        if (fullRowVal != modelColIndex) {
            super.setValueAt(aValue, row, modelColIndex);
            int testtt = ZonePortVsanTableModel.convertFullTableDataRowToVisibleDataRow(modelColIndex, this.dependencyTableModel);
            super.setValueAt(aValue, ZonePortVsanTableModel.convertFullTableDataRowToVisibleDataRow(modelColIndex, this.dependencyTableModel), fullRowVal);
        }
    }

    void updateZoneData(HashMap fullPortsData, HashMap zoneAllVsanInfo) {
        if (zoneAllVsanInfo == null) {
            return;
        }
        int rowCount = this.fullData.size();
        Array depTableModelFullData = this.dependencyTableModel.getFullData();
        for (int i = 0; i < rowCount; ++i) {
            int portVsan;
            Object[] zoneInformation;
            ArrayList zoneInfo;
            Object[] depRowData = (Object[])depTableModelFullData.elementAt(i);
            Object[] fulRowData = (Object[])this.fullData.elementAt(i);
            Integer storedIfIndexForRow = (Integer)depRowData[0];
            Object[] ifData = (Object[])fullPortsData.get(storedIfIndexForRow);
            if (ifData == null || (zoneInfo = (ArrayList)(zoneInformation = (Object[])zoneAllVsanInfo.get(new Integer(portVsan = ((int[])ifData[2])[0])))[0]) == null) continue;
            for (int k = 0; k < zoneInfo.size(); ++k) {
                int colIfIndex;
                ArrayList zoneMembers;
                Object[] zoneData = (Object[])zoneInfo.get(k);
                if (zoneData == null || (zoneMembers = (ArrayList)zoneData[1]) == null || zoneMembers.size() != 2) continue;
                int rowIfIndex = ((IfIndexZoneMember)zoneMembers.get(0)).getIfIndex();
                int indexToCompare = rowIfIndex > (colIfIndex = ((IfIndexZoneMember)zoneMembers.get(1)).getIfIndex()) ? rowIfIndex : colIfIndex;
                int col = ZonePortVsanTableModel.findRowColIndexFromInfIndex(rowIfIndex > colIfIndex ? colIfIndex : rowIfIndex, this.dependencyTableModel);
                if (col == -1 || indexToCompare != storedIfIndexForRow) continue;
                ArrayList<Object[]> valLst = (ArrayList<Object[]>)fulRowData[this.zoneInfoCol];
                if (valLst == null) {
                    valLst = new ArrayList<Object[]>();
                }
                valLst.add(zoneData);
                fulRowData[this.zoneInfoCol] = valLst;
                fulRowData[col] = Boolean.TRUE;
                Object[] fulFlippedRowData = (Object[])this.fullData.elementAt(col);
                fulFlippedRowData[i] = Boolean.TRUE;
            }
        }
        this.resetChanges(false);
    }

    ArrayList updateDataForVsan(int vsan) {
        Array depTableModelFullData = this.dependencyTableModel.getFullData();
        Array data = new Array();
        ArrayList<Integer> removedRows = new ArrayList<Integer>();
        for (int k = 0; k < this.fullData.size(); ++k) {
            int rowVsan;
            Object[] rowData = (Object[])depTableModelFullData.elementAt(k);
            Object[] fullRowData = (Object[])this.fullData.elementAt(k);
            int n = rowVsan = vsan == 0 ? 0 : (Integer)rowData[4];
            if (rowVsan == vsan) {
                data.addElement((Object)fullRowData);
                continue;
            }
            removedRows.add(new Integer(k));
        }
        this.setData(data);
        this.fireTableDataChanged();
        return removedRows;
    }

    private boolean isChanged(Object[] rowData, int row, int col) {
        Object[] changed = rowData;
        if (changed == null) {
            return false;
        }
        return changed[col] != null;
    }

    void buildChangedData(HashMap changeMap, HashMap changedVsanMap) {
        Array depTableModelFullData = this.dependencyTableModel.getFullData();
        int changeVsanRows = depTableModelFullData.size();
        for (int i = 0; i < changeVsanRows; ++i) {
            Object[] depModelfullDataRowData = (Object[])depTableModelFullData.elementAt(i);
            Object[] changedData = (Object[])depModelfullDataRowData[this.dependencyTableModel.getHeaders().length];
            if (!this.isChanged(changedData, i, 4)) continue;
            Object intVsan = depModelfullDataRowData[4];
            Object intVsanOri = changedData[4];
            if (changedVsanMap.get(intVsan) == null) {
                changedVsanMap.put(intVsan, new ArrayList());
            }
            if (changedVsanMap.get(intVsanOri) != null) continue;
            changedVsanMap.put(intVsanOri, new ArrayList());
        }
        int rowCount = this.fullData.size();
        for (Map.Entry obEntry : changedVsanMap.entrySet()) {
            Integer vsanId = (Integer)obEntry.getKey();
            ArrayList portPairList = (ArrayList)obEntry.getValue();
            for (int r = 0; r < rowCount; ++r) {
                Object[] depModelfullDataRowData = (Object[])depTableModelFullData.elementAt(r);
                Object[] fullDataRowData = (Object[])this.fullData.elementAt(r);
                if (!depModelfullDataRowData[4].equals(vsanId)) continue;
                for (int c = 0; c < r; ++c) {
                    Object[] depModelfullDataColData = (Object[])depTableModelFullData.elementAt(c);
                    if (!fullDataRowData[c].equals(Boolean.TRUE)) continue;
                    portPairList.add(new Object[]{depModelfullDataRowData[0], depModelfullDataColData[0], depModelfullDataRowData[1], depModelfullDataColData[1]});
                }
            }
        }
        Array changedCells = this.getChanged(this.fullData);
        if (changedCells != null) {
            int cellCount = 0;
            while (cellCount < changedCells.size()) {
                Cell cel = (Cell)changedCells.elementAt(cellCount);
                int changeRow = cel._row;
                Object[] depTableFullRowData = (Object[])depTableModelFullData.elementAt(changeRow);
                Object intVsan = depTableFullRowData[4];
                if (changedVsanMap.get(intVsan) != null) {
                    ++cellCount;
                    continue;
                }
                intVsan = depTableFullRowData[4];
                Object[] changeData = (Object[])changeMap.get(intVsan);
                if (changeData == null) {
                    changeData = new Object[]{new ArrayList(), new ArrayList(), new ArrayList()};
                    changeMap.put(intVsan, changeData);
                }
                Object[] depTableFullColData = (Object[])depTableModelFullData.elementAt(cel._col);
                Object[] fullRowData = (Object[])this.fullData.elementAt(cel._row);
                if (fullRowData[cel._col].equals(Boolean.TRUE)) {
                    ((ArrayList)changeData[1]).add(new Object[]{depTableFullRowData[0], depTableFullColData[0], depTableFullRowData[1], depTableFullColData[1]});
                } else {
                    ArrayList valLst = (ArrayList)fullRowData[this.zoneInfoCol];
                    ((ArrayList)changeData[0]).addAll(this.findZonesWithPorts(new Object[]{depTableFullRowData[0], depTableFullColData[0]}, valLst));
                    ((ArrayList)changeData[2]).add(new Object[]{depTableFullRowData[0], depTableFullColData[0], depTableFullRowData[1], depTableFullColData[1]});
                }
                ++cellCount;
            }
        }
    }

    public Array getChanged(Array fullData) {
        if (fullData == null) {
            return null;
        }
        Array cells = null;
        for (int r = 0; r < fullData.size(); ++r) {
            Object[] changed = (Object[])((Object[])fullData.elementAt(r))[this.getHeaders().length];
            if (changed == null) continue;
            if (cells == null) {
                cells = new Array();
            }
            for (int c = 0; c < r; ++c) {
                if (changed[c] == null) continue;
                cells.addElement((Object)new Cell(r, c));
            }
        }
        return cells;
    }

    private ArrayList findZonesWithPorts(Object[] swPorts, ArrayList zonePortsInfo) {
        ArrayList<Object> zoneS = new ArrayList<Object>();
        for (int i = 0; i < zonePortsInfo.size(); ++i) {
            Object[] znD = (Object[])zonePortsInfo.get(i);
            ArrayList members = (ArrayList)znD[1];
            if ((((IfIndexZoneMember)members.get(0)).getIfIndex() != ((Integer)swPorts[0]).intValue() || ((IfIndexZoneMember)members.get(1)).getIfIndex() != ((Integer)swPorts[1]).intValue()) && (((IfIndexZoneMember)members.get(1)).getIfIndex() != ((Integer)swPorts[0]).intValue() || ((IfIndexZoneMember)members.get(0)).getIfIndex() != ((Integer)swPorts[1]).intValue())) continue;
            zoneS.add(znD[0]);
        }
        return zoneS;
    }

    void portVsanChanged(int row) {
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.setValueAt(Boolean.FALSE, row, i);
            this.setValueAt(Boolean.FALSE, i, row);
        }
        super.setValueAt(null, row, this.getHeaders().length);
    }

    void toggleAllCells(int col) {
        int rows = this.getRowCount();
        if (col < rows) {
            int i;
            Boolean val = (Boolean)this.getValueAt(col + 1, col);
            for (i = 0; i < rows; ++i) {
                if (!this.isCellEditable(i, col)) continue;
                val = (Boolean)this.getValueAt(i, col);
                break;
            }
            for (i = 0; i < rows; ++i) {
                if (!this.isCellEditable(i, col)) continue;
                this.setValueAt(val == false, i, col);
            }
        }
    }

    public boolean isCellActive(int row, int modelColIndex) {
        Array depFullData = this.dependencyTableModel.getFullData();
        if (ZonePortVsanTableModel.convertVisibleTableDataRowToFullDataRow(row, this.dependencyTableModel) != modelColIndex) {
            Object rowVsan = this.dependencyTableModel.getValueAt(row, 4);
            Object colVsan = ((Object[])depFullData.elementAt(modelColIndex))[4];
            if (colVsan != null && rowVsan != null && rowVsan.equals(colVsan)) {
                return true;
            }
        }
        return false;
    }
}

