/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.RateModeConfig;
import com.cisco.dcbu.dmdb.andiamo.dialogs.physical.CheckOversubscription;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_13;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_18;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_19;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_28;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_33;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_45;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_56;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_64;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_10;
import com.cisco.dcbu.dmdb.andiamo.elements.XBar_Card;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Card
extends PhysicalElement
implements ActionListener {
    public static final Color[] _Colors = new Color[]{new Color(160, 132, 32), new Color(160, 132, 32), Color.green, Color.orange, Color.red};
    static final int[][] CARD_STATUS_LED_POS = new int[][]{{14, 28}};
    protected JPopupMenu _Menu;
    public int _status = 2;
    public int _powerStatus;
    static MibEnum[] _States;
    protected String _toolTipText;
    public static boolean _isSupportPortStatusPerModuleFeature;

    public String getBitmap() {
        return DmId.isChassisGrayBackGound(Discover.getSysObjectID()) ? (this._parent instanceof Chassis_10 ? "unsupportedcard_n7k.gif" : "unsupportedcard_XBOW.gif") : "unsupportedcard.gif";
    }

    protected int getCardType() {
        if (this.getParent() instanceof Chassis) {
            int offset = FRUConstants.getComponentOffset((int)this.getIndex()[0]);
            int slot = offset - 21 - 1;
            return ((Chassis)this.getParent())._CardType[slot];
        }
        return -1;
    }

    public void disable() {
    }

    public JPopupMenu getMenu() {
        if (this._Menu == null) {
            String[][] menuItems;
            this._Menu = this.buildMenu(this);
            String[][] menuItems_2_0 = new String[][]{{"Reset", "resetAction"}};
            String[][] menuItems_3_0 = new String[][]{{"Out of Service", "outOfServiceAction"}, {"Reset", "resetAction"}};
            String[][] menuItems_3_0_no_reset = new String[][]{{"Out of Service", "outOfServiceAction"}};
            String[][] menuItems_no_reset = new String[][]{};
            String[][] menuItems_pre_4_1_1_no_OutOfService = new String[][]{};
            Object object = Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && this.isSupportOutOfService() ? (this.isSupportReset() ? menuItems_3_0 : (Discover.isSysVersionGreaterThanEqual((String)"4.1(1)") ? menuItems_3_0_no_reset : menuItems_pre_4_1_1_no_OutOfService)) : (menuItems = this.isSupportReset() ? menuItems_2_0 : menuItems_no_reset);
            if (menuItems.length > 0) {
                this._Menu.addSeparator();
                this.addMenuItems(this._Menu, menuItems, this);
            }
        }
        return this._Menu;
    }

    public static boolean isSupportOutOfService(Card thisCard) {
        return !DmId.isN7K(Discover.getSysObjectID()) && (thisCard instanceof Card_1 || thisCard instanceof Card_13 || thisCard instanceof Card_18 || thisCard instanceof Card_19 || thisCard instanceof Card_28 || thisCard instanceof Card_56 || thisCard instanceof Card_64 || Discover.isSysVersionlessThan((String)"5.2(0)") && thisCard instanceof Card_33 || Discover.isSysVersionlessThan((String)"5.2(0)") && thisCard instanceof Card_45);
    }

    private boolean isSupportOutOfService() {
        return Card.isSupportOutOfService(this);
    }

    private boolean isSupportReset() {
        return !FRUConstants.isXBar((int)this.getCardType()) && !DmId.isN7K(Discover.getSysObjectID()) && !DmId.isNuovaFamily(Discover.getSysObjectID());
    }

    public void resetAction(PhysicalElement[] selected) {
        JFrame parent = (JFrame)SwingUtilities.windowForComponent((Component)DeviceManager.getInstance().getView());
        if (JOptionPane.showOptionDialog(parent, "Resetting modules may interrupt traffic.\nContinue?", parent.getTitle(), 0, 3, null, new String[]{"Yes", "No"}, "No") != 0) {
            return;
        }
        this.applyAll(selected, "cefcModuleAdminStatus", (SnmpVar)new SnmpInt(3), true);
    }

    void checkOversubscriptionAction(PhysicalElement[] selected, int offset, int max, int numPortPerGroup) {
        block2: {
            try {
                CheckOversubscription instance;
                Class[] types = new Class[]{JFrame.class, SnmpPeer.class};
                Object[] args = new Object[2];
                args[0] = DeviceManager.getInstance();
                Discover.getInstance();
                args[1] = Discover.getPeer();
                Class<CheckOversubscription> c = CheckOversubscription.class;
                String method = "getInstance";
                Method m = c.getMethod(method, types);
                DmSystem._CheckOversubscription = instance = (CheckOversubscription)m.invoke(c, args);
                types = new Class[]{selected.getClass(), Integer.class, Integer.class, Integer.class};
                args = new Object[]{selected, new Integer(offset), new Integer(max), new Integer(numPortPerGroup)};
                method = "showDialog";
                m = c.getMethod(method, types);
                m.invoke((Object)instance, args);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
                if (!SnmpSession.isTrace()) break block2;
                ex.printStackTrace();
            }
        }
    }

    void rateModeConfigAction(PhysicalElement[] selected, int slot, int cardType, String title) {
        block2: {
            try {
                RateModeConfig instance;
                Class[] types = new Class[]{JFrame.class, Integer.class, Integer.class, String.class};
                Object[] args = new Object[]{DeviceManager.getInstance(), new Integer(slot), new Integer(cardType), title};
                Class<RateModeConfig> c = RateModeConfig.class;
                String method = "getInstance";
                Method m = c.getMethod(method, types);
                DmSystem._RateModeConfig = instance = (RateModeConfig)m.invoke(c, args);
                types = new Class[]{selected.getClass()};
                args = new Object[]{selected};
                method = "showDialog";
                m = c.getMethod(method, types);
                m.invoke((Object)instance, args);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
                if (!SnmpSession.isTrace()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void outOfServiceAction(PhysicalElement[] selected) {
        String[] cmds = new String[selected.length];
        StringBuffer title = new StringBuffer("Out of Service ");
        int baseCt = title.length();
        boolean moduleSelected = false;
        boolean xBarSelected = false;
        for (int i = 0; i < selected.length; ++i) {
            int moduleId;
            int offset;
            String moduleCmd;
            if (!Card.isSupportOutOfService((Card)selected[i])) continue;
            if (selected[i] instanceof XBar_Card) {
                moduleCmd = "Xbar";
                offset = 21 + DmSystem.getCoreSwitchChassis().getNumberOfSlot();
                xBarSelected = true;
                moduleId = selected[i].getIndex()[0] - offset;
                cmds[i] = "Out-of-Service  " + moduleCmd + " " + moduleId + " force\n";
            } else {
                moduleCmd = "Module";
                offset = 21;
                moduleSelected = true;
                moduleId = selected[i].getIndex()[0] - offset;
                cmds[i] = "Out-of-Service  " + moduleCmd + " " + moduleId + "\n";
            }
            if (title.length() > baseCt) {
                title.append(", ");
            }
            title.append(moduleCmd);
            title.append(" ");
            title.append(moduleId);
        }
        Object[] options = new String[]{"Yes", "No"};
        StringBuffer sb = new StringBuffer();
        String msgModule = "This will disable your switch unless you have a standby.\nOnce a module is out of service, it must be physically reinserted to become active.\n";
        String msgXbar = "This action may cause a switchover.\nOnce a module is out of service, it must be physically reinserted to become operational.";
        if (moduleSelected) {
            sb.append(msgModule);
        }
        if (xBarSelected) {
            if (moduleSelected) {
                sb.append("Xbar: ");
            }
            sb.append(msgXbar);
        }
        sb.append("\nContinue?");
        if (JOptionPane.showOptionDialog((Component)DeviceManager.getInstance(), sb.toString(), title.toString(), 0, 3, null, options, "No") != 0) {
            return;
        }
        try {
            new VshDump((JFrame)DeviceManager.getInstance(), title.toString(), cmds, Discover.getPeer()).setVisible(true);
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    public void ShowPortResourcesAction(PhysicalElement[] selected) {
        String[] cmds = new String[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            int moduleId = selected[i].getIndex()[0] - 21;
            cmds[i] = "Show Port-Resources module " + moduleId + "\n";
        }
        try {
            new VshDump((JFrame)DeviceManager.getInstance(), "Show Port-Resources", cmds, Discover.getPeer()).setVisible(true);
        }
        catch (IOException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    public String getEditDialog() {
        return "Module";
    }

    public String getStatus() {
        if (_States == null) {
            _States = MibNode.get((String)"cefcModuleOperStatus").getEnums();
        }
        for (int i = 0; i < _States.length; ++i) {
            if (this._status != _States[i].getValue()) continue;
            return _States[i].getLabel();
        }
        return "n/a";
    }

    protected static int[][] buildPortPos(int[] pX_pos, int[] pY_pos, int pX_offset, int pY_offset, boolean pIsNamingOrderVertical) {
        Card.prepareArray(pX_pos, pX_offset);
        Card.prepareArray(pY_pos, pY_offset);
        return Card.buildPortPos(pX_pos, pY_pos, pIsNamingOrderVertical);
    }

    private static void prepareArray(int[] pPos, int pOffset) {
        if (pPos[0] < 0) {
            pPos[0] = pOffset;
        }
        for (int i = 1; i < pPos.length; ++i) {
            if (pPos[i] >= 0) continue;
            pPos[i] = pPos[i - 1] + pOffset;
        }
    }

    private static int[][] buildPortPos(int[] pX_pos, int[] pY_pos, boolean pIsNamingOrderVertical) {
        int size = pX_pos.length * pY_pos.length;
        int[][] port_pos = new int[size][2];
        int i = 0;
        for (int x = 0; x < pX_pos.length; ++x) {
            for (int y = 0; y < pY_pos.length; ++y) {
                i = pIsNamingOrderVertical ? y + pY_pos.length * x : x + pX_pos.length * y;
                port_pos[i] = new int[]{pX_pos[x], pY_pos[y]};
            }
        }
        return port_pos;
    }

    public String getToolTipText() {
        if (this._toolTipText == null) {
            int cardType;
            this._toolTipText = DmId.isNuovaFamily(Discover.getSysObjectID()) ? this.getHTMLToolTipText() : ((cardType = this.getCardType()) == -1 ? "Unsupported Card" : FRUConstants.getCardTypeName((int)cardType) + ". Status: " + this.getStatus());
        }
        return this._toolTipText;
    }

    protected boolean isUpStatus() {
        return DmId.isNuovaFamily(Discover.getSysObjectID()) ? this.getStatus().equalsIgnoreCase("ok") : false;
    }

    public String toString() {
        int cardType = this.getCardType();
        return cardType == -1 ? "Unsupported Card" : FRUConstants.getCardTypeName((int)this.getCardType());
    }
}

