/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.CollapsibleIf;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_10;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_Container;
import com.cisco.dcbu.dmdb.andiamo.elements.CollapseRestoreControl;
import com.cisco.dcbu.dmdb.andiamo.elements.Fan;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.dmdb.andiamo.elements.Power;
import com.cisco.dcbu.dmdb.andiamo.elements.SatChassisIf;
import com.cisco.dcbu.dmdb.andiamo.elements.SystemStatusLED;
import com.cisco.dcbu.dmdb.andiamo.elements.UnsupportedSatCard_Abstract;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;

public abstract class Chassis_Sat_Abstract
extends Chassis
implements SatChassisIf,
CollapsibleIf {
    Class[] _ChildrenWhenMinimized = new Class[]{CollapseRestoreControl.class};
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get((String)"entPhysicalSoftwareRev").getOid()};
    final Class[] _Children = new Class[]{Fan.class, Power.class, SystemStatusLED.class, Card.class, CollapseRestoreControl.class};
    protected int _satSwitchId = -1;
    protected int _satSwitchType = -1;
    protected Class _coreSwitchClass = null;
    private String _version;
    private int _id = -1;
    protected int _verVarOffset;

    public Chassis_Sat_Abstract() {
        this._CardType = new int[0];
    }

    public abstract String getExpandedBitmap();

    @Override
    public int getSatSwitchId() {
        return this._satSwitchId;
    }

    @Override
    public int getSatSwitchType() {
        return this._satSwitchType;
    }

    @Override
    public void setSatSwitchId(int satSwitchId) {
        this._satSwitchId = satSwitchId;
    }

    public void setSatSwitchType(int satSwitchType) {
        this._satSwitchType = satSwitchType;
    }

    public Class getCoreSwitchClass() {
        return this._coreSwitchClass;
    }

    public void setCoreSwitchClass(Class coreSwichClass) {
        this._coreSwitchClass = coreSwichClass;
    }

    @Override
    public Point getSatIdOffset() {
        return new Point(40, 20);
    }

    public Point getVersionStringOffset() {
        Rectangle r = this.getRect();
        int x = r.x + r.width - 60;
        if (this.isCollapsed()) {
            x -= 10;
        }
        int y = r.y + r.height - 10;
        return new Point(x, y);
    }

    public Point getTypeStringOffset() {
        Point p = this.getSatIdOffset();
        p.x += 40;
        return p;
    }

    @Override
    public JPopupMenu getMenu() {
        return null;
    }

    public int[] getStatusIndex(int[] index) {
        int idx = index[index.length - 1];
        if (idx > 0) {
            this.setSatSwitchId(Chassis_Container._SwitchIds[idx - 1]);
            this.setSatSwitchType(Chassis_Container._SwitchTypes[idx - 1]);
            this.setCoreSwitchClass(((Chassis_Container)this.getParent()).getCoreSwitchClass());
        }
        return new int[]{0};
    }

    @Override
    public boolean isCollapsed() {
        return Chassis_Container.isSatSwitchCollapsed(this.getSatSwitchId());
    }

    public void setCollapsed(boolean minimized) {
        Chassis_Container.setSatSwitchCollapsed(this.getSatSwitchId(), minimized);
    }

    @Override
    public Class[] getChildren() {
        return this.isCollapsed() ? this._ChildrenWhenMinimized : this._Children;
    }

    @Override
    protected Class getUnSupportedCardClass(int slotNum) {
        return UnsupportedSatCard_Abstract.class;
    }

    @Override
    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == CollapseRestoreControl.class || child == SystemStatusLED.class) {
            return null;
        }
        return super.getChildSubclass(child);
    }

    @Override
    public int[] getChildIndex(Class child, int index) {
        if (child == CollapseRestoreControl.class) {
            return null;
        }
        return super.getChildIndex(child, index);
    }

    @Override
    protected Class[] discoverCards() throws Exception {
        return this.discoverCards(this.getNumberOfSlot());
    }

    @Override
    public int getCardOffset() {
        return FRUConstants.getCardOffset() + FRUConstants.getSatelliteSwitchComponentOffset((int)this.getSatSwitchId());
    }

    @Override
    public int getPowerSupplyOffset() {
        return FRUConstants.getPowerSupplyOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) + FRUConstants.getSatelliteSwitchComponentOffset((int)this.getSatSwitchId());
    }

    @Override
    public int getFanOffset() {
        return FRUConstants.getFanOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) + FRUConstants.getSatelliteSwitchComponentOffset((int)this.getSatSwitchId());
    }

    public int[] getStatusVarIndex(int[] index) {
        int[] cardIndex = new int[]{this.getCardOffset() + 1};
        return cardIndex;
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        SnmpVarBind[] var = null;
        if (!this.isCollapsed()) {
            var = super.getStatusVar();
        }
        if (var == null) {
            var = new SnmpVarBind[]{};
        }
        SnmpVarBind[] verVar = this.buildStatusVar(STATUS_VAR);
        SnmpVarBind[] vbs = new SnmpVarBind[var.length + 1];
        System.arraycopy(var, 0, vbs, 0, vbs.length - 1);
        System.arraycopy(verVar, 0, vbs, vbs.length - 1, 1);
        this._verVarOffset = var.length;
        return vbs;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        if (!this.isCollapsed()) {
            super.setStatus(varBindList, offset, view);
        }
        String version = varBindList.get(offset += this._verVarOffset).getVar().toString();
        if (this._version != null && this._version.equals(version)) {
            return;
        }
        Point p = this.getVersionStringOffset();
        if (this._version != null && version.equals(this._version)) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont);
        Rectangle r = this.getRect();
        if (this._version != null) {
            g.setColor(new Color(66, 66, 66));
            g.drawString(this._version, p.x, p.y);
        }
        g.setColor(Color.black);
        g.drawString(version, r.x + r.width - 50, r.y + r.height - 5);
        g.dispose();
        this._version = version;
        this.printSatSwitchIdOnPhysicalView();
        if (this.isCollapsed()) {
            this.printSatSwitchTypeOnPhysicalView();
        }
    }

    public void printSatSwitchIdOnPhysicalView() {
        int yOffset;
        int id = this.getSatSwitchId();
        if (this._id != -1 && id != this._id) {
            return;
        }
        PhysicalView view = DeviceManager.getInstance().getView();
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont.deriveFont(1, 16.0f));
        Rectangle r = this.getRect();
        Point p = this.getSatIdOffset();
        int xOffset = this.isCollapsed() ? 0 : -35;
        int n = yOffset = this.isCollapsed() ? 0 : 50;
        if (this._id != -1) {
            g.setColor(new Color(66, 66, 66));
            g.drawString(String.valueOf(id), r.getLocation().x + p.x + xOffset, r.getLocation().y + p.y + yOffset);
        }
        g.setColor(Color.black);
        g.drawString(String.valueOf(id), r.getLocation().x + p.x + xOffset, r.getLocation().y + p.y + yOffset);
        g.dispose();
        this._id = id;
    }

    public void printSatSwitchTypeOnPhysicalView() {
        PhysicalView view = DeviceManager.getInstance().getView();
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont.deriveFont(1, 16.0f));
        g.setColor(Color.black);
        int chassisType = this.getSatSwitchType();
        String type = FRUConstants.getMDSModelName((int)chassisType);
        Point p = this.getTypeStringOffset();
        Rectangle r = this.getRect();
        if (type != null) {
            g.drawString(type, r.getLocation().x + p.x, r.getLocation().y + p.y);
        }
        g.dispose();
    }

    public String getBitmap() {
        boolean is10Slot;
        boolean bl = is10Slot = this.getCoreSwitchClass() == Chassis_10.class;
        return this.isCollapsed() ? (is10Slot ? "chassis-sat-mini-10slot.gif" : "chassis-sat-mini.gif") : this.getExpandedBitmap();
    }
}

