/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.AbstractEthPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort_N7K;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;

public class FCCard
extends Card {
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get((String)"cieInterfacesIndex").getOid(), MibNode.get((String)"cieInterfacesOperMode").getOid(), MibNode.get((String)"cieInterfacesOperCause").getOid()};
    protected static final int[] portModeMap = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, 19, 20, 21};

    public SnmpVarBind[] getStatusVar() {
        if (Card._isSupportPortStatusPerModuleFeature) {
            return this.buildStatusVar(STATUS_VAR, this.getPortStatusVarIndex(this._index));
        }
        return null;
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        byte[] b = varBindList.byteValue(offset);
        byte[] operModeList = varBindList.byteValue(offset + 1);
        byte[] operCauseList = varBindList.byteValue(offset + 2);
        int i = 0;
        int j = 0;
        if (b.length == 0 || operModeList.length == 0 || operCauseList.length == 0) {
            this.disable();
            return;
        }
        for (int k = 0; (i < b.length || j < operModeList.length || k < operCauseList.length) && i <= b.length - 4 && j <= operModeList.length - 1 && k <= operCauseList.length - 2; i += 4, ++j, k += 2) {
            int ifIndex = ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
            PhysicalElement e = view.find(AbstractPort.class, ifIndex);
            if (e != null) {
                int operMode = operModeList[j] & 0xFF;
                int operCause = ((operCauseList[k + 1] & 0xFF) << 8) + (operCauseList[k] & 0xFF);
                this.updatePortStatus(view, e, operMode, operCause);
                if (!(e instanceof EthernetPort)) continue;
                ((AbstractEthPort)e).clearBreakoutPortStatus(view);
                continue;
            }
            int type = IfIndexUtil.getType((int)ifIndex);
            if (FRUConstants.isBreakoutV3Capable((int)this.getCardType()) && (type == 56 || type == 57 || type == 58)) {
                int breakoutIfIndex = ifIndex;
                int slot = IfIndexUtil.getV3BreakoutSlot((int)ifIndex, (int)55);
                int port = IfIndexUtil.getV3BreakoutPort((int)ifIndex, (int)55);
                int vPort = IfIndexUtil.getV3BreakoutVirtualPort((int)ifIndex, (int)55);
                ifIndex = Discover.getRoot().nameToIfIndex(slot, port, 26);
                e = view.find(AbstractPort.class, ifIndex);
                if (e != null) {
                    int operMode = operModeList[j] & 0xFF;
                    int operCause = ((operCauseList[k + 1] & 0xFF) << 8) + (operCauseList[k] & 0xFF);
                    ((AbstractEthPort)e).updateBreakoutPortStatus(DeviceManager.getInstance().getView(), breakoutIfIndex, vPort - 1, operCause, 10);
                    this.updatePortStatus(view, e, operMode, 9999);
                    continue;
                }
            }
            DefaultLogger._DefLogger.debug((Object)("setStatus port not found : " + ifIndex));
        }
    }

    protected void updatePortStatus(PhysicalView view, PhysicalElement e, int operMode, int operCause) {
        if (e != null && e instanceof Port) {
            ((Port)e).resetStatus();
            ((Port)e).setStatus(portModeMap[operMode], operCause, view);
        } else if (e != null && e instanceof EthernetPort) {
            ((EthernetPort)e).resetStatus(false);
            if (e instanceof EthernetPort_N7K) {
                ((EthernetPort_N7K)e).setSelectable(true);
            }
            if (operMode > portModeMap.length) {
                DefaultLogger._DefLogger.debug((Object)(e + "operMode/operCause  " + operMode + '/' + operCause + ": operMode outOfRange !"));
            }
            ((EthernetPort)e).setStatus(operMode > portModeMap.length ? 0 : portModeMap[operMode], operCause, view);
        }
    }

    public int[] getStatusIndex(int[] index) {
        int[] cardIndex = new int[]{index[0]};
        return cardIndex;
    }

    public int[] getPortStatusVarIndex(int[] index) {
        int[] cardIndex = new int[]{index[0], 1};
        return cardIndex;
    }

    @Override
    public void disable() {
        super.disable();
        PhysicalView view = DeviceManager.getInstance().getView();
        Array elements = view.getElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            PhysicalElement element = (PhysicalElement)elements.elementAt(i);
            if (!(element instanceof Port) && !(element instanceof AbstractEthPort) || IfIndexUtil.ifIndex2Card((int)element.getIndex()[0]) != this.getIndex()[0] - 21 - 1) continue;
            if (element instanceof Port) {
                ((Port)element).setStatus(0, 29, view);
                continue;
            }
            if (!(element instanceof EthernetPort)) continue;
            ((EthernetPort)element).resetStatus(true);
            ((EthernetPort)element).setStatus(0, 155, view);
        }
    }
}

