/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements.mds9020;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.System9020;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public final class Port
extends AbstractPort {
    private static final int ONLINE_STATE = 1;
    private static final int OFFLINE_STATE = 2;
    private static final int TESTING_STATE = 3;
    private static final int LINKFAILURE_STATE = 4;
    private static final int NO_MEDIA = 7;
    private static final int ADMIN_DOWN = 2;
    private static final int REASON_UNKNOWN = 1;
    private static final int REASON_UP = 2;
    private static final int REASON_ADMINDOWN = 3;
    private static final int REASON_NOTCONNECTED = 4;
    private static final int REASON_FCOTNOTPRESENT = 5;
    private static final int REASON_FCOT_UNKOWN = 6;
    private static final int REASON_HARDWARE_FAILURE = 7;
    private static final int REASON_ISOLATED = 8;
    public static final int FICON_CH = 1;
    public static final int FICON_CU = 2;
    public static final Font _ModeFont = new Font("SansSerif", 0, 9);
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get((String)"fcQxQuailPortOperMode").getOid(), MibNode.get((String)"fcQxQuailPortPhysReasonCode").getOid()};
    private static final int MODE_F = 2;
    private static final String[] MODES = new String[]{"GL", "F", "FL", "E", "", "Fx"};
    private static MibEnum[] _OperStatusReasons = MibNode.get((String)"fcQxQuailPortPhysReasonCode").getEnums();
    protected static JPopupMenu _Menu;
    public boolean _isEPort;
    public boolean _isTEPort;
    public boolean _isFPort;
    public boolean _isSDPort;
    private String _toolTipText;
    public int _cause;

    public SnmpVarBind[] getStatusVar() {
        return this.buildStatusVar(STATUS_VAR);
    }

    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        int[] connUnitIndex = this.getStatusVarIndex(this._index);
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        vb[0] = new SnmpVarBind(new SnmpOID(oids[0], this._index));
        vb[1] = new SnmpVarBind(new SnmpOID(oids[1], this._index));
        return vb;
    }

    public int[] getStatusVarIndex(int[] index) {
        int[] unitId = System9020.getUnitId();
        int[] portIndex = new int[unitId.length + 9];
        System.arraycopy(unitId, 0, portIndex, 0, unitId.length);
        portIndex[portIndex.length - 1] = index[index.length - 1];
        return portIndex;
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        this.resetStatus();
        int mode = varBindList.intValue(offset);
        this._cause = varBindList.intValue(offset + 1);
        this.setStatus(mode, this._cause, view);
    }

    public void setStatus(int mode, int cause, PhysicalView view) {
        if (this._image == this._errorImage) {
            this._image = this._okImage;
        }
        switch (cause) {
            case 2: {
                view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[0]);
                this.setMode(mode, view);
                this._status = 1;
                break;
            }
            case 3: {
                view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[1]);
                this._status = 2;
                break;
            }
            case 5: {
                view.updateImage(this._image, this._rect.x, this._rect.y, Color.black);
                this._status = 2;
                break;
            }
            case 4: 
            case 7: {
                this._status = 2;
                this.setCrossImage(view, _Colors[2]);
                break;
            }
            default: {
                this._status = 2;
                view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[2]);
            }
        }
    }

    private void setMode(int mode, PhysicalView view) {
        if (mode > 6 || mode < 1 || mode == 5) {
            return;
        }
        if (mode == 2 || mode == 3 || mode == 6) {
            this._isFPort = true;
        } else if (mode == 4) {
            this._isEPort = true;
        }
        this.drawMode(MODES[mode - 1], view, false);
    }

    public boolean isFicon() {
        return false;
    }

    public String getFiconMode() {
        return "";
    }

    public boolean hasConnector() {
        return this._cause != 5;
    }

    private void drawMode(String m, PhysicalView view, boolean clear) {
        Graphics g = view.getOffscreenImage().getGraphics();
        Rectangle r = this.getRect();
        int x = r.x + (m.length() > 1 ? 2 : 6);
        int y = r.y + 11;
        if (clear) {
            g.setColor(Color.black);
            g.fillRect(x + 2, y - 8, 10, 8);
        }
        g.setFont(_ModeFont);
        g.setColor(Color.white);
        g.drawString(m, x, y);
        g.dispose();
    }

    public void resetStatus() {
        this._isFPort = false;
        this._isEPort = false;
        this._status = 0;
        this.clearTooltip();
    }

    public void clearTooltip() {
        this._toolTipText = null;
    }

    public void enableAction(PhysicalElement[] selected) {
        this.applyAll(selected, "fcQxQuailPortPhysAdminStatus", (SnmpVar)new SnmpInt(1));
    }

    public void disableAction(PhysicalElement[] selected) {
        StringBuffer sb = null;
        Array list = new Array();
        int count = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] instanceof AbstractPort && ((AbstractPort)selected[i])._status == 1) {
                if (sb == null) {
                    sb = new StringBuffer("Please confirm disabling:\n");
                } else {
                    sb.append(",");
                }
                String msg = Discover.getRoot().ifIndexToName(selected[i].getIndex()[1]);
                sb.append(msg);
                if ((count += msg.length()) > 60) {
                    count = 0;
                    sb.append("\n");
                }
            }
            list.addElement((Object)selected[i]);
        }
        if (sb != null && JOptionPane.showConfirmDialog((Component)DeviceManager.getInstance(), sb.toString(), DeviceManager.getInstance().getTitle(), 0) != 0) {
            return;
        }
        PhysicalElement[] disableList = new PhysicalElement[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            disableList[i] = (PhysicalElement)list.elementAt(i);
        }
        this.applyAll(disableList, "fcQxQuailPortPhysAdminStatus", (SnmpVar)new SnmpInt(2));
    }

    public void linkTrap(boolean up, VarBindList vbl, PhysicalView view) {
        this.resetStatus();
        super.setStatus(up ? 1 : 2, view);
        try {
            if (up) {
                this.setMode(((SnmpInt)vbl.get(4).getVar()).getValue(), view);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        view.repaint();
    }

    public int[] getStatusIndex(int[] index) {
        int[] ifIndex = new int[]{Discover.getRoot().nameToIfIndex(index[0] - 21, index[1], 1)};
        return ifIndex;
    }

    public String getBitmap() {
        return "fcport.gif";
    }

    public String getErrorBitmap() {
        return "fcporterror.gif";
    }

    public String getEditDialog() {
        return "FC_Interfaces";
    }

    public String getGraphDialog() {
        return "FC_Interface_Monitor";
    }

    public JPopupMenu getMenu() {
        if (_Menu == null) {
            _Menu = super.buildMenu();
            _Menu.addSeparator();
            JMenu beacon = new JMenu("Beacon");
            _Menu.add(beacon);
            this.addMenu(beacon, new String[][]{{"On", "beaconOnAction"}, {"Off", "beaconOffAction"}});
            JMenu loopback = new JMenu("Diagnostics");
            _Menu.add(loopback);
            this.addMenu(loopback, new String[][]{{"Internal Loopback...", "intLoopbackAction"}, {"External Loopback...", "extLoopbackAction"}});
        }
        return _Menu;
    }

    private void addMenu(JMenu menu, String[][] menuItems) {
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem mi = new JMenuItem(menuItems[i][0]);
            mi.addActionListener((ActionListener)((Object)this));
            mi.setActionCommand(menuItems[i][1]);
            menu.add(mi);
        }
    }

    public void beaconOnAction(PhysicalElement[] selected) {
        this.beaconAction(selected, true);
    }

    public void beaconOffAction(PhysicalElement[] selected) {
        this.beaconAction(selected, false);
    }

    private void beaconAction(PhysicalElement[] selected, boolean isEnable) {
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance((JFrame)DeviceManager.getInstance(), Discover.getPeer());
            for (int i = 0; i < selected.length; ++i) {
                cmdHandler.setBeacon(selected[i].getIndex()[1], isEnable);
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
        }
    }

    public void intLoopbackAction(PhysicalElement[] selected) {
        this.loopbackAction(selected, true);
    }

    public void extLoopbackAction(PhysicalElement[] selected) {
        this.loopbackAction(selected, false);
    }

    private void loopbackAction(PhysicalElement[] selected, boolean isInternalLoop) {
        if (JOptionPane.showConfirmDialog((Component)DeviceManager.getInstance(), "This will shut the requested interface\nContinue?", "Internal Loopback", 0, 2) != 0) {
            return;
        }
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance((JFrame)DeviceManager.getInstance(), Discover.getPeer());
            cmdHandler.loopbackAction(selected, isInternalLoop);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
        }
    }

    public String getToolTipText() {
        if (this._toolTipText == null) {
            StringBuffer sb = new StringBuffer(32);
            sb.append(this.toString());
            sb.append(" Status: ");
            if (this._status == 1) {
                sb.append("up");
                if (this._isEPort) {
                    sb.append(", ISL");
                } else if (this._isFPort) {
                    sb.append(", Host/Storage");
                }
            } else if (this._status == 2) {
                sb.append(MibEnum.getLabel((MibEnum[])_OperStatusReasons, (int)this._cause));
            }
            this._toolTipText = sb.toString();
        }
        return this._toolTipText;
    }

    public String toString() {
        return Discover.getRoot().ifIndexToName(this.getIndex()[1]);
    }
}

