/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvFacesPopupMenu(init) {
if (typeof(init) != "undefined") {
this.superConstructor(true);
}
}
IlvFacesPopupMenu.prototype = new IlvPopupMenu();
IlvFacesPopupMenu.prototype.setClassName("IlvFacesPopupMenu");
IlvFacesPopupMenu.prototype.createRequestURL = function (view,event,modelId) {
var bounds = view.getBounds();
var x = event.mouseX;
var y = event.mouseY;
var request = view.getRequestURL();
request += '?request='+this.factory.getRequestType();
request += '&format=html&point=('+x+','+y+')';
if (modelId != null)
request += '&modelId='+modelId;
request += "&menufactory="+escape(this.JSFRef.factory);
var layers = view.isTiled() ? view.getDynamicVisibleLayers() : view.getVisibleLayers();
var slayers = "";
var length = layers.length;
for (var i = 0;i < length;i++) {
slayers += i == 0 ? layers[i] : ',' +layers[i];
}
request += '&layer=' + escape(slayers);
var params = this.JSFRef.getActionParameters(event.mouseX, event.mouseY);
params[8] = escape(params[8]);
request += "&params=("+params[0]+","+params[1];
for (var i=2; i<params.length ; i++){
request +=","+params[i];
}
request += ")";
request += view.getAdditionalParameters();
return request;
}
function IlvFacesContextualMenuProxy (clientId, formId) {
this.superConstructor(clientId, formId);
this.setJViewsDHTMLObject(new IlvFacesPopupMenu(true));
}
IlvFacesContextualMenuProxy.prototype = new IlvAbstractPopupMenuProxy;
IlvFacesContextualMenuProxy.prototype.setClassName("IlvFacesContextualMenuProxy");
IlvFacesContextualMenuProxy.prototype.getActionParameters = function(x, y) {
var params = new Array();
var view = this.getJViewsDHTMLObject().view;
var bbox = view.getViewBBox();
x = bbox.left + x*(bbox.width/view.getWidth());
y = bbox.top + y*(bbox.height/view.getHeight());
var params = new Array();
params[0] = x;
params[1] = y
params[2] = bbox.left;
params[3] = bbox.top;
params[4] = bbox.width;
params[5] = bbox.height;
params[6] = view.getWidth();
params[7] = view.getHeight();
params[8] = this.finder;
return params;
}
IlvFacesContextualMenuProxy.prototype.adaptParameters = function (params) {
var x = params[0];
var y = params[1];
var path = params[2];
var addParams = params.slice(3);
var bParams = this.getActionParameters(x, y);
bParams[bParams.length] = path;
return bParams.concat(addParams);
}
