/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvFacesObjectSelectInteractor() {
this.superConstructor();
this.setMessage('Click on a object');
}
IlvFacesObjectSelectInteractor.prototype = new IlvInteractor();
IlvFacesObjectSelectInteractor.prototype.setClassName("IlvFacesObjectSelectInteractor");
IlvFacesObjectSelectInteractor.prototype.setView = function(view) {
if (view != null) {
this.JSFRef.setViewId(view.JSFRef.getAbsoluteId());
}
}
IlvFacesObjectSelectInteractor.prototype.mouseDown = function(e) {
if (e.button != 2) {
var view = this.view;
var x = e.mouseX;
var y = e.mouseY;
var bbox = view.getViewBBox();
x = bbox.left + x*(bbox.width/view.getWidth());
y = bbox.top + y*(bbox.height/view.getHeight());
var params = [];
params[0] = x;
params[1] = y
params[2] = bbox.left;
params[3] = bbox.top;
params[4] = bbox.width;
params[5] = bbox.height;
params[6] = view.getWidth();
params[7] = view.getHeight();
if (this.JSFRef.invocationContext == "IMAGE_SERVLET_CONTEXT") {
params[8] = this.JSFRef.methodRef;
params[9] = this.JSFRef.finder;
params[10] = this.JSFRef.listenersRef;
this.view.performAction("facesServletAction", params, true);
} else {
if (view.isTiled()) {
var layers = view.getDynamicVisibleLayers();
var slayers = "";
var length = layers.length;
for (var i = 0; i <length; i++) {
slayers += i ==0 ? layers[i] : ',' + layers[i];
}
params[8] = escape(slayers);
}
this.JSFRef.performSelect(params);
}
}
return false;
}
function IlvFacesObjectSelectInteractorProxy (clientId, formId) {
if (clientId) {
this.superConstructor(clientId, formId);
var inter = new IlvFacesObjectSelectInteractor();
inter.JSFRef = this;
this.setJViewsDHTMLObject(inter);
}
}
IlvFacesObjectSelectInteractorProxy.prototype = new IlvObjectSelectInteractorProxy;
IlvFacesObjectSelectInteractorProxy.prototype.setClassName("IlvFacesObjectSelectInteractorProxy");
