/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvFacesViewProxy (clientId, refNodeId, width, height, additionnalParams) {
this.superConstructor(clientId);
if (clientId) {
var size = this.getCreationSize(refNodeId, width, height);
var view = this.createInstance([size.width, size.height, additionnalParams]);
this.setJViewsDHTMLObject(view);
this.setServletClass("ilog.views.faces.dhtml.servlet.IlvFacesManagerServlet");
this.registerResizeListener(view);
view.setStateInCookie(false);
view.saveState = IlvFacesViewProxy.saveState;
view.restoreState = IlvFacesViewProxy.restoreState;
this.addRequestParameters();
}
}
IlvFacesViewProxy.prototype = new IlvBasicViewProxy;
IlvFacesViewProxy.prototype.setClassName("IlvFacesViewProxy");
IlvFacesViewProxy.prototype.createInstance = function (params) {
return new IlvFacesView(0, 0, params[0], params[1]);
}
IlvFacesViewProxy.prototype.setStateURL = function (state) {
this.stateURL = state;
this.notify("StateURL");
}
IlvFacesViewProxy.prototype.getStateURL = function () {
return this.stateURL;
}
IlvFacesViewProxy.prototype.setResizable = function (resizable) {
this.getJViewsDHTMLObject().setResizable(resizable);
this.notify("Resizable");
}
IlvFacesViewProxy.prototype.isResizable = function (resizable) {
return this.getJViewsDHTMLObject().isResizable();
}
IlvFacesViewProxy.saveState = function (view) {
var proxy = view.JSFRef;
var state = unescape(view.getRequest());
if (state) {
state = escape(state);
proxy.setStateURL(state);
}
}
IlvFacesViewProxy.restoreState = function (view) {
var proxy = view.JSFRef;
var state = proxy.getStateURL();
if (state) {
state = unescape(state);
view.initFromUrl(state);
view.capabilitiesListeners.notify(view);
var layer = view.parseValue(state, 'layer');
if (layer == 'init') {
for (var i = 0;i < view.allLayers.length;i++)
view.visibleLayers[i] = true;
}
var bbox = view.parseValue(state, 'bbox');
if (bbox == 'init') {
view.showAll();
} else {
view.recenter();
view.updateImage();
}
} else {
view.capabilitiesListeners.notify(view);
view.showAll();
}
}
IlvFacesViewProxy.prototype.setInteractor = function (interactor) {
this.interactor = interactor;
this.getJViewsDHTMLObject().setInteractor(interactor.getJViewsDHTMLObject());
this.notify("InteractorId");
}
IlvFacesViewProxy.prototype.getInteractor = function () {
return this.interactor;
}
IlvFacesViewProxy.prototype.getInteractorId = function () {
return this.interactor.getAbsoluteId();
}
IlvFacesViewProxy.prototype.getZoomFactor = function () {
return this.getJViewsDHTMLObject().getZoomFactor();
}
IlvFacesViewProxy.prototype.setZoomFactor = function (zoomFactor) {
this.getJViewsDHTMLObject().setZoomFactor(zoomFactor);
this.notify("ZoomFactor");
}
IlvFacesViewProxy.prototype.zoomIn = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomIn();
if(updateImage)
view.updateImage();
}
IlvFacesViewProxy.prototype.zoomOut = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomOut();
if(updateImage)
view.updateImage();
}
IlvFacesViewProxy.prototype.zoomBy = function (amount, updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomBy(amount);
if(updateImage)
view.updateImage();
}
IlvFacesViewProxy.prototype.showAll = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.showAll();
if(updateImage)
view.updateImage();
}
IlvFacesViewProxy.prototype.getPanFactor = function () {
return this.getJViewsDHTMLObject().getPanFactor();
}
IlvFacesViewProxy.prototype.setPanFactor = function (panFactor) {
this.getJViewsDHTMLObject().setPanFactor(panFactor);
this.notify("PanFactor");
}
IlvFacesViewProxy.prototype.getUpdateInterval = function () {
return this.getJViewsDHTMLObject().getUpdateInterval();
}
IlvFacesViewProxy.prototype.setUpdateInterval = function (updateInterval) {
this.getJViewsDHTMLObject().setUpdateInterval(updateInterval);
this.notify("UpdateInterval");
}
IlvFacesViewProxy.prototype.getImageFormat = function () {
return this.getJViewsDHTMLObject().getImageFormat();
}
IlvFacesViewProxy.prototype.setImageFormat = function (imageFormat) {
this.getJViewsDHTMLObject().setImageFormat(imageFormat);
this.notify("ImageFormat");
}
IlvFacesViewProxy.prototype.getWaitingImage = function () {
return this.getJViewsDHTMLObject().getWaitingImage();
}
IlvFacesViewProxy.prototype.setWaitingImage = function (waitingImage) {
this.getJViewsDHTMLObject().setWaitingImage(waitingImage);
this.notify("WaitingImage");
}
IlvFacesViewProxy.prototype.getGenerateImageMap = function () {
return this.getJViewsDHTMLObject().getGenerateImageMap();
}
IlvFacesViewProxy.prototype.setGenerateImageMap = function (generateImageMap) {
this.getJViewsDHTMLObject().setGenerateImageMap(generateImageMap);
this.notify("GenerateImageMap");
}
IlvFacesViewProxy.prototype.getImageMapVisible = function () {
return this.getJViewsDHTMLObject().imageMapVisible;
}
IlvFacesViewProxy.prototype.setImageMapVisible = function (imageMapVisible) {
if (imageMapVisible)
this.getJViewsDHTMLObject().showImageMap();
else
this.getJViewsDHTMLObject().hideImageMap();
this.notify("ImageMapVisible");
}
IlvFacesViewProxy.prototype.getImageMapGenerator = function () {
return this.imageMapGenerator;
}
IlvFacesViewProxy.prototype.setImageMapGenerator = function (imageMapGenerator) {
this.imageMapGenerator = imageMapGenerator;
this.notify("ImageMapGenerator");
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("imapGenerator", imageMapGenerator);
}
IlvFacesViewProxy.prototype.getBackgroundColor = function () {
return this.getJViewsDHTMLObject().getImageBackgroundColor();
}
IlvFacesViewProxy.prototype.setBackgroundColor = function (backgroundColor) {
this.getJViewsDHTMLObject().setImageBackgroundColor(backgroundColor);
this.notify("BackgroundColor");
}
IlvFacesViewProxy.prototype.getOnImageLoaded = function () {
return this.onImageLoaded;
}
IlvFacesViewProxy.prototype.setOnImageLoaded = function (onImageLoaded) {
this.onImageLoaded = onImageLoaded;
this.getJViewsDHTMLObject().addImageOnLoadListener(onImageLoaded);
this.notify("OnImageLoaded");
}
IlvFacesViewProxy.prototype.getOnCapabilitiesLoaded = function () {
return this.capabilitiesLoaded;
}
IlvFacesViewProxy.prototype.setOnCapabilitiesLoaded = function (onCapabilitiesLoaded) {
this.capabilitiesLoaded = onCapabilitiesLoaded;
this.getJViewsDHTMLObject().addCapabilitiesOnLoadListener(onCapabilitiesLoaded);
this.notify("OnCapabilitiesLoaded");
}
IlvFacesViewProxy.prototype.getErrorMessage = function () {
return this.getJViewsDHTMLObject().getErrorMessage();
}
IlvFacesViewProxy.prototype.setErrorMessage = function (errorMessage) {
this.getJViewsDHTMLObject().setErrorMessage(errorMessage);
this.notify("ErrorMessage");
}
IlvFacesViewProxy.prototype.getServlet = function () {
return this.getServletClass();
}
IlvFacesViewProxy.prototype.setServlet = function (servlet) {
this.setServletClass(servlet);
this.notify("Servlet");
}
IlvFacesViewProxy.prototype.setServletURL = function (servletURL) {
this.getJViewsDHTMLObject().setRequestURL(servletURL);
this.notify("ServletURL");
}
IlvFacesViewProxy.prototype.getServletURL = function () {
return this.getJViewsDHTMLObject().getRequestURL();
}
IlvFacesViewProxy.prototype.performAction = function (action, params) {
this.getJViewsDHTMLObject().performAction(action, params);
}
IlvFacesViewProxy.prototype.updateImage = function() {
this.getJViewsDHTMLObject().updateImage();
}
IlvFacesViewProxy.prototype.setAutoUpdateCapabilities = function(update) {
this.getJViewsDHTMLObject().setAutoUpdateCapabilities(update);
this.notify("AutoUpdateCapabilities");
}
IlvFacesViewProxy.prototype.isAutoUpdateCapabilities = function() {
return this.getJViewsDHTMLObject().isAutoUpdateCapabilities();
}
IlvFacesViewProxy.prototype.setStaticLayersCount = function (slc) {
this.staticLayersCount = slc;
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("slc", slc);
}
IlvFacesViewProxy.prototype.updateAll = function (showAll, keepLayerVisibility) {
var view = this.getJViewsDHTMLObject();
view.updateAll(showAll, keepLayerVisibility);
}
IlvFacesViewProxy.prototype.moveTo = function(x, y) {
this.getJViewsDHTMLObject().moveTo(x, y);
}
IlvFacesViewProxy.prototype.panEast = function() {
this.getJViewsDHTMLObject().panEast();
}
IlvFacesViewProxy.prototype.panWest = function() {
this.getJViewsDHTMLObject().panWest();
}
IlvFacesViewProxy.prototype.panSouth = function() {
this.getJViewsDHTMLObject().panSouth();
}
IlvFacesViewProxy.prototype.panNorth = function() {
this.getJViewsDHTMLObject().panNorth();
}
IlvFacesViewProxy.prototype.panSouthEast = function() {
this.getJViewsDHTMLObject().panSouthEast();
}
IlvFacesViewProxy.prototype.panNorthEast = function() {
this.getJViewsDHTMLObject().panNorthEast();
}
IlvFacesViewProxy.prototype.panSouthWest = function() {
this.getJViewsDHTMLObject().panSouthWest();
}
IlvFacesViewProxy.prototype.panNorthWest = function() {
this.getJViewsDHTMLObject().panNorthWest();
}
IlvFacesViewProxy.prototype.setPopupMenu = function(popupMenu) {
this.getJViewsDHTMLObject().setPopupMenu(popupMenu.getJViewsDHTMLObject());
}
IlvFacesViewProxy.prototype.getPopupMenu = function(popupMenu) {
return this.getJViewsDHTMLObject().getPopupMenu();
}
IlvFacesViewProxy.prototype.addRequestParameters = function() {
this.superInvoke("addRequestParameters");
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("facesComponentId", this.clientId);
}
IlvFacesViewProxy.prototype.setMaxZoomLevel = function(maxZoomLevel) {
this.maxZoomLevel = maxZoomLevel;
if (maxZoomLevel) {
this.notify("MaxZoomLevel");
}
}
IlvFacesViewProxy.prototype.getMaxZoomLevel = function() {
return this.maxZoomLevel;
}
IlvFacesViewProxy.prototype.setZoomLevels = function(zoomLevels) {
this.zoomLevels = zoomLevels;
if(zoomLevels) {
this.notify("ZoomLevels");
}
}
IlvFacesViewProxy.prototype.getZoomLevels = function() {
return this.zoomLevels;
}
IlvFacesViewProxy.prototype.performJSFAction = function(mb, params) {
var p = params ? [mb].concat(params) : [mb];
this.performAction("jsfAction", p);
}
IlvFacesViewProxy.prototype.setNamespace = function(namespace) {
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("namespace", namespace);
}
