/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvSizedViewProxy (clientId) {
this.superConstructor(clientId);
this.minWidth = 100;
this.minHeight = 100;
IlvSizedViewProxy.instances[this.toString()] = this;
}
IlvSizedViewProxy.prototype = new IlvFacesProxy;
IlvSizedViewProxy.prototype.setClassName("IlvSizedViewProxy");
IlvSizedViewProxy.instances = [];
IlvSizedViewProxy.prototype.setMinimumSize = function (minWidth, minHeight) {
this.minWidth = minWidth;
this.minHeight = minHeight;
}
IlvSizedViewProxy.prototype.getMinimumSize = function () {
var size = new Object();
size.minWidth = this.minWidth;
size.minHeight = this.minHeight;
return size;
}
IlvSizedViewProxy.prototype.getCreationSize = function (refNodeId, serverW, serverH) {
var refNode = document.getElementById(refNodeId);
this.setReferenceNode(refNode);
var size = new Object();
var w = serverW;
var h = serverH;
if (serverW && serverW >= this.minWidth)
this.widthSet = true;
else {
w = refNode.offsetWidth;
if (w <= this.minWidth) {
w = this.minWidth;
}
}
if (serverH && serverH >= this.minHeight)
this.heightSet = true;
else {
h = refNode.offsetHeight;
if (h <= this.minHeight) {
h = this.minHeight;
}
}
if (!refNode.style.position || refNode.style.position == "static")
refNode.style.position = "relative";
size.width = w;
size.height = h;
return size;
}
IlvSizedViewProxy.prototype.positionAfterLayout = function (width, height) {
var pos = new Object ();
pos.x = 0;
pos.y = 0;
return pos;
}
IlvSizedViewProxy.prototype.resizeAfterLayout = function (init) {
var w = this.refNode.offsetWidth;
var h = this.refNode.offsetHeight;
var resize = false;
if (w < this.minWidth && w != 0) {
w = this.minWidth;
this.refNode.style.width=this.minWidth+"px";
resize = true;
}
if (h < this.minHeight && h != 0) {
h = this.minHeight;
this.refNode.style.height=this.minHeight+"px";
resize = true;
}
if (resize || !this.widthSet || !this.heightSet){
var pos = this.positionAfterLayout(w, h);
this.getJViewsDHTMLObject().updateOnResizeLock=true;
var b = this.getJViewsDHTMLObject().getBounds();
this.getJViewsDHTMLObject().setBounds(pos.x, pos.y, w, h);
resize = b.left != pos.x || b.top != pos.y || b.width != w || b.height != h;
this.getJViewsDHTMLObject().updateOnResizeLock=false;
}
this.getJViewsDHTMLObject().updateOnResizeLock=true;
this.afterLayoutHandler(resize);
this.getJViewsDHTMLObject().updateOnResizeLock=false;
this.layoutDone = true;
IlvPanel.visibilityLock = false;
this.getJViewsDHTMLObject().updateVisibility();
if (init || resize) {
this.init();
}
}
IlvSizedViewProxy.prototype.afterLayoutHandler = function (resized) {
}
IlvSizedViewProxy.prototype.init = function () {
if (this.getJViewsDHTMLObject().init)
this.getJViewsDHTMLObject().init();
}
IlvSizedViewProxy.prototype.getAbsoluteBounds = function () {
var r = this.refNode;
var res = new Object();
res.left = r.offsetLeft;
res.top = r.offsetTop;
res.width = r.offsetWidth;
res.height = r.offsetHeight;
return res;
}
IlvSizedViewProxy.prototype.getBounds = function () {
return this.getJViewsDHTMLObject().getBounds();
}
IlvSizedViewProxy.prototype.getWidth = function () {
return this.getJViewsDHTMLObject().getWidth();
}
IlvSizedViewProxy.prototype.getHeight = function () {
return this.getJViewsDHTMLObject().getHeight();
}
IlvSizedViewProxy.prototype.registerResizeListener = function(jviewsObject) {
jviewsObject.addSizeListener(IlvSizedViewProxy.onResize);
}
IlvSizedViewProxy.onResize = function (view) {
if (!view.updateOnResizeLock) {
var proxy = view.JSFRef;
proxy.resize(view.getWidth(), view.getHeight());
proxy.notify("Width");
proxy.notify("Height");
}
}
IlvSizedViewProxy.prototype.startResizeTimer = function (view) {
if (this.resizeTimer) {
clearTimeout(this.resizeTimer);
}
this.resizeTimer = setTimeout("IlvSizedViewProxy.instances['"+this.toString()+"'].resizeAfterLayout(false)", 100);
}
function IlvSizedViewProxyLoad(object) {
object.resizeAfterLayout(true);
}
function IlvSizedViewProxyResize(object) {
object.startResizeTimer();
}
