/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvGlassView(left, top, width, height) {
this.superConstructor(left, top, width, height);
this.visible = true;
this.enabled = true;
this.cursor = 'auto';
this.tooltip = '';
this.registerDispose();
}
if (!window.IlvEmptyView) {
alert("IlvGlassView requires IlvEmptyView");
}
IlvGlassView.prototype = new IlvEmptyView;
IlvGlassView.prototype.setClassName("IlvGlassView");
IlvGlassView.prototype.traceEvents = false;
IlvGlassView.prototype.traceCount = 0;
IlvGlassView.prototype.removeHTML = function () {
if (this.eventPanel) {
this.eventPanel.removeHTML();
}
}
IlvGlassView.prototype.updateVisibility = function (){
if (this.eventPanel) {
this.eventPanel.updateVisibility();
}
}
IlvGlassView.prototype.dispose = function() {
var eventSource = this.getMouseEventSource();
this.superInvoke("dispose");
document._view = null;
this.eventHandler = null;
if (eventSource != null) {
if (eventSource.removeEventListener) {
eventSource.removeEventListener("keypress",  IlvGlassView.prototype._keyPress,  true);
eventSource.removeEventListener("keyup",  IlvGlassView.prototype._keyUp,  true);
eventSource.removeEventListener("keydown",  IlvGlassView.prototype._keyDown,  true);
eventSource.removeEventListener("mousedown", IlvGlassView.prototype._mouseDown, true);
eventSource.removeEventListener("mousemove", IlvGlassView.prototype._mouseMove, true);
eventSource.removeEventListener("mouseover", IlvGlassView.prototype._mouseOver, true);
eventSource.removeEventListener("mouseout",  IlvGlassView.prototype._mouseOut,  true);
eventSource.removeEventListener("DOMMouseScroll",  IlvGlassView.prototype._mouseWheel,  true);
} else {
eventSource.onkeypress  = null;
eventSource.onkeyup  = null;
eventSource.onkeydown  = null;
eventSource.onmousedown = null;
eventSource.onmousemove = null;
eventSource.onmouseover = null;
eventSource.onmouseout  = null;
eventSource.onmousewheel = null;
}
eventSource._view = null;
}
}
IlvGlassView.prototype.getToolTipText = function() {
return this.tooltip;
}
IlvGlassView.prototype.setToolTipText = function(string) {
this.tooltip = string || '';
if (!this.content) {
this.updateEventPanelContent();
}
}
IlvGlassView.prototype.isVisible = function () {
return this.visible;
}
IlvGlassView.prototype.setVisible = function(visible) {
if (this.visible == visible) {
return;
}
this.visible = visible;
if (this.eventPanel) {
this.eventPanel.setVisible(visible);
}
}
IlvGlassView.prototype.isEnabled = function() {
return this.enabled;
}
IlvGlassView.prototype.setEnabled = function(enabled) {
this.enabled = enabled;
}
IlvGlassView.prototype.getCursor = function() {
return this.cursor;
}
IlvGlassView.prototype.setCursor = function(cursor) {
this.cursor = cursor;
if (this.eventPanel) {
this.eventPanel.setCursor(cursor);
}
}
IlvGlassView.prototype.setZIndex = function (zindex) {
if (this.eventPanel) {
this.eventPanel.setZIndex(zindex);
}
}
IlvGlassView.prototype.setBackgroundColor = function (color) {
this.bgColor = color;
if (this.eventPanel) {
this.eventPanel.setBackgroundColor(color);
}
}
IlvGlassView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
var eventPanel = this.eventPanel;
if (eventPanel) {
if (this._resized) {
eventPanel.setBounds(left, top, width, height);
this.updateEventPanelContent();
} else {
eventPanel.setLocation(left, top);
}
}
}
IlvGlassView.prototype.setContent = function(content, onContentSet) {
this.content = content;
this.updateEventPanelContent(onContentSet);
}
IlvGlassView.prototype.getContent = function() {
if (this.content) {
return this.content;
}
var content = '<img align="top" border=0 ' +
'width="' + this.getWidth() + '" ' +
'height="' + this.getHeight() + '" ' +
'src="' + ilvImagePath + 'empty.gif" '+
'galleryimg="false" ';
if (this.tooltip != '') {
content += 'ALT="' + this.tooltip + '" TITLE="' + this.tooltip+'" ';
}
content += '>';
return content;
}
IlvGlassView.prototype.updateEventPanelContent = function(onContentSet) {
if (this.eventPanel) {
this.eventPanel.setContent(this.getContent(), onContentSet);
} else {
if (onContentSet) {
eval(onContentSet);
}
}
}
IlvGlassView.prototype.childrenToHTML = function() {
this.superInvoke("childrenToHTML");
this.eventPanel = new IlvHTMLPanel(this.getContent());
this.eventPanel.getMouseEventSource().tabIndex = -1;
this.eventPanel.setZIndex(4);
this.eventPanel.setBounds(this.left, this.top, this.width, this.height);
this.eventPanel.setVisible(this.isVisible());
this.eventPanel.setCursor(this.getCursor());
if (this.bgColor) {
this.eventPanel.setBackgroundColor(this.bgColor);
}
this.enableEventCapture();
}
IlvGlassView.prototype.enableEventCapture = function() {
var eventSource = this.getMouseEventSource();
eventSource._view = this;
if (eventSource.addEventListener) {
eventSource.addEventListener("keypress",  IlvGlassView.prototype._keyPress,  true);
eventSource.addEventListener("keyup",  IlvGlassView.prototype._keyUp,  true);
eventSource.addEventListener("keydown",  IlvGlassView.prototype._keyDown,  true);
eventSource.addEventListener("mousedown", IlvGlassView.prototype._mouseDown, true);
eventSource.addEventListener("mousemove", IlvGlassView.prototype._mouseMove, true);
eventSource.addEventListener("mouseover", IlvGlassView.prototype._mouseOver, true);
eventSource.addEventListener("mouseout",  IlvGlassView.prototype._mouseOut,  true);
eventSource.addEventListener("draggesture",  IlvGlassView.prototype._dummy,  false);
eventSource.addEventListener("dragover",  IlvGlassView.prototype._dummy,  false);
eventSource.addEventListener("dragenter",  IlvGlassView.prototype._dummy,  false);
eventSource.addEventListener("dragexit",  IlvGlassView.prototype._dummy,  false);
eventSource.addEventListener("DOMMouseScroll", IlvGlassView.prototype._mouseWheel, true);
} else {
eventSource.onkeypress  = IlvGlassView.prototype._keyPress;
eventSource.onkeyup  = IlvGlassView.prototype._keyUp;
eventSource.onkeydown  = IlvGlassView.prototype._keyDown;
eventSource.onmousedown = IlvGlassView.prototype._mouseDown;
eventSource.onmousemove = IlvGlassView.prototype._mouseMove;
eventSource.onmouseover = IlvGlassView.prototype._mouseOver;
eventSource.onmouseout  = IlvGlassView.prototype._mouseOut;
eventSource.onmousewheel = IlvGlassView.prototype._mouseWheel;
}
}
IlvGlassView.prototype.disableEventCapture = function() {
var eventSource = this.getMouseEventSource();
if (eventSource.removeEventListener) {
eventSource.removeEventListener("keypress",  IlvGlassView.prototype._keyPress,  true);
eventSource.removeEventListener("keyup",  IlvGlassView.prototype._keyUp,  true);
eventSource.removeEventListener("keydown",  IlvGlassView.prototype._keyDown,  true);
eventSource.removeEventListener("mousedown", IlvGlassView.prototype._mouseDown, true);
eventSource.removeEventListener("mousemove", IlvGlassView.prototype._mouseMove, true);
eventSource.removeEventListener("mouseover", IlvGlassView.prototype._mouseOver, true);
eventSource.removeEventListener("mouseout",  IlvGlassView.prototype._mouseOut,  true);
eventSource.removeEventListener("DOMMouseScroll", IlvGlassView.prototype._mouseWheel, true);
} else {
eventSource.onkeypress  = null;
eventSource.onkeyup  = null;
eventSource.onkeydown  = null;
eventSource.onmousedown = null;
eventSource.onmousemove = null;
eventSource.onmouseover = null;
eventSource.onmouseout  = null;
eventSource.onmousewheel = null;
}
eventSource._view = null;
}
IlvGlassView.prototype._dummy = function(event) {
if (event && event.stopPropagation) {
event.stopPropagation();
}
return false;
}
IlvGlassView.prototype.getEventOriginLeft = function() {
return this.left;
}
IlvGlassView.prototype.getEventOriginTop = function() {
return this.top;
}
IlvGlassView.prototype.setEventHandler = function(eventHandler) {
this.eventHandler = eventHandler;
}
IlvGlassView.prototype.getEventHandler = function() {
return this.eventHandler;
}
IlvGlassView.prototype.getMouseEventSource = function() {
if (this.eventPanel) {
return this.eventPanel.getMouseEventSource();
} else {
return null;
}
}
IlvGlassView.prototype.setReferenceNode = function (node){
if (node) {
this.relativePosition = true;
this.refNode = node;
} else {
this.relativePosition = false;
this.refNode = "";
}
}
IlvGlassView.prototype.getNodeCoords = function (obj) {
var curObject = obj;
var xposition=0;
var yposition=0;
while( curObject.tagName!='BODY' && curObject.tagName!='HTML'){
xposition += curObject.offsetLeft;
yposition += curObject.offsetTop;
curObject=curObject.offsetParent;
}
if ( obj.dir == 'rtl' ) {
xposition += obj.text.offsetWidth-obj.div.offsetWidth;
}
return {left: xposition, top:yposition};
}
IlvGlassView.prototype.enhanceEvent = function(e, forceClone) {
var mouseX;
var mouseY;
if (e) {
mouseX = e.pageX;
mouseY = e.pageY;
if (forceClone) {
e = this.cloneEvent(e);
}
} else {
if (forceClone) {
e = this.cloneEvent(event);
} else {
e = event;
}
var doc = document;
var de = doc.documentElement.clientWidth?doc.documentElement:doc.body;
mouseX = e.clientX + de.scrollLeft;
mouseY = e.clientY + de.scrollTop;
if (document.body.clientLeft) {
mouseX -= document.body.clientLeft;
}
if (document.body.clientTop) {
mouseY -= document.body.clientTop;
}
}
mouseX -= this.getEventOriginLeft();
mouseY -= this.getEventOriginTop();
if (this.relativePosition) {
var pos = this.getNodeCoords(this.refNode);
mouseX -= pos.left;
mouseY -= pos.top;
}
e.mouseX = mouseX;
e.mouseY = mouseY;
return e;
}
IlvGlassView.prototype.cloneEvent = function (e) {
var clone = new Object();
clone.altKey = e.altKey;
clone.ctrlKey = e.ctrlKey;
clone.shiftKey = e.shiftKey;
clone.type = e.type;
clone.screenX = e.screenX;
clone.screenY = e.screenY;
clone.button = e.button;
clone.keyCode = e.keyCode;
clone.clientX = e.clientX;
clone.clientY = e.clientY;
return clone;
}
IlvGlassView.prototype._enhanceKeyEvent = function (e) {
if (e) {
if (typeof(e.keyCode) == "undefined") {
e.keyCode = e.which;
} else if (e.keyCode == 0) {
var fakeevent = { altKey : e.altKey,
ctrlKey : e.ctrlKey,
metaKey : e.metaKey,
shiftKey : e.shiftKey,
keyCode : e.charCode };
e = fakeevent;
}
} else {
e = window.event;
}
return e;
}
IlvGlassView.prototype._keyPress = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return false;
}
if (view.traceEvents) {
window.status = "Key Press " +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.keyPress;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.keyPress(view._enhanceKeyEvent(e));
}
return false;
}
IlvGlassView.prototype._keyUp = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return false;
}
if (view.traceEvents) {
window.status = "Key Up " +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.keyUp;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.keyUp(view._enhanceKeyEvent(e));
}
return false;
}
IlvGlassView.prototype._keyDown = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return false;
}
if (view.traceEvents) {
window.status = "Key Down " +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.keyDown;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.keyDown(view._enhanceKeyEvent(e));
}
return false;
}
IlvGlassView.prototype._mouseDown = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return false;
}
if (view.traceEvents) {
window.status = "Mouse Down " +
(++view.traceCount) + " on " + this + ", " + view;
}
view._dragging = true;
view._draggingButton = e ? e.button: event.button;
document._view = view;
if (document.addEventListener) {
document.addEventListener("mouseup",   IlvGlassView.prototype._mouseUp,   true);
document.addEventListener("mousemove", IlvGlassView.prototype._mouseMove, true);
} else {
if (document.onmouseup != null) {
view._oldmouseup = document.onmouseup;
}
if (document.onmousemove != null) {
view._oldmousemove = document.onmousemove;
}
document.onmouseup = IlvGlassView.prototype._mouseUp;
document.onmousemove = IlvGlassView.prototype._mouseMove;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.mouseDown;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseDown(view.enhanceEvent(e));
}
return false;
}
IlvGlassView.prototype._mouseMove = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return true;
}
if (view.traceEvents) {
window.status = "Mouse " +
(view._dragging ? "Drag " : "Move ") +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return !view._dragging;
}
if (view._dragging) {
var handlerFunc = handler.mouseDrag;
if (handlerFunc && typeof(handlerFunc) == 'function') {
var newEvent = view.enhanceEvent(e, true);
newEvent.button = view._draggingButton;
handler.mouseDrag(newEvent);
}
} else {
var handlerFunc = handler.mouseMove;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseMove(view.enhanceEvent(e));
}
}
return !view._dragging;
}
IlvGlassView.prototype._mouseUp = function(e) {
var view = this._view;
if (view == null) {
return true;
}
if (view.traceEvents && view.enabled) {
window.status = "Mouse Up " +
(++view.traceCount) + " on " + this + ", " + view;
}
view._dragging = false;
if (document.addEventListener) {
document.removeEventListener("mouseup",   IlvGlassView.prototype._mouseUp,   true);
document.removeEventListener("mousemove", IlvGlassView.prototype._mouseMove, true);
} else {
if (view._oldmouseup) {
document.onmouseup = view._oldmouseup;
}
if (view._oldmousemove) {
document.onmousemove = view._oldmousemove;
}
}
document._view = null;
if (!view.enabled) {
return false;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.mouseUp;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseUp(view.enhanceEvent(e));
}
return false;
}
IlvGlassView.prototype._mouseOver = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return;
}
if (view.traceEvents) {
window.status = "Mouse Over " +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return;
}
if (IlvBrowserInfo.instance.nav6up) {
this.focus();
}
var handlerFunc = handler.mouseOver;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseOver(view.enhanceEvent(e));
}
return false;
}
IlvGlassView.prototype._mouseOut = function(e) {
var view = this._view;
if (view == null || !view.enabled) {
return;
}
if (view.traceEvents) {
window.status = "Mouse Out " +
(++view.traceCount) + " on " + this + ", " + view;
}
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
var handlerFunc = handler.mouseOut;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseOut(view.enhanceEvent(e));
}
return false;
}
IlvGlassView.prototype._mouseWheel = function(e) {
var view = this._view;
if (view == null || !view.enabled)
return;
var handler = view.getEventHandler();
if (handler == null) {
return false;
}
if (!e){
e = window.event;
}
if (e.wheelDelta) {
delta = e.wheelDelta/120;
} else if (e.detail) {
delta = -e.detail;
}
if (delta) {
var event = {wheelDelta: delta};
var handlerFunc = handler.mouseWheel;
if (handlerFunc && typeof(handlerFunc) == 'function') {
handler.mouseWheel(event);
if (e.preventDefault) {
e.preventDefault();
}
}
}
return false;
}
