/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvImageView(left, top, width, height, image) {
this.superConstructor(left, top, width, height);
IlvImageView.instances[this.toString()] = this;
this.imageSrc = image;
this.imageState = IlvImageView.NOT_LOADED;
this.cursor = 'auto';
this.visible = true;
this.tooltip = '';
this.imageWidth = -1;
this.imageHeight = -1;
this.scrollX = 0;
this.scrollY = 0;
this.imageID = this.toString() + "IMG";
this.blendTransform = true;
this.imageScrollListeners = new IlvListenerList();
this.imageLoadingListeners = new IlvListenerList();
this.imagePreloadListeners = new IlvListenerList();
this.imageLoadListeners = new IlvListenerList();
this.errorListeners = new IlvListenerList();
this.timeoutListeners = new IlvListenerList();
this.timeout = 600;
this.registerDispose();
}
if (!window.IlvEmptyView)
alert("IlvImageView requires IlvEmptyView");
IlvImageView.prototype = new IlvEmptyView;
IlvImageView.prototype.setClassName("IlvImageView");
IlvImageView.prototype.traceImage = false;
IlvImageView.prototype.traceImageLoading = false;
IlvImageView.prototype.traceUpdateContent = false;
IlvImageView.instances = new Array();
IlvImageView.NOT_LOADED = 0;
IlvImageView.LOADING = 1;
IlvImageView.LOADED = 2;
IlvImageView.ERROR = 3;
IlvImageView.prototype.dispose = function() {
this.superInvoke("dispose");
this.abortImage();
var image = getImage(this.imageID);
if (image)
disposeImageSource(image);
IlvImageView.instances[this.toString()] = null;
}
IlvImageView.prototype.removeHTML = function () {
this.imagePanel.removeHTML();
}
IlvImageView.prototype.updateVisibility = function (){
this.imagePanel.updateVisibility();
}
IlvImageView.prototype.getToolTipText = function() {
return this.tooltip;
}
IlvImageView.prototype.setToolTipText = function(string) {
this.tooltip = string || '';
if (this.imagePanel) {
if (IlvBrowserInfo.instance.nav4) {
this.updateImagePanelContent();
} else if (IlvBrowserInfo.instance.nav6up){
var currentImage = getImage(this.imageID);
currentImage.title = string;
} else {
var currentImage = getImage(this.imageID);
currentImage.alt = string;
}
}
}
IlvImageView.prototype.isVisible = function () {
return this.visible;
}
IlvImageView.prototype.setVisible = function(visible) {
this.visible = visible;
if (this.imagePanel) {
if (!visible || this.isImageLoaded())
this.imagePanel.setVisible(visible);
}
}
IlvImageView.prototype.getCursor = function() {
return this.cursor;
}
IlvImageView.prototype.setCursor = function(cursor) {
this.cursor = cursor;
if (this.imagePanel)
this.imagePanel.setCursor(cursor);
}
IlvImageView.prototype.setBackgroundColor = function (color) {
this.bgColor = color;
if (this.imagePanel)
this.imagePanel.setBackgroundColor(color);
}
IlvImageView.prototype.setImageState = function(state) {
if (this.imageState == state)
return;
this.imageState = state;
if (state == IlvImageView.LOADING)
this.imageLoadingListeners.notify(this);
}
IlvImageView.prototype.isImageLoaded = function () {
return this.imageState == IlvImageView.LOADED;
}
IlvImageView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
var imagePanel = this.imagePanel;
if (imagePanel) {
if (this._resized) {
imagePanel.setBounds(left, top, width, height);
if (this.imageWidth < 0 || this.imageHeight < 0)
this.updateImagePanelContent();
} else {
imagePanel.setLocation(left, top);
}
}
}
IlvImageView.prototype.childrenToHTML = function() {
this.imagePanel = new IlvHTMLPanel(this.getHTMLContent());
this.imagePanel.setBounds(this.left, this.top, this.width, this.height);
if (this.scrollX != 0 || this.scrollY != 0)
this.imagePanel.setScrollPosition(this.scrollX, this.scrollY);
this.imagePanel.setCursor(this.getCursor());
if (this.bgColor)
this.imagePanel.setBackgroundColor(this.bgColor);
if (this.imageSrc) {
this.loadImage();
}
}
IlvImageView.prototype.getHTMLContent = function() {
var content = '<img align="top" border=0 ' +
'id="'   + this.imageID + '" ' +
'name="' + this.imageID + '" ' +
'galleryimg="false" ';
var w = this.imageWidth  >= 0 ? this.imageWidth  : this.getWidth();
var h = this.imageHeight >= 0 ? this.imageHeight : this.getHeight();
content += 'width=' + w + ' height=' + h + ' ';
content += 'src="'+ilvImagePath + 'empty.gif" ';
if (this.tooltip != '') {
content += 'alt="' + this.tooltip + '" title="' + this.tooltip+'" ';
}
content += '>';
return content;
}
IlvImageView.prototype.updateImagePanelContent = function(skipImageRedisplay) {
if (!this.imagePanel)
return;
trace(this.traceUpdateContent, "updateContent, skipRedisplay", this, skipImageRedisplay);
this.imagePanel.setVisible(false);
this.setImageState(this.imageSrc ? IlvImageView.LOADING : IlvImageView.NOT_LOADED);
if (this.imageSrc && !skipImageRedisplay)
var onImageTagChanged = 'IlvImageView.instances[\''+this.toString()+'\'].loadImage()';
this.imagePanel.setContent(this.getHTMLContent(), onImageTagChanged);
}
IlvImageView.prototype.getImage = function() {
return this.imageSrc;
}
IlvImageView.prototype.setImage = function(image, width, height) {
var resize = (width != null && height != null);
trace(this.traceImage, "setImage, resize", this, image, resize);
if (resize) {
this.imageSrc = image;
this.setImageSize(width, height, false);
} else if (image != this.imageSrc) {
this.imageSrc = image;
if (image && this.inHTML) {
this.loadImage();
}
}
}
IlvImageView.prototype.getImageSize = function() {
var val = new Object();
val.width  = this.imageWidth  >= 0 ? this.imageWidth  : this.getWidth();
val.height = this.imageHeight >= 0 ? this.imageHeight : this.getHeight();
return val;
}
IlvImageView.prototype.setImageSize = function(width, height, skipImageRedisplay) {
trace(this.traceImage, "setImageSize", this, width, height);
this.imageWidth = width;
this.imageHeight = height;
this.updateImagePanelContent(skipImageRedisplay);
}
IlvImageView.prototype.getBlendTransform = function() {
return this.blendTransform;
}
IlvImageView.prototype.setBlendTransform = function(set) {
this.blendTransform = set;
}
IlvImageView.prototype.getScrollPosition = function() {
var val = new Object();
val.x = this.scrollX;
val.y = this.scrollY;
return val;
}
IlvImageView.prototype.setScrollPosition = function(x, y) {
if (this.scrollX != x || this.scrollY != y) {
this.scrollX = x;
this.scrollY = y;
if (this.imagePanel)
this.imagePanel.setScrollPosition(x, y);
this.imageScrollListeners.notify(this);
}
}
IlvImageView.prototype.addScrollListener = function(listener) {
this.imageScrollListeners.addListener(listener);
}
IlvImageView.prototype.removeScrollListener = function(listener) {
this.imageScrollListeners.removeListener(listener);
}
IlvImageView.prototype.loadImage = function() {
trace(this.traceImageLoading, "loadImage", this, this.imageSrc);
this.abortImage();
this.setImageState(IlvImageView.LOADING);
var offscreen = new Image();
this.offscreen = offscreen;
offscreen.view = this;
offscreen.onload  = IlvImageView.offscreenLoadListener;
offscreen.onabort = IlvImageView.offscreenAbortListener;
offscreen.onerror = IlvImageView.offscreenErrorListener;
this.startErrorTimer();
offscreen.src = this.imageSrc;
}
IlvImageView.offscreenLoadListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
trace(view.traceImageLoading, "image preloaded", view, this.src);
view.imagePreloadListeners.notify(view);
if (view.blendTransform && IlvBrowserInfo.instance.ie5up) {
var layer = view.imagePanel.getMouseEventSource();
layer.style.filter = "blendTrans(duration=.4)";
if (layer.filters && layer.filters.blendTrans.status != 2) {
layer.filters.blendTrans.apply();
if (!IlvPanel.visibilityLock)
layer.style.visibility = "visible";
layer.filters.blendTrans.play();
}
}
trace(view.traceImageLoading, "image loaded", view, this.src);
var dim = view.getImageSize();
replaceImageWithDimensions(view.imageID, this, true, dim.width, dim.height);
if (view.isVisible()) {
view.imagePanel.setVisible(true);
}
this.onabort = null;
this.onerror = null;
this.onload = null;
view.setImageState(IlvImageView.LOADED);
view.imageLoadListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
IlvImageView.offscreenAbortListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
view.setImageState(IlvImageView.ERROR);
trace(view.traceImageLoading, "image aborted", view, this.src);
disposeImageSource(this);
view.errorListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
IlvImageView.offscreenErrorListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
view.setImageState(IlvImageView.ERROR);
trace(view.traceImageLoading, "image error", view, this.src);
disposeImageSource(this);
view.errorListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
IlvImageView.prototype.abortImage = function() {
var offscreen = this.offscreen;
if (!offscreen)
return;
this.offscreen = null;
this.stopErrorTimer();
trace(this.traceImageLoading, "abortImage", this, offscreen.src);
disposeImageSource(offscreen);
offscreen.view = null;
this.setImageState(IlvImageView.NOT_LOADED);
}
IlvImageView.prototype.addImageLoadingListener = function(listener) {
this.imageLoadingListeners.addListener(listener);
}
IlvImageView.prototype.removeImageLoadingListener = function(listener) {
this.imageLoadingListeners.removeListener(listener);
}
IlvImageView.prototype.addImagePreloadListener = function(listener) {
this.imagePreloadListeners.addListener(listener);
}
IlvImageView.prototype.removeImagePreloadListener = function(listener) {
this.imagePreloadListeners.removeListener(listener);
}
IlvImageView.prototype.addImageLoadListener = function(listener) {
this.imageLoadListeners.addListener(listener);
}
IlvImageView.prototype.removeImageLoadListener = function(listener) {
this.imageLoadListeners.removeListener(listener);
}
IlvImageView.prototype.setTimeoutInterval = function(interval) {
this.timeout = interval;
}
IlvImageView.prototype.getTimeoutInterval= function() {
return this.timeout;
}
IlvImageView.prototype.startErrorTimer = function() {
this.stopErrorTimer();
this.errorInterval =
window.setTimeout('IlvImageView.prototype.onTimeout("' +
this.toString() + '")',
this.timeout*1000);
}
IlvImageView.prototype.stopErrorTimer = function() {
var inter = this.errorInterval;
this.errorInterval = null;
if (inter)
window.clearTimeout(inter);
}
IlvImageView.prototype.onTimeout = function(name) {
var view = IlvImageView.instances[name];
if (view != null) {
trace(view.traceImageLoading, "image timeout", view, view.imageSrc);
view.setImageState(IlvImageView.ERROR);
view.timeoutListeners.notify(view);
}
}
IlvImageView.prototype.addTimeoutErrorListener = function(listener) {
this.timeoutListeners.addListener(listener);
}
IlvImageView.prototype.removeTimeoutErrorListener = function(listener) {
this.timeoutListeners.removeListener(listener);
}
IlvImageView.prototype.addErrorListener = function(listener) {
this.errorListeners.addListener(listener);
}
IlvImageView.prototype.removeErrorListener = function(listener) {
this.errorsListeners.removeListener(listener);
}
function IlvImageEventView(left, top, width, height, image) {
this.superConstructor(left, top, width, height, image);
this.glassView = new IlvGlassView(left, top, width, height);
this.glassView.imageView = this;
this.glassView.getEventOriginLeft = function() {
return this.imageView.getEventOriginLeft();
}
this.glassView.getEventOriginTop = function() {
return this.imageView.getEventOriginTop();
}
}
IlvImageEventView.prototype = new IlvImageView();
IlvImageEventView.prototype.setClassName("IlvImageEventView");
IlvImageEventView.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
this.glassView.removeHTML();
}
IlvImageEventView.prototype.setCursor = function(cursor) {
this.superInvoke("setCursor", cursor);
this.glassView.setCursor(cursor);
}
IlvImageEventView.prototype.setVisible = function(visible) {
this.superInvoke("setVisible", visible);
this.glassView.setVisible(visible);
}
IlvImageEventView.prototype.setToolTipText = function(string) {
this.superInvoke("setToolTipText", string);
this.glassView.setToolTipText(this.tooltip);
}
IlvImageEventView.prototype.isEnabled = function() {
return this.glassView.isEnabled();
}
IlvImageEventView.prototype.setEnabled = function(enabled) {
this.glassView.setEnabled(enabled);
}
IlvImageEventView.prototype.getEventHandler = function() {
return this.glassView.getEventHandler();
}
IlvImageEventView.prototype.setEventHandler = function(eventHandler) {
this.glassView.setEventHandler(eventHandler);
}
IlvImageEventView.prototype.getEventOriginLeft = function() {
return this.left;
}
IlvImageEventView.prototype.getEventOriginTop = function() {
return this.top;
}
IlvImageEventView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
this.glassView.setBounds(left, top, width, height);
}
IlvImageEventView.prototype.childrenToHTML = function() {
this.superInvoke("childrenToHTML");
this.glassView.setVisible(this.isVisible());
this.glassView.toHTML();
}
IlvImageEventView.prototype.updateVisibility = function (){
this.superInvoke("updateVisibility");
this.glassView.updateVisibility();
}
IlvImageEventView.prototype.removeHTML = function (){
this.superInvoke("removeHTML");
this.glassView.removeHTML();
}
