/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvObject () {
}
IlvObject.prototype.getClassName = function () {
return this._className;
}
IlvObject.prototype.toString = function () {
return this.getClassName()+"_"+this.hashCode();
}
IlvObject.prototype.hashCode = function () {
if (!this._hashCode) {
this._hashCode = IlvObject._nextHashCode || 1;
IlvObject._nextHashCode = this._hashCode + 1;
}
return this._hashCode;
}
IlvObject.prototype.instanceOf = function (clazz) {
if (typeof(clazz) == "undefined")
return false;
else if (typeof(clazz) == "string")
clazz = eval(clazz);
return this instanceof clazz;
}
IlvObject.prototype.invoke = function(method, param1, paramn) {
if (typeof(method) == "string")
method = eval(method);
if (typeof(method) != "function")
alert("Method not found in invoke: " + method);
else {
var args = new Array(arguments.length-1);
for (var i = 0; i < args.length; i++)
args[i] = arguments[i+1];
return method.apply(this, args);
}
}
IlvObject.prototype.superConstructor = function (param1, paramn) {
var currentClass = this.__constructor__ || this.getClassName();
this.__constructor__ = IlvObject._superClass[currentClass];
var ret = eval(this.__constructor__).apply(this, arguments);
this.__constructor__ = null;
return ret;
}
IlvObject.prototype.superInvoke = function(method, param1, paramn) {
if (typeof(method) != "string")
alert("superInvoke can only be used with a string as method parameter");
if (!this.__callstack__)
this.__callstack__ = new Array();
var current, next;
do {
if (!this.__callstack__[method]) {
if (!current)
current = eval("this." + method);
this.__callstack__[method] = this.getClassName();
} else {
if (!current)
current = eval(this.__callstack__[method] + ".prototype." + method);
this.__callstack__[method] =
IlvObject._superClass[this.__callstack__[method]];
}
next = eval(this.__callstack__[method] + ".prototype." + method);
if (!next)
alert("Error in superInvoke, method not found: "
+ this.__callstack__[method] +  ".prototype." + method);
} while (next == current);
var args = new Array(arguments.length-1);
for (var i = 0; i < args.length; i++)
args[i] = arguments[i+1];
var ret = next.apply(this, args);
this.__callstack__[method] = null;
return ret;
}
IlvObject.prototype.setClassName = function (className) {
if (!IlvObject._superClass)
IlvObject._superClass = new Array();
IlvObject._superClass[className] = this._className;
this._className = className;
this._hashCode = null;
return this;
}
IlvObject.prototype.dispose = function() {
}
IlvObject.prototype.registerDispose = function() {
var name = this.toString();
IlvObject.disposeInstances[name] = this;
}
IlvObject.prototype.setClassName("IlvObject");
IlvObject.disposeInstances = new Array();
IlvObject.prototype.removeHTML = function () {
}
IlvObject.prototype.updateVisibility = function () {
}
function ilvDispose() {
for (var i in IlvObject.disposeInstances) {
var theInstance = IlvObject.disposeInstances[i];
theInstance.dispose();
IlvObject.disposeInstances[i] = null;
}
IlvObject.disposeInstances = null;
}
function IlvBrowserInfo() {
var agt=navigator.userAgent.toLowerCase();
this.major = parseInt(navigator.appVersion);
this.minor = parseFloat(navigator.appVersion);
this.nav  = ((agt.indexOf('mozilla')!=-1)
&& (agt.indexOf('spoofer')==-1)
&& (agt.indexOf('compatible') == -1)
&& (agt.indexOf('opera')==-1)
&& (agt.indexOf('webtv')==-1)
&& (agt.indexOf('hotjava')==-1));
var rvIndex =  agt.indexOf('rv:');
var rev = agt.substring(rvIndex+3, rvIndex+6);
this.mozMajor = parseInt(rev);
this.mozMinor = rev.substring(2,4)
this.nav4 = (this.nav && (this.major == 4));
this.nav4up = (this.nav && (this.major >= 4));
this.navonly = (this.nav && ((agt.indexOf(";nav") != -1) ||
(agt.indexOf("; nav") != -1)) );
this.nav6 = (this.nav && (this.major == 5));
this.nav6up = (this.nav && (this.major >= 5));
this.nav7 = (this.nav && (this.mozMajor == 1) && (this.mozMinor == 0));
this.nav7up = (this.nav && (this.mozMajor == 1) && (this.mozMinor >= 0));
this.moz15 = (this.nav && (this.mozMajor == 1) && (this.mozMinor == 5));
this.moz15up = (this.nav && (this.mozMajor == 1) && (this.mozMinor >= 5));
this.moz16 = (this.nav && (this.mozMajor == 1) && (this.mozMinor == 6));
this.moz16up = (this.nav && (this.mozMajor == 1) && (this.mozMinor >= 6));
this.moz17 = (this.nav && (this.mozMajor == 1) && (this.mozMinor == 7));
this.moz17up = (this.nav && (this.mozMajor == 1) && (this.mozMinor >= 7));
this.moz18 = (this.nav && (this.mozMajor == 1) && (this.mozMinor == 8));
this.moz18up = (this.nav && (this.mozMajor == 1) && (this.mozMinor >= 8));
this.gecko = (agt.indexOf('gecko') != -1);
this.ie = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
this.ie4 = (this.ie && (this.major == 4) && (agt.indexOf("msie 4")!=-1));
this.ie4up = (this.ie && (this.major >= 4));
this.ie5 = (this.ie && (this.major == 4)
&& (agt.indexOf("msie 5.0")!=-1) );
this.ie5_5  = (this.ie && (this.major == 4) && (agt.indexOf("msie 5.5") !=-1));
this.ie5up  = (this.ie && !this.ie3 && !this.ie4);
this.ie5_5up =(this.ie && !this.ie3 && !this.ie4 && !this.ie5);
this.ie6    = (this.ie && (this.major == 4) && (agt.indexOf("msie 6.")!=-1) );
this.ie6up  = (this.ie && !this.ie3 && !this.ie4 && !this.ie5 && !this.ie5_5);
this.ie7    = (this.ie && (this.major == 4) && (agt.indexOf("msie 7.")!=-1) );
this.ie7up  = (this.ie && !this.ie3 && !this.ie4 && !this.ie5 && !this.ie5_5 && !this.ie6);
this.opera = (agt.indexOf("opera") != -1);
this.opera2 = (agt.indexOf("opera 2") != -1 || agt.indexOf("opera/2") != -1);
this.opera3 = (agt.indexOf("opera 3") != -1 || agt.indexOf("opera/3") != -1);
this.opera4 = (agt.indexOf("opera 4") != -1 || agt.indexOf("opera/4") != -1);
this.opera5 = (agt.indexOf("opera 5") != -1 || agt.indexOf("opera/5") != -1);
this.opera6 = (agt.indexOf("opera 6") != -1 || agt.indexOf("opera/6") != -1);
this.opera7 = (agt.indexOf("opera 7") != -1 || agt.indexOf("opera/7") != -1);
this.opera5up = (this.opera && !this.opera2 && !this.opera3 && !this.opera4);
this.opera6up = (this.opera && !this.opera2 && !this.opera3 && !this.opera4 && !this.opera5);
this.opera7up = (this.opera && !this.opera2 && !this.opera3 && !this.opera4 && !this.opera5 && !this.opera6);
}
IlvBrowserInfo.instance = new IlvBrowserInfo();
function IlvPanel(left, top, width, height) {
this.superConstructor();
this._bounds = {};
this._bounds.left = left || 0;
this._bounds.top = top || 0;
this._bounds.width = width || 0;
this._bounds.height = height || 0;
this.scrollX = 0;
this.scrollY = 0;
this._displayed = true;
this._opacity = 1.0;
this.registerDispose();
}
IlvPanel.prototype = new IlvObject();
IlvPanel.prototype.setClassName("IlvPanel");
IlvPanel.prototype.isDOM2 = document.getElementById ? true : false;
IlvPanel.prototype.isNav  = (navigator.appName == "Netscape") ? true : false;
IlvPanel.prototype.isIE   = (navigator.appName.indexOf("Microsoft") > -1) ? true : false;
if (parseInt(navigator.appVersion.charAt(0)) >= 4)
{
IlvPanel.prototype.isNav4      = IlvPanel.prototype.isNav;
IlvPanel.prototype.isNav5      = IlvPanel.prototype.isNav  && IlvPanel.prototype.isDOM2;
IlvPanel.prototype.isNav4Exact = IlvPanel.prototype.isNav4 && !IlvPanel.prototype.isNav5;
IlvPanel.prototype.isIE4       = IlvPanel.prototype.isIE;
IlvPanel.prototype.isIE5       = IlvPanel.prototype.isIE  && IlvPanel.prototype.isDOM2;
IlvPanel.prototype.isIE4Exact  = IlvPanel.prototype.isIE4 && !IlvPanel.prototype.isIE5;
IlvPanel.prototype.isIE55Exact = IlvPanel.prototype.isIE5 && (navigator.appVersion.indexOf("MSIE 5.5") > -1)
}
IlvPanel.prototype.dispose = function() {
this.superInvoke("dispose");
this._layer = null;
this._div = null;
}
IlvPanel.prototype.translate = function (dx, dy) {
if (this._div) {
this._div.style.left = parseInt(this._bounds.left) + dx + "px";
this._div.style.top = parseInt(this._bounds.top) + dy + "px";
}
}
IlvPanel.prototype.getLeft = function () {
return this._bounds.left;
}
IlvPanel.prototype.getTop = function () {
return this._bounds.top;
}
IlvPanel.prototype.getWidth = function () {
return this._bounds.width;
}
IlvPanel.prototype.getHeight = function () {
return this._bounds.height;
}
IlvPanel.prototype.findLayer = function (name, root) {
if (root == null) root = document;
var layer =  root.layers[name];
if (layer) return layer;
var j;
for (j=0; j < root.layers.length; j++) {
layer = this.findLayer(name, root.layers[j]);
if (layer) return layer;
}
return null;
}
IlvPanel.prototype.updateLocation = function() {
var left = this._bounds.left;
var top  = this._bounds.top;
if (this._div) {
this._div.style.left = (left-this.scrollX) + "px";
this._div.style.top = (top-this.scrollY) + "px";
if (IlvBrowserInfo.instance.moz17up){
var s = this._div.offsetLeft;
}
}
}
IlvPanel.prototype.setLocation = function(left, top) {
this._bounds.left = left;
this._bounds.top = top;
this.updateLocation();
}
IlvPanel.prototype.getBounds = function () {
return this._bounds;
}
IlvPanel.prototype.setBounds = function(left, top, width, height) {
this.setLocation(left,top);
this.setSize(width,height);
}
IlvPanel.prototype.setBackgroundColor = function (color) {
if (this._layer)
this._layer.bgColor = color;
if (this._div)
this._div.style.backgroundColor = color;
}
IlvPanel.prototype.setZIndex = function (zIndex) {
if (this._layer)
this._layer.zIndex = zIndex;
else if (this._div)
this._div.style.zIndex = zIndex;
}
IlvPanel.prototype.getZIndex = function () {
if (this._layer)
return this._layer.zIndex;
else if (this._div)
return this._div.style.zIndex;
}
IlvPanel.prototype.setBackgroundImage = function(image) {
if (this._layer)
this._layer.background.src = image;
else if (this._div)
this._div.style.backgroundImage = 'url(' + image +')'
}
IlvPanel.prototype.setVisible = function (visible) {
this._visible = visible;
if (!IlvPanel.visibilityLock){
if (this._layer)
this._layer.visibility = visible ? "show" : "hide";
if (this._div) {
this._div.style.visibility = visible ? "visible" : "hidden";
if (IlvBrowserInfo.instance.moz17up){
var s = this._div.offsetLeft;
}
}
}
}
IlvPanel.prototype.setOpacity = function (opacity) {
this._opacity = opacity;
if (this._div) {
var style = this._div.style;
style.opacity = opacity;
style.MozOpacity = opacity;
var op100 = opacity * 100;
style.filter = "alpha(opacity=" + op100 + ")";
}
}
IlvPanel.prototype.getOpacity = function () {
return this._opacity;
}
IlvPanel.prototype.setDisplayed = function (displayed) {
this._displayed = displayed;
if (this._div)
this._div.style.display = displayed ? "block" : "none";
}
IlvPanel.prototype.isDisplayed = function (displayed) {
return this._displayed;
}
IlvPanel.prototype.updateVisibility = function (){
if (this.isVisible())
this.setVisible(true);
}
IlvPanel.prototype.isVisible = function () {
return this._visible;
}
IlvPanel.prototype.setSize = function(width, height) {
if (this._div) {
this._div.style.width = width + "px";
this._div.style.height = height + "px";
}
this._bounds.width = width;
this._bounds.height = height;
this.setClip(0, 0, width, height);
}
IlvPanel.prototype.getScrollPosition = function() {
var val = new Object();
val.x = this.scrollX;
val.y = this.scrollY;
return val;
}
IlvPanel.prototype.setScrollPosition = function(x, y) {
this.scrollX = x;
this.scrollY = y;
var clip = this.getClip();
this.updateLocation();
this.setClip(clip.left, clip.top, clip.width, clip.height);
}
IlvPanel.prototype.getClipImpl = function() {
var clip = null;
if (this._layer)
clip = this._layer.clip;
if (this._div) {
var clipv = this._div.style.clip.split("rect(")[1].split("px");
clip = new Object();
clip.top    = parseInt(clipv[0]);
clip.left   = parseInt(clipv[3]);
clip.width  = parseInt(clipv[1]) - clip.left;
clip.height = parseInt(clipv[2]) - clip.top;
}
return clip;
}
IlvPanel.prototype.setClipImpl = function(left, top, width, height) {
if (this._div) {
this._div.style.clip = 'rect('+top+'px '
+(left+width)+'px '+(top+height)+'px '+left+'px)';
}
}
IlvPanel.prototype.getClip = function () {
if (!this._clip) {
var clip = this.getClipImpl();
this._clip = new Object();
this._clip.left   = clip.left - this.scrollX;
this._clip.top    = clip.top  - this.scrollY;
this._clip.width  = clip.width;
this._clip.height = clip.height;
}
return this._clip;
}
IlvPanel.prototype.setClip = function(left, top, width, height) {
var scrollX = this.scrollX;
var scrollY = this.scrollY;
var layerWidth  = this._bounds.width;
var layerHeight = this._bounds.height;
if (left < 0)           left = 0;
if (left > layerWidth)  left = layerWidth;
if (top  < 0)           top  = 0;
if (top  > layerHeight) top  = layerHeight;
if (width < 0)          width  = 0;
if (height < 0)         height = 0;
var maxClipWidth  = layerWidth  - left;
var maxClipHeight = layerHeight - top;
if (width  > maxClipWidth)  width  = maxClipWidth;
if (height > maxClipHeight) height = maxClipHeight;
var c = this._clip;
if (!c) {
c = new Object();
this._clip = c;
}
c.left   = left;
c.top    = top;
c.width  = width;
c.height = height;
left += scrollX;
top  += scrollY;
this.setClipImpl(left, top, width, height);
}
IlvPanel.prototype.getMouseEventSource = function () {
if (this._layer)
return this._layer;
if (this._div)
return this._div;
}
IlvPanel.prototype.setCursor = function (cursor) {
if (this._div)
this._div.style.cursor = cursor;
}
IlvPanel.prototype.getCursor = function () {
if (this._div)
return this._div.style.cursor;
}
function IlvHTMLPanel (HTMLContent) {
this.superConstructor();
var name = this.toString();
if (document.layers) {
document.writeln('<layer name="' + name
+ '" visibility="hide">');
if (HTMLContent)
document.writeln(HTMLContent);
document.writeln('</layer>');
this._layer = this.findLayer(name);
} else if (IlvBrowserInfo.instance.ie5up || document.getElementById) {
document.write('<div id="' + name + '" ');
document.write('style="position:absolute; z-index:1; ');
if(IlvBrowserInfo.instance.nav6up)
document.write('-moz-user-select:none; ');
document.writeln('visibility:hidden;">');
if (!HTMLContent) {
HTMLContent = '<table border="0" width="100%" height="100%"><tr><td></td></tr></table>';
}
document.writeln('</div>');
if (document.getElementById)
this._div = document.getElementById(name);
else
this._div = document.all[name];
if (!IlvBrowserInfo.instance.ie4)
this.setContentImpl(HTMLContent);
}
if (!this._div && !this._layer)
alert("Could not create the IlvHTMLPanel correctly\nThis browser version is probably not supported");
}
IlvHTMLPanel.prototype = new IlvPanel();
IlvHTMLPanel.prototype.setClassName("IlvHTMLPanel");
IlvHTMLPanel.prototype.removeHTML = function () {
if (this._div)
this._div.parentNode.removeChild(this._div);
}
IlvHTMLPanel.prototype.setContent = function(content, onContentSet) {
this.setContentImpl(content);
if (onContentSet)
eval(onContentSet);
}
IlvHTMLPanel.prototype.setContentImpl = function(content, onloadStr) {
var s = content;
if (onloadStr && onloadStr.length > 0) {
s = '<body';
s += ' onload="'+onloadStr+'"';
s += '>\n' + content + '\n</body>';
}
if (this._layer) {
this._layer.document.open();
this._layer.document.writeln(s);
this._layer.document.close();
} else if (this._div) {
this._div.innerHTML = s;
}
}
IlvHTMLPanel.prototype.getDocument = function () {
if (this._layer) return this._layer.document;
if (this._div)
return this._div.document ? this._div.document : this._div.ownerDocument;
}
function IlvURLPanel (left, top, width, height) {
this.superConstructor(left, top, width, height);
var name = this.toString();
if (document.layers) {
document.writeln('<layer name="' + name
+ '" left=' + left + ' top=' + top +
' width=' + width + ' height=' + height +
' visibility="hide">');
document.writeln('</layer>');
this._layer = this.findLayer(name);
this._env = this._layer;
} else if (IlvBrowserInfo.instance.ie5up || document.getElementById) {
document.write('<div id="' + name + '" ');
document.write('style="position:absolute; z-index:1; ');
document.write('left:' + left + 'px; top:' + top + 'px; width:' + width
+ 'px; height:' + height + 'px;');
document.writeln('visibility:hidden;">');
var fname = name + "Frame";
document.writeln('<iframe name="'+ fname +
'" id="' + fname + '" scrolling="no" width="' + width +
'" height="'+height+
'" marginwidth=0 marginheight=0 frameborder="no" >');
document.writeln('</iframe>');
document.writeln('</div>');
if (IlvBrowserInfo.instance.ie5up)
this._div = document.all[name];
else
this._div = document.getElementById(name);
this._env = window.frames[fname];
if(!this._env && document.getElementById)
this._env = document.getElementById(fname);
if (IlvBrowserInfo.instance.nav6up && !IlvBrowserInfo.instance.moz15up)
this.frameIndex = window.frames.length - 1;
}
this.setClip(0, 0, this._bounds.width, this._bounds.height);
this.registerDispose();
if ((!this._div && !this._layer) || !this._env)
alert("Could not create the IlvURLPanel correctly");
}
IlvURLPanel.prototype = new IlvPanel();
IlvURLPanel.prototype.setClassName("IlvURLPanel");
IlvURLPanel.prototype.removeHTML = function () {
if (this._div)
this._div.parentNode.removeChild(this._div);
}
IlvURLPanel.prototype.dispose = function() {
this.superInvoke("dispose");
this._env = null;
}
IlvURLPanel.prototype.setURL = function(url) {
this.setURLImpl(url);
}
IlvURLPanel.prototype.setURLImpl = function(url, onloadStr) {
if (this._div) {
if (IlvBrowserInfo.instance.nav6up && !IlvBrowserInfo.instance.moz15up)
this._env = window.frames[this.frameIndex];
var doc = this._env.document;
doc.location = url;
} else if (this._layer) {
this._layer.src = url;
}
}
IlvURLPanel.prototype.getContext = function () {
return this._env;
}
function IlvDynPanel (parentNode) {
this.superConstructor();
var name = this.toString();
if (!parentNode)
parentNode = document.body;
if (document.layers) {
var layer = document.layers[name] = new Layer(1000);
layer.name = name;
layer.visibility = "hide";
layer.clip.width = 1000;
layer.clip.height = 100;
this._layer = layer;
this._layer.captureEvents(Event.MOUSEMOVE
| Event.MOUSEDOWN
| Event.MOUSEUP
| Event.MOUSEOUT
| Event.MOUSEOVER);
} else {
this._div = this.createDivElement(this.toString());
parentNode.appendChild(this._div);
}
if (!this._div && !this._layer) {
alert('Could not create '+this.toString()+' correctly');
return;
}
}
IlvDynPanel.prototype = new IlvPanel();
IlvDynPanel.prototype.setClassName("IlvDynPanel");
IlvDynPanel.prototype.createDivElement = function (id) {
var div = document.createElement("div");
div.id = id;
div.style.cssText = "position: absolute; visibility:hidden; -moz-user-select:none;left:0px;top:0px;";
if (IlvBrowserInfo.instance.ie5up) {
var table = document.createElement("table");
table.border = 0;
table.width = "100%";
table.height = "100%";
var tbody = document.createElement("tBody");
table.appendChild(tbody);
var tr = document.createElement("tr");
tbody.appendChild(tr);
var td = document.createElement("td");
tr.appendChild(td);
div.appendChild(table);
}
return div;
}
IlvDynPanel.prototype.setContent = function (content) {
if (this._layer) {
this._layer.document.open();
this._layer.document.writeln(content);
this._layer.document.close();
}
if (this._div)
this._div.innerHTML = content;
}
IlvDynPanel.prototype.getMouseEventSource = function () {
if (this._layer) {
this._layer.captureEvents(Event.MOUSEMOVE
| Event.MOUSEDOWN
| Event.MOUSEUP
| Event.MOUSEOUT
| Event.MOUSEOVER);
return this._layer;
} else if (this._div)
return this._div;
}
IlvDynPanel.prototype.setURL = function (url) {
if (this._div) {
if (!this._env) {
var name = this.toString()+"Loader";
var h = '<iframe name="'+name+'" width="100" height="100" src="'+url+'"></iframe>';
this._div.innerHTML = h;
this._env = window.frames[name];
} else
this._env.document.location = url;
} else if (this._layer) {
this._env = this._layer;
this._layer.load(url,100);
}
}
IlvDynPanel.prototype.getContext = function () {
return this._env;
}
IlvDynPanel.prototype.updateLocation = function () {
var left = this._bounds.left;
var top  = this._bounds.top;
if (this._div) {
this._div.style.left = (left-this.scrollX) + "px";
this._div.style.top = (top-this.scrollY) + "px";
if (IlvBrowserInfo.instance.moz17up){
var s = this._div.offsetLeft;
}
}
}
IlvDynPanel.prototype.removeHTML = function () {
if (this._div)
this._div.parentNode.removeChild(this._div);
}
function IlvRectangle (init, fillOn) {
if (init != null)
return;
this.superConstructor();
this.fillOn = fillOn;
this.opacity = 0.5;
this.createPanels();
this.setColor("#000000");
this.setThickness(1);
this.scrollX = 0;
this.scrollY = 0;
}
IlvRectangle.prototype = new IlvObject();
IlvRectangle.prototype.setClassName("IlvRectangle");
IlvRectangle.prototype.removeHTML = function () {
this.top.removeHTML();
this.bottom.removeHTML();
this.left.removeHTML();
this.right.removeHTML();
if (this.fill)
this.fill.removeHTML();
}
IlvRectangle.prototype.updateVisibility = function () {
this.top.updateVisibility();
this.bottom.updateVisibility();
this.left.updateVisibility();
this.right.updateVisibility();
if (this.fill)
this.fill.updateVisibility();
}
IlvRectangle.prototype.createPanel = function() {
return new IlvHTMLPanel();
}
IlvRectangle.prototype.createPanels = function () {
if (this.fillOn) {
this.fill = this.createFillPanel();
}
this.top = this.createPanel();
this.left = this.createPanel();
this.right = this.createPanel();
this.bottom = this.createPanel();
}
IlvRectangle.prototype.createFillPanel = function() {
var fill = this.createPanel();
fill.setOpacity(this.opacity);
return fill;
}
IlvRectangle.prototype.setZIndex = function (zIndex) {
this.zIndex = zIndex;
this.top.setZIndex(zIndex);
this.bottom.setZIndex(zIndex);
this.left.setZIndex(zIndex);
this.right.setZIndex(zIndex);
if (this.fill)
this.fill.setZIndex(zIndex);
}
IlvRectangle.prototype.getZIndex = function () {
return this.zIndex;
}
IlvRectangle.prototype.setColor = function (color) {
this.color = color;
if (this.fill)
this.fill.setBackgroundColor(color);
this.top.setBackgroundColor(color);
this.left.setBackgroundColor(color);
this.right.setBackgroundColor(color);
this.bottom.setBackgroundColor(color);
}
IlvRectangle.prototype.isFillOn = function() {
return this.fillOn;
}
IlvRectangle.prototype.setFillOn = function (fillOn) {
if (this.fillOn == fillOn) {
return;
}
this.fillOn = fillOn;
if (fillOn) {
if (!this.fill) {
this.fill = this.createFillPanel();
this.fill.setBackgroundColor(this.color);
this.fill.setZIndex(this.zIndex);
}
this.fill.setVisible(this.visible);
} else {
this.fill.setVisible(false);
}
if (this.visible) {
this.recompute();
}
}
IlvRectangle.prototype.setOpacity = function (opacity) {
this.opacity = opacity;
if (this.fill) {
this.fill.setOpacity(this.opacity);
}
}
IlvRectangle.prototype.getOpacity = function () {
return this.opacity;
}
IlvRectangle.prototype.setVisible = function (visible) {
if (this.visible != visible) {
this.visible = visible;
this.top.setVisible(visible);
this.left.setVisible(visible);
this.right.setVisible(visible);
this.bottom.setVisible(visible);
if (this.fill)
this.fill.setVisible(visible && this.fillOn);
if (this.visible)
this.recompute();
}
}
IlvRectangle.prototype.isVisible = function () {
return this.visible;
}
IlvRectangle.prototype.setDisplayed = function (displayed) {
if (this.displayed != displayed) {
this.displayed = displayed;
this.top.setDisplayed(displayed);
this.left.setDisplayed(displayed);
this.right.setDisplayed(displayed);
this.bottom.setDisplayed(displayed);
if (this.fill)
this.fill.setDisplayed(displayed && this.fillOn);
if (this.displayed)
this.recompute();
}
}
IlvRectangle.prototype.isDisplayed = function () {
return this.displayed;
}
IlvRectangle.prototype.setThickness = function (thickness) {
if (this.thickness == thickness)
return;
this.thickness = thickness || 0;
if (this.visible)
this.recompute();
}
IlvRectangle.prototype.getThickness = function (thickness) {
return this.thickness || 0;
}
IlvRectangle.prototype.setBounds = function (left, top, width, height) {
if (!this.bounds)
this.bounds = new Object();
this.bounds.left = left;
this.bounds.top = top;
this.bounds.width = width;
this.bounds.height = height;
if (this.visible)
this.recompute();
}
IlvRectangle.prototype.getBounds = function() {
if (!this.bounds)
this.bounds = {left:0, top:0, width:0, height:0 };
return this.bounds;
}
IlvRectangle.prototype.setClip = function (left, top, width, height) {
if (!this.clip)
this.clip = new Object();
this.clip.left = left;
this.clip.top = top;
this.clip.width = width;
this.clip.height = height;
if (this.visible)
this.recompute();
}
IlvRectangle.prototype.removeClip = function () {
this.clip = null;
if (this.visible)
this.recompute();
}
IlvRectangle.prototype.isClipped = function () {
return (this.clip != null);
}
IlvRectangle.prototype.recompute = function () {
var b = this.bounds;
if (b) {
var t = this.thickness;
if (this.fill) {
var h = b.height-t > 0 ? b.height-t : 0;
var w = b.width-t > 0 ? b.width-t : 0;
this.draw(this.fill, b.left-this.scrollX, b.top-this.scrollY, w, h);
}
this.draw(this.top, b.left-this.scrollX, b.top-this.scrollY, b.width, t);
this.draw(this.left, b.left-this.scrollX, b.top-this.scrollY, t, b.height);
this.draw(this.bottom, b.left-this.scrollX, b.top+b.height-t-this.scrollY, b.width, t);
this.draw(this.right, b.left+b.width-t-this.scrollX, b.top-this.scrollY, t, b.height);
}
}
IlvRectangle.prototype.draw = function (panel, left, top, width, height) {
if (this.clip) {
var c = this.clip;
var x = left + width, cx = c.left + c.width;
var y = top + height, cy = c.top + c.height;
if (x > cx) x = cx;
if (y > cy) y = cy;
if (left < c.left) left = c.left;
if (top < c.top) top = c.top;
width = (x > left) ? x - left : 0;
height = (y > top) ? y - top : 0;
}
panel.setBounds(left,top,width,height);
}
IlvRectangle.prototype.setScrollPosition = function (x,y) {
this.scrollX = x;
this.scrollY = y;
if (this.visible)
this.recompute();
}
IlvRectangle.prototype.getScrollPosition = function () {
return {x: this.scrollX, y: this.scrollY};
}
function IlvDynRectangle (init, parentNode, fillOn) {
this.parentNode = parentNode;
this.superConstructor(init, fillOn);
}
IlvDynRectangle.prototype = new IlvRectangle("init");
IlvDynRectangle.prototype.setClassName("IlvDynRectangle");
IlvDynRectangle.prototype.createPanel = function() {
return new IlvDynPanel(this.parentNode);
}
function IlvListenerList () {
this.superConstructor();
}
IlvListenerList.prototype = new IlvObject();
IlvListenerList.prototype.setClassName("IlvListenerList");
IlvListenerList.prototype.addListener = function(type,
callback) {
if (typeof(callback) == "undefined") {
callback = type;
type = "NoType";
}
if (!callback)
alert("Only functions can be used as listeners");
else {
if (!this._listeners)
this._listeners = new Array();
if (!this._listeners[type])
this._listeners[type] = new Array();
var listeners = this._listeners[type];
var l = listeners.length - 1;
var index = listeners.length;
var i;
for (i = l; i >= 0; i--)
if (listeners[i] == callback)
return;
else if (listeners[i] == null)
index = i;
listeners[index] = callback;
}
this.registerDispose();
}
IlvListenerList.prototype.dispose = function() {
this.superInvoke("dispose");
this.listeners = null;
}
IlvListenerList.prototype.removeListener = function(type,
callback) {
if (typeof(callback) == "undefined") {
callback = type;
type = "NoType";
}
if (!callback)
alert("Only functions can be used as listeners");
if (this._listeners && this._listeners[type]) {
var listeners = this._listeners[type];
var l = listeners.length;
var v = new Array(l-1);
var i, ii = 0;
for (i = 0; i < l; i++)
if (listeners[i] != callback) {
v[ii] = listeners[i];
ii++;
}
this._listeners[type] = v;
}
}
IlvListenerList.prototype.notify = function(type, param1, paramn) {
var explicitType = (typeof(type) == "string");
var rtype;
if (!explicitType)
rtype = "NoType";
else
rtype = type;
if (this._listeners && this._listeners[rtype]) {
var listeners = this._listeners[rtype];
var ii;
var ll = listeners.length - 1;
for (ii = ll; ii >= 0; ii--)
if (listeners[ii]) {
var args = arguments;
if (explicitType) {
var args = new Array(arguments.length-1);
for (var i = 0; i < args.length; i++)
args[i] = arguments[i+1];
}
listeners[ii].apply(null, args);
}
}
}
function setCookie(name, value, expires, path, domain, secure)
{
var caution = false;
var curCookie = name + "=" + escape(value) +
((expires) ? "; expires=" + expires.toGMTString() : "") +
((path) ? "; path=" + path : "") +
((domain) ? "; domain=" + domain : "") +
((secure) ? "; secure" : "");
if (!caution || (name + "=" + escape(value)).length <= 4000)
document.cookie = curCookie ;
else
if (confirm("Cookie exceeds 4KB and will be cut!"))
document.cookie = curCookie;
}
function getCookie(name)
{
var prefix = name + "=" ;
var cookieStartIndex = document.cookie.indexOf(prefix);
if (cookieStartIndex == -1)
return null;
var cookieEndIndex = document.cookie.indexOf(";", cookieStartIndex +
prefix.length);
if (cookieEndIndex == -1)
cookieEndIndex = document.cookie.length;
return unescape(document.cookie.substring(cookieStartIndex +
prefix.length,
cookieEndIndex));
}
function deleteCookie(name, path, domain) {
if (getCookie(name)) {
document.cookie = name + "=" +
((path) ? "; path=" + path : "") +
((domain) ? "; domain=" + domain : "") +
"; expires=Thu, 01-Jan-1970 00:00:01 GMT";
}
}
function getForm(formName)
{
if (document.getElementById)
return document.getElementById(formName);
else
return ilvFindNSForm(formName);
}
function ilvFindNSForm(formName, root)
{
if (root == null)
root = document;
if (root.forms) {
var form = root.forms[formName];
if (form)
return form;
}
for (var i = 0; i < root.layers.length; i++) {
var layer = root.layers[i];
var form = this.ilvFindNSForm(formName, layer.document);
if (form)
return form;
}
return null;
}
var ilvImagePath = 'script/images/';
function getImage(imageID)
{
if (document.getElementById) {
return document.getElementById(imageID);
} else {
return document[imageID];
}
}
function disposeImageSource(image)
{
image.onabort = null;
image.onerror = null;
image.onload  = null;
if (!IlvBrowserInfo.instance.ie4 && image.outerHTML) {
image.outerHTML = '<img width=10 height=10>';
} else if (IlvBrowserInfo.instance.nav4) {
image.src = null;
} else {
image.src = ilvImagePath + 'empty.gif';
}
}
function replaceImage(targetImageID, sourceImage, disposeOldImage)
{
replaceImageWithDimensions(targetImageID, sourceImage, disposeOldImage);
}
function replaceImageWithDimensions(targetImageID, sourceImage, disposeOldImage, width, height)
{
var oldImage = getImage(targetImageID);
if (!oldImage)
return;
if (oldImage.replaceNode) {
sourceImage.alt = oldImage.alt;
sourceImage.id = oldImage.id;
sourceImage.name = oldImage.name;
if (width)
sourceImage.width = width;
else
sourceImage.width = oldImage.width;
if (height)
sourceImage.height = height;
else
sourceImage.height = oldImage.height;
oldImage.replaceNode(sourceImage);
if (disposeOldImage) {
disposeImageSource(oldImage);
}
} else if (oldImage.replaceChild) {
sourceImage.alt = oldImage.alt;
sourceImage.id = oldImage.id;
sourceImage.name = oldImage.name;
if (width)
sourceImage.width = width;
else
sourceImage.width = oldImage.width;
if (height)
sourceImage.height = height;
else
sourceImage.height = oldImage.height;
oldImage.parentNode.replaceChild(sourceImage, oldImage);
if (disposeOldImage) {
disposeImageSource(oldImage);
}
} else {
oldImage.src = sourceImage.src;
if (disposeOldImage) {
disposeImageSource(sourceImage);
}
}
}
function fixDate(date) {
var base = new Date(0);
var skew = base.getTime();
if (skew > 0)
date.setTime(date.getTime() - skew);
}
function listProperties(obj) {
var msg = "Properties for " + obj + ":";
for (var i in obj) {
var valueType = typeof(obj[i]);
if (valueType != 'function') {
var value;
if (valueType == 'unknown')
value = '<unknown>';
else
value = obj[i];
msg += "\n" + i + "=" + value;
}
}
return msg;
}
function listMethods(obj) {
var msg = "Methods for " + obj + ":";
for (var i in obj) {
var valueType = typeof(obj[i]);
if (valueType == 'function') {
var value = obj[i];
msg += "\n" + i + "=" + value;
}
}
return msg;
}
function displayProperties(obj) {
alert(listProperties(obj));
}
function displayMethods(obj) {
alert(listMethods(obj));
}
function evaluatorToHTML(lineNum, resultLines) {
}
function trace(flag, label, value1, value2, value3) {
}
function IlvDebug(message) {
if(document.getElementById) {
var debug = document.getElementById("DebugView");
if(debug) {
debug.contentWindow.document.write("<pre>" + unescape(message) + "</pre> \n");
}
}
}
function IlvDrawUtil() {
}
IlvDrawUtil.drawLine = function(x1, y1, x2, y2, lineWidth, lineColor, line) {
if (IlvBrowserInfo.instance.moz18up) {
var div = line;
var svg;
var impl;
if (!div) {
div = document.createElement("div");
div.setAttribute("style", "z-index:3;position:fixed;left:0;top:0;width:100%;height:100%");
svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
impl = document.createElementNS("http://www.w3.org/2000/svg", "line");
} else {
svg = div.firstChild;
impl = svg.firstChild;
}
impl.setAttributeNS(null, "x1", x1);
impl.setAttributeNS(null, "y1", y1);
impl.setAttributeNS(null, "x2", x2);
impl.setAttributeNS(null, "y2", y2);
impl.setAttributeNS(null, "stroke", lineColor);
impl.setAttributeNS(null, "stroke-width", lineWidth);
if (!div.parentNode) {
if (!svg.parentNode) {
svg.appendChild(impl);
div.appendChild(svg);
}
var body = document.getElementsByTagName("body").item(0);
body.appendChild(div);
}
return div;
} else if (IlvBrowserInfo.instance.ie5_5up) {
var div = line;
var impl;
if (!div) {
div = document.createElement("div");
div.style.zIndex = 3;
div.style.position = "absolute";
div.style.left="0px";
div.style.top="0px";
div.style.width="100%";
div.style.height="100%";
impl = document.createElement("line");
impl.style.behavior = "url(#default#VML)";
} else {
impl = div.firstChild;
}
var d = document.documentElement.clientWidth?document.documentElement:document.body;
var xdelta = d.scrollLeft;
var ydelta = d.scrollTop;
if (document.body.clientLeft) {
xdelta -= document.body.clientLeft;
}
if (document.body.clientTop) {
ydelta -= document.body.clientTop;
}
impl.setAttribute("from", (x1+xdelta)+","+(y1+ydelta));
impl.setAttribute("to", (x2+xdelta)+","+(y2+ydelta));
impl.strokeweight = lineWidth;
impl.strokecolor = lineColor;
var body = document.getElementsByTagName("body").item(0);
if (div.parentNode != body) {
if (impl.parentNode != div)
div.appendChild(impl);
body.appendChild(div);
}
return div;
} else {
var div = line;
if (!div)
div = document.createElement("div");
var width = Math.abs(x2-x1);
var rightd = x1 <= x2;
var x = rightd?x1:x2;
var height = Math.abs(y2-y1);
var bottomd = y1 <= y2;
var y = bottomd?y1:y2;
var buffer = ["z-index:3;position:absolute;left:"];
buffer.push(x);
buffer.push(";top:");
buffer.push(y);
buffer.push(";width:");
buffer.push(width);
buffer.push(";height:");
buffer.push(height);
if (rightd)
buffer.push(";border-right-style:solid;border-left-style:none;");
else
buffer.push(";border-right-style:none;border-left-style:solid;");
if (bottomd)
buffer.push(";border-top-style:solid;border-bottom-style:none;");
else
buffer.push(";border-top-style:none;border-bottom-style:solid;");
buffer.push("border-color:");
buffer.push(lineColor);
buffer.push(";border-width:");
buffer.push(lineWidth);
div.style.cssText = buffer.join('');
if (!div.parentNode) {
var body = document.getElementsByTagName("body").item(0);
body.appendChild(div);
}
return div;
}
}
IlvDrawUtil.releaseLine = function(line) {
if (line && line.parentNode)
line.parentNode.removeChild(line);
}
function IlvRequestParameters() {
}
IlvRequestParameters.getRequestParameters = function(params) {
var length = params.length;
var r = new Array(length*2);
for (var i = 0; i < length; i+=2) {
r[2*i] = '&';
r[2*i+1] = params[i];
r[2*i+2] = '=';
r[2*i+3] = escape(params[i+1]);
}
return r.join('');
}
IlvRequestParameters.setParameter = function(params, key, value) {
var index = IlvRequestParameters.indexOfKey(params, key);
if (index != -1) {
if (value == null) {
IlvRequestParameters.removeAt(params, index);
} else {
params[index+1] = value;
}
} else {
params[params.length] = key;
params[params.length] = value;
}
}
IlvRequestParameters.removeParameter = function(params, key) {
var i = IlvRequestParameters.indexOfKey(params, key);
if (i != -1) {
IlvRequestParameters.removeAt(params, i);
}
}
IlvRequestParameters.indexOfKey = function(params, key) {
var length = params.length;
for (var i=0; i<length; i+=2) {
if (params[i] == key) {
return i;
}
}
return -1;
}
IlvRequestParameters.removeAt = function(params, index) {
var length = params.length;
for (var i=index; i<length-2; i+=2) {
params[i] = params[i+2];
params[i+1] = params[i+3];
}
params.length -= 2;
}
function IlvUtil () {
}
IlvUtil.isIntersect = function(bbox1, bbox2) {
return ((bbox1.left <= bbox2.left + bbox2.width) &&
(bbox1.left + bbox1.width  >= bbox2.left) &&
(bbox1.top <= bbox2.top + bbox2.height)&&
(bbox1.top + bbox1.height >= bbox2.top));
}
IlvUtil.isPrimaryMouseButton = function(event) {
if (IlvBrowserInfo.instance.ie5up) {
return event.button == 1;
} else if (IlvBrowserInfo.instance.nav6up) {
return event.button == 0;
}
}
IlvUtil.isSecondaryMouseButton = function(event) {
return event.button == 2;
}
function IlvAjaxUtil() {
}
IlvAjaxUtil.getXMLHttpRequest = function() {
var	__xmlhttp = false;
try {
__xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
} catch (e1) {
try {
__xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
} catch (e2) {
__xmlhttp = false;
}
}
if (!__xmlhttp && typeof XMLHttpRequest != 'undefined') {
__xmlhttp = new XMLHttpRequest();
}
return __xmlhttp;
}
IlvAjaxUtil.post = function(url, content, xhr, oncompleted, onfailed) {
if (!xhr)
xhr = IlvAjaxUtil.getXMLHttpRequest();
var x = xhr;
if (x.readyState != 4) {
x = IlvAjaxUtil.getXMLHttpRequest();
}
x.open("POST", url, true);
x.setRequestHeader("Content-length", content.length);
x.setRequestHeader("Content-Type", "text/plain;charset=utf-8");
x.onreadystatechange = function() {
if (x.readyState == 4) {
if (x.status == 200 || x.status == 0) {
if (oncompleted)
oncompleted.call(null, x);
} else {
if (onfailed)
onfailed.call(null, x)
}
}
}
x.send(content);
return xhr;
}
function IlvJSONUtil() {
}
IlvJSONUtil.escaped = {'\b': '\\b', '\t': '\\t', '\n': '\\n', '\f': '\\f', '\r': '\\r', '"' : '\\"', '\\': '\\\\'},
IlvJSONUtil.arrayToJSON = function (x) {
var a = ['['], b, f, i, l = x.length, v;
for (i = 0; i < l; i += 1) {
v = x[i];
if (v == null)
f = IlvJSONUtil.nullToJSON;
else if (typeof(v) == "string")
f = IlvJSONUtil.stringToJSON;
else if (v instanceof Array)
f = IlvJSONUtil.arrayToJSON;
else
f = IlvJSONUtil.objectToJSON;
if (f) {
v = f(v);
if (typeof v == 'string') {
if (b) {
a[a.length] = ',';
}
a[a.length] = v;
b = true;
}
}
}
a[a.length] = ']';
return a.join('');
}
IlvJSONUtil.nullToJSON = function(x) {
return "null";
}
IlvJSONUtil.stringToJSON = function (x) {
if (/["\\\x00-\x1f]/.test(x)) {
x = x.replace(/([\x00-\x1f\\"])/g, function(a, b) {
var c = IlvJSONUtil.escaped[b];
if (c)
return c;
c = b.charCodeAt();
return '\\u00'+Math.floor(c / 16).toString(16) +(c % 16).toString(16);
});
}
return '"' + x + '"';
}
IlvJSONUtil.objectToJSON = function(x) {
var a = ['{'], b, f, i, v;
for (i in x) {
v = x[i];
if (v == null)
f = IlvJSONUtil.nullToJSON;
else if (typeof(v) == "string")
f = IlvJSONUtil.stringToJSON;
else if (v instanceof Array)
f = IlvJSONUtil.arrayToJSON;
else
f = IlvJSONUtil.objectToJSON;
if (f) {
v = f(v);
if (typeof v == 'string') {
if (b) {
a[a.length] = ',';
}
a.push(IlvJSONUtil.stringToJSON(i), ':', v);
b = true;
}
}
}
a[a.length] = '}';
return a.join('');
}
