/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvLegend(left, top, width, height, view) {
if (!window.IlvEmptyView)
alert("IlvLegend requires IlvEmptyView");
this.superConstructor(left, top, width, height);
this.fontSize = 1;
this.titleFontSize = 1;
this.title = 'Layers';
this.titleColor = '#D4D4D4';
this.titleTextColor = 'black';
this.textColor = 'black';
this.background = '#FFFFFF';
this.view = view;
this.layer = new IlvHTMLPanel('');
this.layer.setBounds(left, top, width, height);
this.layer.setVisible(true);
IlvLegend.instances[this.toString()] = this;
var legend = this;
view.addCapabilitiesOnLoadListener(function(view) { legend.fillLayers(); } );
}
IlvLegend.prototype = new IlvEmptyView;
IlvLegend.prototype.setClassName("IlvLegend");
IlvLegend.instances = new Array();
IlvLegend.prototype.getView = function() {
return this.view;
}
IlvLegend.prototype.setTitle = function(title) {
this.title = title;
this.fillLayers();
}
IlvLegend.prototype.getTitle = function() {
return this.title;
}
IlvLegend.prototype.setTitleBackgroundColor = function(color) {
this.titleColor = color;
this.fillLayers();
}
IlvLegend.prototype.getTitleBackgroundColor = function() {
return this.titleColor;
}
IlvLegend.prototype.setTitleForegroundColor = function(color) {
this.titleTextColor = color;
this.fillLayers();
}
IlvLegend.prototype.getTitleForegroundColor = function() {
return this.titleTextColor;
}
IlvLegend.prototype.setTextColor = function(color) {
this.textColor = color;
this.fillLayers();
}
IlvLegend.prototype.getTextColor = function() {
return this.textColor;
}
IlvLegend.prototype.setFontSize = function(size) {
this.fontSize = size
this.fillLayers();
}
IlvLegend.prototype.getFontSize = function() {
return this.fontSize;
}
IlvLegend.prototype.setTitleFontSize = function(size) {
this.titleFontSize = size
this.fillLayers();
}
IlvLegend.prototype.getTitleFontSize = function() {
return this.titleFontSize;
}
IlvLegend.prototype.setBackgroundColor = function(color) {
this.background = color;
this.fillLayers();
}
IlvLegend.prototype.getBackgroundColor = function() {
return this.background;
}
IlvLegend.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke('setChildrenBounds', left, top, width, height);
this.layer.setBounds(left, top, width, height);
}
IlvLegend.prototype.fillLayers = function() {
if (!this.view.isCapabilitiesLoaded())
return;
var content = '<div style="width: ' + this.width + '; height: '+
this.height;
if (IlvBrowserInfo.instance.ie5up || document.getElementById)
content += '; overflow: auto;">';
else
content += ';">';
content += '<form><table><tr bgcolor="' +
this.titleColor + '"><td><p><font size="' + this.titleFontSize +
'" color="' + this.titleTextColor + '">' +
this.title + '</font></p></td></tr>';
var view = this.view;
var allLayers;
var visibleLayers;
if (view.isTiled()) {
allLayers = view.getDynamicLayers();
} else {
allLayers = view.getLayers();
}
for (var i = allLayers.length-1; i >= 0; i--) {
content += '<tr><td>';
content += '<p><input type="CHECKBOX" name="' + allLayers[i] + '"';
if (view.isLayerVisible(allLayers[i]))
content += ' CHECKED ';
content += 'onclick=IlvLegend.prototype.toggleLayer("' +
this.toString() + '",' + i + ')>'
content += '<font color="' + this.textColor +
'" size="' + this.fontSize + '">' +
allLayers[i] + '</font></p>';
content += '</td></tr>';
}
content += '</table></form></div>';
this.layer.setBackgroundColor(this.getBackgroundColor());
this.layer.setContent(content);
}
IlvLegend.prototype.toggleLayer = function(legendName, index) {
var legend = IlvLegend.instances[legendName];
var view = legend.view;
var allLayers
if (view.isTiled()) {
allLayers = view.getDynamicLayers();
} else {
allLayers = view.getLayers();
}
var name = allLayers[index];
view.setLayerVisible(name, !view.isLayerVisible(name));
}
IlvLegend.prototype.removeHTML = function () {
this.layer.removeHTML();
}
