/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvPanTool(left, top, view) {
if (!window.IlvButton)
alert("IlvPanTool requires IlvButton");
var width =  3*IlvPanTool.buttonSize + 6;
var height = width;
this.superConstructor(left, top, width, height);
this.view = view;
this.infoPanel = null;
this.enabled = true;
IlvPanTool.instances[this.toString()] = this;
this.buttons = [];
var s = IlvPanTool.buttonSize;
this.buttons[0] = this.createButton(left, top, s, s, 'topleft', 'panNorthWest',
'Pan North West');
this.buttons[1] = this.createButton(left + width/2 - s/2, top,s,s,'top',
'panNorth', 'Pan North');
this.buttons[2] = this.createButton(left + width - s, top,s, s,'topright',
'panNorthEast', 'Pan North East');
this.buttons[3] = this.createButton(left, top + height/2 - s/2, s,s,'left',
'panWest', 'Pan West');
this.buttons[4] = this.createButton(left + width/2 - s/2,
top + height/2 - s/2, s,s,
'center', 'showAll', 'Show All');
this.buttons[5] = this.createButton(left + width - s, top + height/2 - s/2, s, s,
'right', 'panEast', 'Pan East');
this.buttons[6] = this.createButton(left, top + height - s, s, s, 'bottomleft',
'panSouthWest', 'Pan South West');
this.buttons[7] = this.createButton(left + width/2 - s/2, top + height - s, s, s,
'bottom', 'panSouth', 'Pan South');
this.buttons[8] = this.createButton(left + width - s, top + height - s, s,s,
'bottomright', 'panSouthEast',
'Pan South East');
}
IlvPanTool.prototype = new IlvEmptyView
IlvPanTool.prototype.setClassName('IlvPanTool');
IlvPanTool.buttonSize = 16;
IlvPanTool.instances = new Array();
IlvPanTool.prototype.removeHTML = function () {
for (i = 0; i < 9; i++)
this.buttons[i].removeHTML();
}
IlvPanTool.prototype.updateVisibility = function () {
for (i = 0; i < 9; i++)
this.buttons[i].updateVisibility();
}
IlvPanTool.prototype.setViewInternal = function (view) {
this.view = view;
}
IlvPanTool.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke('setChildrenBounds', left, top, width, height);
var s = IlvPanTool.buttonSize;
this.buttons[0].setLocation(left, top);
this.buttons[1].setLocation(left + width/2 - s/2, top);
this.buttons[2].setLocation(left + width - s, top);
this.buttons[3].setLocation(left, top + height/2 - s/2);
this.buttons[4].setLocation(left + width/2 - s/2, top + height/2 - s/2);
this.buttons[5].setLocation(left + width - s, top + height/2 - s/2);
this.buttons[6].setLocation(left, top + height - s);
this.buttons[7].setLocation(left + width/2 - s/2, top + height - s);
this.buttons[8].setLocation(left + width - s, top + height - s);
}
IlvPanTool.prototype.childrenToHTML = function() {
this.superInvoke('childrenToHTML');
var i;
for (i = 0 ; i < 9 ; i++) {
this.buttons[i].toHTML();
}
}
IlvPanTool.prototype.setMessagePanel = function(panel) {
var i;
for (i = 0 ; i < 9 ; i++) {
this.buttons[i].setMessagePanel(panel);
}
this.infoPanel = panel;
}
IlvPanTool.prototype.getMessagePanel = function() {
return this.infoPanel;
}
IlvPanTool.prototype.setEnabled = function(enabled) {
if (enabled != this.enabled) {
var i;
for (i = 0 ; i < 9 ; i++) {
this.buttons[i].setEnabled(enabled);
}
this.enabled = enabled;
}
}
IlvPanTool.prototype.isEnabled = function(l) {
return this.enabled;
}
IlvPanTool.prototype.createButton = function(left, top, width, height,
image, func, message) {
var b =  new IlvButton(left, top, width, height,
IlvFrameworkConstants.frameworkPath + image + '.gif',
'IlvPanTool.instances["' +
this.toString() + '"].view.' +
func + '()');
b.setRolloverImage(IlvFrameworkConstants.frameworkPath + image + 'h.gif');
b.setMessage(message);
b.setToolTipText(message);
return b;
}
