/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvFacesViewProxy (clientId, refNodeId, width, height, additionnalParams) {
this.superConstructor(clientId);
if (clientId) {
var size = this.getCreationSize(refNodeId, width, height);
var view = this.createInstance([size.width, size.height, additionnalParams]);
this.setJViewsDHTMLObject(view);
this.setServletClass("ilog.views.faces.dhtml.servlet.$ns$IlvFacesManagerServlet");
this.registerResizeListener(view);
view.setStateInCookie(false);
view.saveState = $ns$IlvFacesViewProxy.saveState;
view.restoreState = $ns$IlvFacesViewProxy.restoreState;
this.addRequestParameters();
}
}
$ns$IlvFacesViewProxy.prototype = new $ns$IlvBasicViewProxy;
$ns$IlvFacesViewProxy.prototype.setClassName("$ns$IlvFacesViewProxy");
$ns$IlvFacesViewProxy.prototype.createInstance = function (params) {
return new $ns$IlvFacesView(0, 0, params[0], params[1]);
}
$ns$IlvFacesViewProxy.prototype.setStateURL = function (state) {
this.stateURL = state;
this.notify("StateURL");
}
$ns$IlvFacesViewProxy.prototype.getStateURL = function () {
return this.stateURL;
}
$ns$IlvFacesViewProxy.prototype.setResizable = function (resizable) {
this.getJViewsDHTMLObject().setResizable(resizable);
this.notify("Resizable");
}
$ns$IlvFacesViewProxy.prototype.isResizable = function (resizable) {
return this.getJViewsDHTMLObject().isResizable();
}
$ns$IlvFacesViewProxy.saveState = function (view) {
var proxy = view.JSFRef;
var state = unescape(view.getRequest());
if (state) {
state = escape(state);
proxy.setStateURL(state);
}
}
$ns$IlvFacesViewProxy.restoreState = function (view) {
var proxy = view.JSFRef;
var state = proxy.getStateURL();
if (state) {
state = unescape(state);
view.initFromUrl(state);
view.capabilitiesListeners.notify(view);
var layer = view.parseValue(state, 'layer');
if (layer == 'init') {
for (var i = 0;i < view.allLayers.length;i++)
view.visibleLayers[i] = true;
}
var bbox = view.parseValue(state, 'bbox');
if (bbox == 'init') {
view.showAll();
} else {
view.recenter();
view.updateImage();
}
} else {
view.capabilitiesListeners.notify(view);
view.showAll();
}
}
$ns$IlvFacesViewProxy.prototype.setInteractor = function (interactor) {
this.interactor = interactor;
this.getJViewsDHTMLObject().setInteractor(interactor.getJViewsDHTMLObject());
this.notify("InteractorId");
}
$ns$IlvFacesViewProxy.prototype.getInteractor = function () {
return this.interactor;
}
$ns$IlvFacesViewProxy.prototype.getInteractorId = function () {
return this.interactor.getAbsoluteId();
}
$ns$IlvFacesViewProxy.prototype.getZoomFactor = function () {
return this.getJViewsDHTMLObject().getZoomFactor();
}
$ns$IlvFacesViewProxy.prototype.setZoomFactor = function (zoomFactor) {
this.getJViewsDHTMLObject().setZoomFactor(zoomFactor);
this.notify("ZoomFactor");
}
$ns$IlvFacesViewProxy.prototype.zoomIn = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomIn();
if(updateImage)
view.updateImage();
}
$ns$IlvFacesViewProxy.prototype.zoomOut = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomOut();
if(updateImage)
view.updateImage();
}
$ns$IlvFacesViewProxy.prototype.zoomBy = function (amount, updateImage) {
var view = this.getJViewsDHTMLObject();
view.zoomBy(amount);
if(updateImage)
view.updateImage();
}
$ns$IlvFacesViewProxy.prototype.showAll = function (updateImage) {
var view = this.getJViewsDHTMLObject();
view.showAll();
if(updateImage)
view.updateImage();
}
$ns$IlvFacesViewProxy.prototype.getPanFactor = function () {
return this.getJViewsDHTMLObject().getPanFactor();
}
$ns$IlvFacesViewProxy.prototype.setPanFactor = function (panFactor) {
this.getJViewsDHTMLObject().setPanFactor(panFactor);
this.notify("PanFactor");
}
$ns$IlvFacesViewProxy.prototype.getUpdateInterval = function () {
return this.getJViewsDHTMLObject().getUpdateInterval();
}
$ns$IlvFacesViewProxy.prototype.setUpdateInterval = function (updateInterval) {
this.getJViewsDHTMLObject().setUpdateInterval(updateInterval);
this.notify("UpdateInterval");
}
$ns$IlvFacesViewProxy.prototype.getImageFormat = function () {
return this.getJViewsDHTMLObject().getImageFormat();
}
$ns$IlvFacesViewProxy.prototype.setImageFormat = function (imageFormat) {
this.getJViewsDHTMLObject().setImageFormat(imageFormat);
this.notify("ImageFormat");
}
$ns$IlvFacesViewProxy.prototype.getWaitingImage = function () {
return this.getJViewsDHTMLObject().getWaitingImage();
}
$ns$IlvFacesViewProxy.prototype.setWaitingImage = function (waitingImage) {
this.getJViewsDHTMLObject().setWaitingImage(waitingImage);
this.notify("WaitingImage");
}
$ns$IlvFacesViewProxy.prototype.getGenerateImageMap = function () {
return this.getJViewsDHTMLObject().getGenerateImageMap();
}
$ns$IlvFacesViewProxy.prototype.setGenerateImageMap = function (generateImageMap) {
this.getJViewsDHTMLObject().setGenerateImageMap(generateImageMap);
this.notify("GenerateImageMap");
}
$ns$IlvFacesViewProxy.prototype.getImageMapVisible = function () {
return this.getJViewsDHTMLObject().imageMapVisible;
}
$ns$IlvFacesViewProxy.prototype.setImageMapVisible = function (imageMapVisible) {
if (imageMapVisible)
this.getJViewsDHTMLObject().showImageMap();
else
this.getJViewsDHTMLObject().hideImageMap();
this.notify("ImageMapVisible");
}
$ns$IlvFacesViewProxy.prototype.getImageMapGenerator = function () {
return this.imageMapGenerator;
}
$ns$IlvFacesViewProxy.prototype.setImageMapGenerator = function (imageMapGenerator) {
this.imageMapGenerator = imageMapGenerator;
this.notify("ImageMapGenerator");
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("imapGenerator", imageMapGenerator);
}
$ns$IlvFacesViewProxy.prototype.getBackgroundColor = function () {
return this.getJViewsDHTMLObject().getImageBackgroundColor();
}
$ns$IlvFacesViewProxy.prototype.setBackgroundColor = function (backgroundColor) {
this.getJViewsDHTMLObject().setImageBackgroundColor(backgroundColor);
this.notify("BackgroundColor");
}
$ns$IlvFacesViewProxy.prototype.getOnImageLoaded = function () {
return this.onImageLoaded;
}
$ns$IlvFacesViewProxy.prototype.setOnImageLoaded = function (onImageLoaded) {
this.onImageLoaded = onImageLoaded;
this.getJViewsDHTMLObject().addImageOnLoadListener(onImageLoaded);
this.notify("OnImageLoaded");
}
$ns$IlvFacesViewProxy.prototype.getOnCapabilitiesLoaded = function () {
return this.capabilitiesLoaded;
}
$ns$IlvFacesViewProxy.prototype.setOnCapabilitiesLoaded = function (onCapabilitiesLoaded) {
this.capabilitiesLoaded = onCapabilitiesLoaded;
this.getJViewsDHTMLObject().addCapabilitiesOnLoadListener(onCapabilitiesLoaded);
this.notify("OnCapabilitiesLoaded");
}
$ns$IlvFacesViewProxy.prototype.getErrorMessage = function () {
return this.getJViewsDHTMLObject().getErrorMessage();
}
$ns$IlvFacesViewProxy.prototype.setErrorMessage = function (errorMessage) {
this.getJViewsDHTMLObject().setErrorMessage(errorMessage);
this.notify("ErrorMessage");
}
$ns$IlvFacesViewProxy.prototype.getServlet = function () {
return this.getServletClass();
}
$ns$IlvFacesViewProxy.prototype.setServlet = function (servlet) {
this.setServletClass(servlet);
this.notify("Servlet");
}
$ns$IlvFacesViewProxy.prototype.setServletURL = function (servletURL) {
this.getJViewsDHTMLObject().setRequestURL(servletURL);
this.notify("ServletURL");
}
$ns$IlvFacesViewProxy.prototype.getServletURL = function () {
return this.getJViewsDHTMLObject().getRequestURL();
}
$ns$IlvFacesViewProxy.prototype.performAction = function (action, params) {
this.getJViewsDHTMLObject().performAction(action, params);
}
$ns$IlvFacesViewProxy.prototype.updateImage = function() {
this.getJViewsDHTMLObject().updateImage();
}
$ns$IlvFacesViewProxy.prototype.setAutoUpdateCapabilities = function(update) {
this.getJViewsDHTMLObject().setAutoUpdateCapabilities(update);
this.notify("AutoUpdateCapabilities");
}
$ns$IlvFacesViewProxy.prototype.isAutoUpdateCapabilities = function() {
return this.getJViewsDHTMLObject().isAutoUpdateCapabilities();
}
$ns$IlvFacesViewProxy.prototype.setStaticLayersCount = function (slc) {
this.staticLayersCount = slc;
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("slc", slc);
}
$ns$IlvFacesViewProxy.prototype.updateAll = function (showAll, keepLayerVisibility) {
var view = this.getJViewsDHTMLObject();
view.updateAll(showAll, keepLayerVisibility);
}
$ns$IlvFacesViewProxy.prototype.moveTo = function(x, y) {
this.getJViewsDHTMLObject().moveTo(x, y);
}
$ns$IlvFacesViewProxy.prototype.panEast = function() {
this.getJViewsDHTMLObject().panEast();
}
$ns$IlvFacesViewProxy.prototype.panWest = function() {
this.getJViewsDHTMLObject().panWest();
}
$ns$IlvFacesViewProxy.prototype.panSouth = function() {
this.getJViewsDHTMLObject().panSouth();
}
$ns$IlvFacesViewProxy.prototype.panNorth = function() {
this.getJViewsDHTMLObject().panNorth();
}
$ns$IlvFacesViewProxy.prototype.panSouthEast = function() {
this.getJViewsDHTMLObject().panSouthEast();
}
$ns$IlvFacesViewProxy.prototype.panNorthEast = function() {
this.getJViewsDHTMLObject().panNorthEast();
}
$ns$IlvFacesViewProxy.prototype.panSouthWest = function() {
this.getJViewsDHTMLObject().panSouthWest();
}
$ns$IlvFacesViewProxy.prototype.panNorthWest = function() {
this.getJViewsDHTMLObject().panNorthWest();
}
$ns$IlvFacesViewProxy.prototype.setPopupMenu = function(popupMenu) {
this.getJViewsDHTMLObject().setPopupMenu(popupMenu.getJViewsDHTMLObject());
}
$ns$IlvFacesViewProxy.prototype.getPopupMenu = function(popupMenu) {
return this.getJViewsDHTMLObject().getPopupMenu();
}
$ns$IlvFacesViewProxy.prototype.addRequestParameters = function() {
this.superInvoke("addRequestParameters");
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("facesComponentId", this.clientId);
}
$ns$IlvFacesViewProxy.prototype.setMaxZoomLevel = function(maxZoomLevel) {
this.maxZoomLevel = maxZoomLevel;
if (maxZoomLevel) {
this.notify("MaxZoomLevel");
}
}
$ns$IlvFacesViewProxy.prototype.getMaxZoomLevel = function() {
return this.maxZoomLevel;
}
$ns$IlvFacesViewProxy.prototype.setZoomLevels = function(zoomLevels) {
this.zoomLevels = zoomLevels;
if(zoomLevels) {
this.notify("ZoomLevels");
}
}
$ns$IlvFacesViewProxy.prototype.getZoomLevels = function() {
return this.zoomLevels;
}
$ns$IlvFacesViewProxy.prototype.performJSFAction = function(mb, params) {
var p = params ? [mb].concat(params) : [mb];
this.performAction("jsfAction", p);
}
$ns$IlvFacesViewProxy.prototype.setNamespace = function(namespace) {
var view = this.getJViewsDHTMLObject();
view.setAdditionalParameters("namespace", namespace);
}
