/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvFacesZoomToolProxy (clientId, refNodeId, width, height, nbbuttons, orientation) {
this.superConstructor(clientId);
var minW;
var minH;
this.orientation = orientation;
if (orientation == 'Vertical'){
minW = $ns$IlvZoomTool.buttonSize;
minH = $ns$IlvZoomTool.buttonSize * nbbuttons;
} else {
minH = $ns$IlvZoomTool.buttonSize;
minW = $ns$IlvZoomTool.buttonSize * nbbuttons;
}
this.nbButtons = nbbuttons;
this.setMinimumSize(minW, minH);
var size = this.getCreationSize(refNodeId);
var pos = this.positionAfterLayout(size.width, size.height);
var z = new $ns$IlvZoomTool(pos.x, pos.y, size.width, size.height, nbbuttons);
this.setJViewsDHTMLObject(z);
z.setOrientation(orientation);
}
$ns$IlvFacesZoomToolProxy.prototype = new $ns$IlvBasicViewHelperProxy;
$ns$IlvFacesZoomToolProxy.prototype.setClassName("$ns$IlvFacesZoomToolProxy");
$ns$IlvFacesZoomToolProxy.prototype.positionAfterLayout = function (width, height) {
var pos = new Object ();
if (this.orientation == 'Vertical'){
pos.x = width / 2;
pos.y = 0;
} else {
pos.x = 0;
pos.y = height / 2;
}
return pos;
}
$ns$IlvFacesZoomToolProxy.prototype.getNbButtons = function () {
return this.nbButtons;
}
$ns$IlvFacesZoomToolProxy.prototype.setNbButtons = function (nbButtons) {
this.nbButtons = nbButtons;
this.notify("NbButtons");
}
$ns$IlvFacesZoomToolProxy.prototype.getOrientation = function () {
return this.getJViewsDHTMLObject().getOrientation();
}
$ns$IlvFacesZoomToolProxy.prototype.setOrientation = function (orientation) {
this.getJViewsDHTMLObject().setOrientation(orientation);
this.notify("Orientation");
}
$ns$IlvFacesZoomToolProxy.prototype.setMessageBox = function (messageBox) {
this.messageBox = messageBox;
var zoomTool =  this.getJViewsDHTMLObject();
if (zoomTool.buttons)
zoomTool.setMessagePanel(messageBox.getJViewsDHTMLObject());
this.notify("MessageBoxId");
}
$ns$IlvFacesZoomToolProxy.prototype.toHTML = function () {
this.jviewsObject.toHTML();
if (this.messageBox)
this.jviewsObject.setMessagePanel(this.messageBox.getJViewsDHTMLObject());
}
