/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvOverview(left, top, width, height, view, image) {
if (!window.$ns$IlvAbstractView)
alert("$ns$IlvOverview requires $ns$IlvAbstractView");
this.superConstructor(left, top, width, height);
this.eventPanel.setZIndex(5);
this.lineWidth = 2;
this.staticImage = (typeof(image)=="string") ? image : null;
this.color = 'black';
this.visible = false;
this.ghostW = 0;
this.ghostH = 0;
this.imageH = height;
this.imageW = width;
this.overviewRefresh = false;
this.firstTime = true;
this.fill = false;
this.opacity = 0.5;
this.imagePanel = new $ns$IlvImageView(left, top, width, height);
this.imagePanel.setImageSize(3, 3);
this.setMessage('Move rectangle to recenter view');
this.animated = false;
if (view)
this.setViewInternal(view);
}
$ns$IlvOverview.prototype = new $ns$IlvAbstractView;
$ns$IlvOverview.prototype.setClassName("$ns$IlvOverview");
$ns$IlvOverview.prototype.setViewInternal = function (view) {
if (view) {
var overview=this;
this.view = view;
view.addImageOnLoadListener(function(view) {overview.onImageLoaded(view)});
view.addCapabilitiesOnLoadListener(function(view) {overview.onCapabilitiesLoaded(view)});
if (view.isTiled()) {
view.addViewBBoxListener(function(view) {overview.onViewBBoxChanged(view)});
view.addEndPanAnimationListener(function(view, cancel) {overview.onEndPanAnimation(view, cancel)});
}
}
}
$ns$IlvOverview.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
this.imagePanel.removeHTML();
if (this.rect != null)
this.rect.removeHTML();
}
$ns$IlvOverview.prototype.updateVisibility = function () {
this.superInvoke("updateVisibility");
this.imagePanel.updateVisibility();
if (this.rect != null)
this.rect.updateVisibility();
}
$ns$IlvOverview.prototype.getTargetView = function() {
return this.view;
}
$ns$IlvOverview.prototype.setMessage = function (message) {
this.message = message;
}
$ns$IlvOverview.prototype.getMessage = function () {
return this.message;
}
$ns$IlvOverview.prototype.setMessagePanel = function ($ns$ilvHTMLPanel) {
this.infoPanel = $ns$ilvHTMLPanel;
}
$ns$IlvOverview.prototype.getMessagePanel = function () {
return this.infoPanel;
}
$ns$IlvOverview.prototype.setColor = function(color) {
this.color = color;
if (this.rect) {
this.rect.setColor(color);
}
if (this.rect2) {
this.rect2.setColor(color);
}
}
$ns$IlvOverview.prototype.getColor = function() {
return this.color;
}
$ns$IlvOverview.prototype.setFillOn = function(fill) {
this.fill = fill;
if (this.rect) {
this.rect.setFillOn(fill);
}
}
$ns$IlvOverview.prototype.isFillOn = function() {
return this.fill;
}
$ns$IlvOverview.prototype.setOpacity = function(opacity) {
this.opacity = opacity;
if (this.rect) {
this.rect.setOpacity(opacity);
}
}
$ns$IlvOverview.prototype.getOpacity = function() {
return this.opacity;
}
$ns$IlvOverview.prototype.setLineWidth = function(lw) {
this.lineWidth = lw;
if (this.rect) {
this.rect.setThickness(lw);
this.adjust();
}
if (this.rect2) {
this.rect2.setThickness(lw+1);
}
}
$ns$IlvOverview.prototype.getLineWidth = function() {
return this.lineWidth;
}
$ns$IlvOverview.prototype.setAnimatedPan = function(anim) {
this.animated = anim;
}
$ns$IlvOverview.prototype.isAnimatedPan = function() {
return this.animated;
}
$ns$IlvOverview.prototype.setAutoRefresh = function(set) {
this.overviewRefresh = set;
}
$ns$IlvOverview.prototype.isAutoRefresh = function() {
return this.overviewRefresh;
}
$ns$IlvOverview.prototype.mouseDown = function(e) {
this.dragging = true;
return this.mouseDrag(e);
}
$ns$IlvOverview.prototype.mouseOver = function(e) {
if (this.message) {
window.status = this.message;
if (this.view.initialized && this.infoPanel)
this.infoPanel.setContent(this.message);
}
}
$ns$IlvOverview.prototype.mouseOut = function(e) {
if (this.message) {
window.status = '';
if (this.view.initialized && this.infoPanel)
this.infoPanel.setContent('');
}
}
$ns$IlvOverview.prototype.mouseDrag = function(e) {
var x = e.mouseX;
var y = e.mouseY;
var h = this.ghostH;
var w = this.ghostW;
if (x < w/2)
x = w/2;
if (y < h/2)
y = h/2;
if (x + w/2 > this.imageW)
x = this.imageW - w/2;
if (y + h/2 > this.imageH)
y = this.imageH - h/2;
this.drawRect(x - w/2, y - h/2, x + w/2, y + h/2);
return true;
}
$ns$IlvOverview.prototype.mouseUp = function(e) {
if (this.dragging == false)
return false;
this.dragging = false;
var mouseX = e.mouseX;
var mouseY = e.mouseY;
var v = this.view;
var bbox = v.getManagerBBox();
mouseX = bbox.left + mouseX*(bbox.width)/this.imageW;
mouseY = bbox.top + mouseY*(bbox.height)/this.imageH;
var h = this.ghostH;
var w = this.ghostW;
if (this.view != null) {
if (this.animated && this.view.isTiled()) {
var b = this.rect.getBounds();
this.rect2.setBounds(b.left, b.top, b.width, b.height)
this.rect2.setVisible(true);
var vBBox = this.view.getViewBBox();
this.view.qbboxx = mouseX - vBBox.width/2;
this.view.qbboxy = mouseY - vBBox.height/2;
this.view.recenter();
var destBBox = this.view.getViewBBox();
this.view.qbboxx = vBBox.left;
this.view.qbboxy = vBBox.top;
this.view.createPanAnimation(destBBox.left, destBBox.top);
} else {
this.view.centerAt(mouseX, mouseY);
}
}
return false;
}
$ns$IlvOverview.prototype.drawRect = function(left, top, right, bottom) {
if (left < 0)
left = 0;
if (left > this.imageW)
left = this.imageW;
if (right < 0)
right = 0;
if (right > this.imageW)
right = this.imageW;
if (top < 0)
top = 0;
if (top > this.imageH)
top = this.imageH;
if (bottom < 0)
bottom = 0;
if (bottom > this.imageH)
bottom = this.imageH;
this.rect.setBounds(this.getLeft() + left, this.getTop() + top,
right - left, bottom - top);
}
$ns$IlvOverview.prototype.adjust = function() {
var bbox = this.view.getViewBBox();
var managerBBox = this.view.getManagerBBox();
var x = bbox.left;
var y = bbox.top;
var w = bbox.width;
var h = bbox.height;
var globalH = managerBBox.height;
var globalW = managerBBox.width;
var zleft = parseInt((x - managerBBox.left)*this.imageW/globalW);
var zright = parseInt((x + w - managerBBox.left)*this.imageW/globalW);
var ztop = parseInt((y - managerBBox.top)*this.imageH/globalH);
var zbottom = parseInt((y + h - managerBBox.top)*this.imageH/globalH);
if (isNaN(zleft)) zleft = 0;
if (isNaN(zright)) zright = 0;
if (isNaN(ztop)) ztop = 0;
if (isNaN(zbottom)) zbottom = 0;
this.ghostW = zright - zleft;
this.ghostH = zbottom - ztop;
this.drawRect(zleft, ztop, zright, zbottom);
if (this.visible == false) {
this.rect.setVisible(true);
this.visible = true;
}
}
$ns$IlvOverview.prototype.onCapabilitiesLoaded = function(view) {
this.firstTime = true;
this.updateOverviewImage();
this.adjust();
}
$ns$IlvOverview.prototype.updateOverviewImage = function() {
if (this.staticImage != null)
return;
if (!this.view.isCapabilitiesLoaded())
return;
var managerBBox = this.view.getManagerBBox();
var newH = parseInt(managerBBox.height* this.getWidth()/managerBBox.width);
if (newH <= this.getHeight()) {
this.imageW = this.getWidth();
this.imageH = newH;
} else {
this.imageH = this.getHeight();
this.imageW = parseInt(managerBBox.width*this.imageH/
managerBBox.height);
}
if(isNaN(this.imageH) || this.imageH == 0)
this.imageH = this.getHeight();
if (isNaN(this.imageW) || this.imageW == 0)
this.imageW = this.getWidth();
var currentImageSize = this.imagePanel.getImageSize();
var resizeImage = (currentImageSize.width != this.imageW || currentImageSize.height != this.imageH);
var imagesrc = this.view.createRequestURL(managerBBox.left,
managerBBox.top,
managerBBox.width,
managerBBox.height,
this.imageW,
this.imageH,
this.view.getOverviewLayers()) +
"&overview=true";
if (resizeImage) {
this.imagePanel.setImage(imagesrc, this.imageW, this.imageH);
} else {
this.imagePanel.setImage(imagesrc);
}
}
$ns$IlvOverview.prototype.onImageLoaded = function(view) {
if (this.overviewRefresh && !this.firstTime) {
this.updateOverviewImage();
}
this.firstTime = false;
if (!this.dragging) {
this.adjust();
}
}
$ns$IlvOverview.prototype.onViewBBoxChanged = function(view) {
if (!this.dragging) {
this.adjust();
}
}
$ns$IlvOverview.prototype.onEndPanAnimation = function(view, cancel) {
this.rect2.setVisible(false);
}
$ns$IlvOverview.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
this.imagePanel.setBounds(left, top, width, height);
if (this.inHTML) {
if (this._resized)
this.updateOverviewImage();
this.adjust();
}
}
$ns$IlvOverview.prototype.childrenToHTML = function() {
if (!this.staticImage)
this.imagePanel.setImage(this.staticImage);
this.imagePanel.toHTML();
this.rect = new $ns$IlvRectangle(null, true);
this.rect.setThickness(this.lineWidth);
this.rect.setZIndex(3);
this.rect.setFillOn(this.fill);
this.rect.setOpacity(this.opacity);
this.rect2 = new $ns$IlvRectangle();
this.rect2.setThickness(this.lineWidth+1);
this.rect2.setZIndex(3);
this.rect2.setVisible(false);
this.setColor(this.color);
this.superInvoke("childrenToHTML");
this.imagePanel.imagePanel.setZIndex(2);
}
