/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

if (typeof($ns$IlvFrameworkConstants) == 'undefined') {
$ns$IlvFrameworkConstants = function () {}
$ns$IlvFrameworkConstants.basePath = 'script/images/';
$ns$IlvFrameworkConstants.frameworkPath = 'script/framework/images/';
}
function $ns$IlvView(left, top, width, height, namespace) {
if (!window.$ns$IlvAbstractView)
alert("$ns$IlvView requires $ns$IlvAbstractView");
this.superConstructor(left, top, width, height, namespace);
this.format = 'JPEG';
this.imageMap = false;
this.qbboxx = 0;
this.qbboxy = 0;
this.qbboxw = 100;
this.qbboxh = 100;
this.minx = 0;
this.maxx = 0;
this.maxy = 0;
this.miny = 0;
this.requestURL = null;
this.maxZoom = 0;
this.capabilitiesLoaded = false;
this.panFactor = 0.5;
this.zoomFactor = 1.5;
$ns$IlvView.instances[this.toString()] = this;
this.imagePanel = new $ns$IlvImageView(left, top, width, height);
this.imagePanel.$ns$ilvView = this;
this.imagePanel.setImageSize(3, 3);
this.imagePanel.addErrorListener($ns$IlvView.onImageError);
this.imagePanel.addImagePreloadListener($ns$IlvView.onImagePreloaded);
this.imagePanel.addImageLoadListener($ns$IlvView.onImageLoaded);
this.imagePanel.addTimeoutErrorListener($ns$IlvView.onImageTimeoutError);
this.imageMapVisible = false;
this.allLayers = null;
this.visibleLayers = null;
this.overviewLayers = null;
this.updateIntervalID = null;
this.additionalParams = [];
this.autoUpdateCapabilities = false;
this.interactor = null;
this.updateInterval = 0;
this.error = false;
this.errorListeners = new $ns$IlvListenerList();
this.capabilitiesListeners = new $ns$IlvListenerList();
this.interactorListeners = new $ns$IlvListenerList();
this.updateListeners = new $ns$IlvListenerList();
this.beforeSwapListeners = new $ns$IlvListenerList();
this.timeOutListeners = new $ns$IlvListenerList();
this.imgbgcolor = null;
this.initialized = false;
this.waitingImage = $ns$IlvFrameworkConstants.basePath + 'wait.gif';
this.errorMessage = '<a>Sorry Service not available, try later</a>';
this.deleteCookieOnDispose = false;
this.registerDispose();
}
$ns$IlvView.prototype = new $ns$IlvAbstractView();
$ns$IlvView.prototype.setClassName("$ns$IlvView");
$ns$IlvView.instances = [];
$ns$IlvView.basePath = $ns$IlvFrameworkConstants.basePath;
$ns$IlvView.frameworkPath = $ns$IlvFrameworkConstants.frameworkPath;
$ns$IlvView.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
this.imagePanel.removeHTML();
if (this.waitPanel)
this.waitPanel.removeHTML();
if (this.imageMapPanel)
this.imageMapPanel.removeHTML();
if (this.rectPanel)
this.rectPanel.removeHTML();
if(this.capabilitiesPanel)
this.capabilitiesPanel.removeHTML();
if (this.imageMapPanelPost)
this.imageMapPanelPost.removeHTML();
}
$ns$IlvView.prototype.updateVisibility = function (){
this.superInvoke("updateVisibility");
this.imagePanel.updateVisibility();
if (this.waitPanel)
this.waitPanel.updateVisibility();
if (this.imageMapPanel)
this.imageMapPanel.updateVisibility();
if (this.rectPanel)
this.rectPanel.updateVisibility();
if(this.capabilitiesPanel)
this.capabilitiesPanel.updateVisibility();
if (this.imageMapPanelPost)
this.imageMapPanelPost.updateVisibility();
}
$ns$IlvView.prototype.setPopupMenu = function(popupMenu) {
this.popupMenu = popupMenu;
this.popupMenu.setViewInternal(this);
}
$ns$IlvView.prototype.getPopupMenu = function() {
return this.popupMenu;
}
$ns$IlvView.prototype.setRequestURL = function (requestURL) {
this.requestURL = requestURL;
}
$ns$IlvView.prototype.getRequestURL = function () {
return this.requestURL;
}
$ns$IlvView.prototype.init = function() {
this.getCapabilities(true, true, false);
this.initialized = true;
}
$ns$IlvView.prototype.setDeletingCookieOnDispose = function(del) {
if(del)
this.deleteCookieOnDispose = true;
else
this.deleteCookieOnDispose = false;
}
$ns$IlvView.prototype.isDeletingCookieOnDispose = function() {
return this.deleteCookieOnDispose;
}
$ns$IlvView.prototype.setImageFormat = function(format) {
this.format = format;
}
$ns$IlvView.prototype.getImageFormat = function() {
return this.format;
}
$ns$IlvView.prototype.setWaitingImage = function(image) {
this.waitingImage = image;
if (this.waitPanel)
this.waitPanel.setContent(this.getWaitPanelHTML());
}
$ns$IlvView.prototype.getWaitingImage = function() {
return this.waitingImage;
}
$ns$IlvView.prototype.setBlendTransform = function(set) {
this.imagePanel.setBlendTransform(set);
}
$ns$IlvView.prototype.getBlendTransform = function() {
return this.imagePanel.getBlendTransform();
}
$ns$IlvView.prototype.setTimeoutErrorInterval = function(interval) {
this.imagePanel.setTimeoutInterval(interval);
}
$ns$IlvView.prototype.getTimeoutErrorInterval= function() {
return this.imagePanel.getTimeoutInterval();
}
$ns$IlvView.prototype.setInteractor = function(inter) {
if (this.interactor == inter)
return;
var old = this.interactor;
if (this.interactor != null)
this.interactor.setViewInternal(null);
this.interactor = inter;
if (inter != null)
inter.setViewInternal(this);
this.interactorListeners.notify(this, old, inter);
}
$ns$IlvView.prototype.getInteractor = function() {
return this.interactor;
}
$ns$IlvView.prototype.addInteractorListener = function(listener) {
this.interactorListeners.addListener(listener);
}
$ns$IlvView.prototype.removeInteractorListener = function(listener) {
this.interactorListeners.removeListener(listener);
}
$ns$IlvView.prototype.setUpdateInterval = function(rate) {
if (this.inHTML) {
if (this.updateIntervalID != null)
window.clearTimeout(this.updateIntervalID);
if (rate != 0)
this.updateIntervalID
= window.setTimeout('$ns$IlvView.prototype.doRefresh("' +
this.toString() + '")',rate*1000);
}
this.updateInterval = rate;
}
$ns$IlvView.prototype.getUpdateInterval = function() {
return this.updateInterval;
}
$ns$IlvView.prototype.setMessagePanel = function ($ns$ilvHTMLPanel) {
this.infoPanel = $ns$ilvHTMLPanel;
}
$ns$IlvView.prototype.getMessagePanel = function () {
return this.infoPanel;
}
$ns$IlvView.prototype.getLayers = function() {
var list = [];
for (var i = 0;i < this.allLayers.length;i++)
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvView.prototype.getVisibleLayers = function() {
var list = [];
for (var i = 0;i < this.allLayers.length;i++) {
if (this.isLayerVisible(this.allLayers[i])) {
list[list.length] = this.allLayers[i];
}
}
return list;
}
$ns$IlvView.prototype.getOverviewLayers = function() {
var list = [];
for (var i = 0;i < this.allLayers.length;i++)
if (this.overviewLayers[i])
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvView.prototype.setLayerVisible = function(layer, visible, update) {
if (typeof(update) != 'boolean')
update = true;
for (var i = 0;i < this.allLayers.length;i++)
if (this.allLayers[i] == layer &&
(this.visibleLayers[i] != visible)) {
this.visibleLayers[i] = visible;
if (update) this.updateImage();
}
}
$ns$IlvView.prototype.isLayerVisible = function(layer) {
for (var i = 0;i < this.allLayers.length;i++)
if (this.allLayers[i] == layer)
return this.visibleLayers[i];
return false;
}
$ns$IlvView.prototype.isTiled = function() {
return false;
}
$ns$IlvView.prototype.getSelectionManager = function () {
if (!this.selectManager) {
if (!window.$ns$IlvSelectionManager)
alert("You must import $ns$IlvAbstractSelectionManager.js and $ns$IlvSelectionManager.js scripts to use $ns$IlvSelectInteractor.");
else {
this.selectManager = new $ns$IlvSelectionManager();
this.selectManager.setViewInternal(this);
}
}
return this.selectManager;
}
$ns$IlvView.prototype.getContentsBounds = function () {
return this.getBounds();
}
$ns$IlvView.prototype.moveTo = function(x, y) {
this.setViewBBoxNoCheck(x, y, this.qbboxw, this.qbboxh);
}
$ns$IlvView.prototype.panEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor, this.qbboxy);
}
$ns$IlvView.prototype.panWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor, this.qbboxy);
}
$ns$IlvView.prototype.panSouth = function() {
this.moveTo(this.qbboxx, this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.panNorth = function() {
this.moveTo(this.qbboxx, this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.panSouthEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor,
this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.panNorthEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor,
this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.panSouthWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor,
this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.panNorthWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor,
this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvView.prototype.setPanFactor = function(factor) {
this.panFactor = factor;
}
$ns$IlvView.prototype.getPanFactor = function() {
return this.panFactor;
}
$ns$IlvView.prototype.setZoomFactor = function(factor) {
this.zoomFactor = factor;
}
$ns$IlvView.prototype.getZoomFactor = function() {
return this.zoomFactor;
}
$ns$IlvView.prototype.showAll = function() {
if (this.zoomLevels) {
var mBBox = this.getManagerBBox();
var zoomLevel = this.zoomLevels[0];
var qbbox = new Object();
qbbox.width = mBBox.width / zoomLevel;
qbbox.height = mBBox.height / zoomLevel;
var dif = mBBox.width - qbbox.width;
qbbox.left = mBBox.left + dif/2;
dif = mBBox.height - qbbox.height;
qbbox.top = mBBox.top + dif/2;
this.setViewBBox(qbbox.left, qbbox.top, qbbox.width, qbbox.height, true);
} else {
this.setViewBBoxNoCheck(this.minx, this.miny,
this.maxx - this.minx, this.maxy - this.miny);
}
}
$ns$IlvView.prototype.centerAt = function(x, y) {
this.setViewBBoxNoCheck(x - this.qbboxw/2, y - this.qbboxh/2,
this.qbboxw, this.qbboxh);
}
$ns$IlvView.prototype.setViewBBox = function(x, y, w, h) {
if (this.zoomLevels) {
var ratio = w/h;
var mBBox = this.getManagerBBox();
var a = mBBox.width/w;
var b = mBBox.height/h;
var  zooml = a > b? a: b;
var index = this.getNearestZoomLevel(zooml);
var nZooml = this.zoomLevels[index];
if (zooml != nZooml) {
var ow = w;
var oh = h;
if (a>b) {
w = mBBox.width / nZooml;
h = w / ratio;
} else {
h = mBBox.height / nZooml;
w = h * ratio;
}
var dif = ow - w;
x += dif/2;
dif = oh - h;
y += dif/2;
}
}
this.setViewBBoxNoCheck(x, y, w, h);
}
$ns$IlvView.prototype.setViewBBoxNoCheck = function(x, y, w, h) {
this.qbboxx = x;
this.qbboxy = y;
this.qbboxw = w;
this.qbboxh = h;
this.recenter();
this.updateImage();
}
$ns$IlvView.prototype.getNearestZoomLevel = function(zooml) {
var diff = Math.abs(zooml - this.zoomLevels[0]);
var index = 0;
for (var i=1; i<this.zoomLevels.length; i++) {
var diffC = Math.abs(zooml - this.zoomLevels[i]);
if (diffC < diff) {
diff = diffC;
index = i;
}
}
return index;
}
$ns$IlvView.prototype.getCurrentZoomLevelInternal = function() {
var res = {};
var  zooml =this.getCurrentZoomLevel()
var index = this.getNearestZoomLevel(zooml);
res.index = index;
res.realValue = zooml;
res.value = this.zoomLevels[index];
return res;
}
$ns$IlvView.prototype.applyZoomlevel = function(zoomLevel) {
var bbox = this.getViewBBox();
var managerBBox = this.getManagerBBox();
var zoom = Math.max(managerBBox.width/bbox.width,
managerBBox.height/bbox.height);
this.zoomByNoCheck(zoomLevel/zoom);
}
$ns$IlvView.prototype.zoomIn = function() {
if (this.zoomLevels) {
var zoomLevel = this.getCurrentZoomLevelInternal();
var index = zoomLevel.index;
if(index+1 < this.zoomLevels.length) {
var zooml = this.zoomLevels[index+1];
this.applyZoomlevel(zooml);
}
} else {
this.zoomBy(this.zoomFactor);
}
}
$ns$IlvView.prototype.zoomOut = function() {
if (this.zoomLevels) {
var zoomLevel = this.getCurrentZoomLevelInternal();
var index = zoomLevel.index;
var zooml;
if(index-1 >= 0) {
var zooml = this.zoomLevels[index-1];
this.applyZoomlevel(zooml);
}
} else {
this.zoomBy(1 / this.zoomFactor);
}
}
$ns$IlvView.prototype.zoomBy = function(z) {
if (this.zoomLevels) {
var a = (this.maxx - this.minx)/this.qbboxw;
var b = ((this.maxy - this.miny)/this.qbboxh);
var  cZooml = a > b? a: b;
var zooml = z * cZooml;
var index = this.getNearestZoomLevel(zooml);
zooml = this.zoomLevels[index];
this.zoomByNoCheck(zooml/cZooml);
} else {
this.zoomByNoCheck(z);
}
}
$ns$IlvView.prototype.zoomByNoCheck = function(z) {
this.setViewBBoxNoCheck(this.qbboxx + this.qbboxw*(1 - 1/z)/2,
this.qbboxy + this.qbboxh*(1 - 1/z)/2,
this.qbboxw/z, this.qbboxh/z);
}
$ns$IlvView.prototype.getMaxZoomLevel = function() {
return this.maxZoom;
}
$ns$IlvView.prototype.isAutoUpdateCapabilities = function() {
return this.autoUpdateCapabilities;
}
$ns$IlvView.prototype.setAutoUpdateCapabilities = function(set) {
this.autoUpdateCapabilities = set;
}
$ns$IlvView.prototype.getManagerBBox = function() {
var res = new Object;
res.left = this.minx;
res.top = this.miny;
res.width = this.maxx - this.minx;
res.height = this.maxy - this.miny;
return res;
}
$ns$IlvView.prototype.getViewBBox = function() {
return {left:this.qbboxx, top:this.qbboxy, width: this.qbboxw, height:this.qbboxh};
}
$ns$IlvView.prototype.isCapabilitiesLoaded = function() {
return this.capabilitiesLoaded;
}
$ns$IlvView.prototype.updateAll = function(showAll, keepLayerVisibility) {
this.capabilitiesLoaded = false;
this.stopErrorTimer();
this.getCapabilities(false, showAll, keepLayerVisibility);
}
$ns$IlvView.prototype.updateImage = function() {
if (!this.capabilitiesLoaded || this.error)
return;
if (this.updateIntervalID != null)
window.clearTimeout(this.updateIntervalID);
this.waitPanel.setVisible(true);
var currentImageSize = this.imagePanel.getImageSize();
var newImageWidth = this.getWidth();
var newImageHeight = this.getHeight();
var resizeImage = (currentImageSize.width != newImageWidth || currentImageSize.height != newImageHeight);
var request = this.getRequest();
if (resizeImage)
this.imagePanel.setImage(request, newImageWidth, newImageHeight);
else
this.imagePanel.setImage(request);
if (this.isStateInCookie())
setCookie(this.cookieName + 'url', unescape(request));
else
this.saveState(this);
}
$ns$IlvView.onImageError = function(imagePanel) {
var $ns$ilvView = imagePanel.$ns$ilvView;
$ns$ilvView.error = true;
$ns$ilvView.waitPanel.setVisible(false);
$ns$ilvView.errorListeners.notify($ns$ilvView);
}
$ns$IlvView.onImageTimeoutError = function(imagePanel) {
var $ns$ilvView = imagePanel.$ns$ilvView;
$ns$ilvView.timeoutError();
}
$ns$IlvView.onImagePreloaded = function(imagePanel) {
var $ns$ilvView = imagePanel.$ns$ilvView;
$ns$ilvView.beforeSwapListeners.notify($ns$ilvView);
}
$ns$IlvView.onImageLoaded = function(imagePanel) {
var $ns$ilvView = imagePanel.$ns$ilvView;
$ns$ilvView.waitPanel.setVisible(false);
$ns$ilvView.updateListeners.notify($ns$ilvView);
$ns$ilvView.setUpdateInterval($ns$ilvView.updateInterval);
$ns$ilvView.imagePanel.setVisible(true);
$ns$ilvView.updateImageMap();
}
$ns$IlvView.prototype.setGenerateImageMap = function(set) {
this.imageMap = set;
}
$ns$IlvView.prototype.isGenerateImageMap = function() {
return this.imageMap;
}
$ns$IlvView.prototype.updateImageMap = function() {
if (!this.imageMap) return;
this.imageMapPanel.setVisible(false);
this.waitPanel.setVisible(true);
var layers = [];
for (var i = 0;i < this.allLayers.length;i++)
if (this.visibleLayers[i])
layers[layers.length] = this.allLayers[i];
this.imageMapPanelPost.setURL(
this.createImageMapRequestURL(this.qbboxx, this.qbboxy,
this.qbboxw, this.qbboxh,
this.getWidth(), this.getHeight(),
layers));
}
$ns$IlvView.prototype.createImageMapRequestURL = function(qx, qy, qw, qh,
width, height,
layers) {
var request = this.requestURL + '?request=imagemap';
if ($ns$IlvBrowserInfo.instance.ie5up || document.getElementById) {
request += "&parent=true";
}
var slayers = '';
for (var i = 0;i < layers.length;i++)
if (i == 0)
slayers = layers[i];
else
slayers += ',' + layers[i];
request += '&layer=' + escape(slayers);
request += '&bbox=' + escape(qx + ',' + qy + ',' + qw + ',' + qh);
request += '&format='+this.format;
request += '&width=' + width;
request += '&height=' + height;
if (this.imgbgcolor)
request += '&bgcolor=0x' + this.imgbgcolor;
request += '&again=' + this.againString();
request += '&onload=' +  escape("'"+this.toString()+"'");
request += this.getAdditionalParameters();
if (this.emptyImagePath == null) {
var tmp = new Image();
tmp.src = $ns$IlvFrameworkConstants.basePath + 'empty.gif';
this.emptyImagePath = tmp.src;
}
request += '&image=' + escape(this.emptyImagePath);
return request;
}
$ns$IlvView.imageMapUpdated = function(viewName) {
var view = $ns$IlvView.instances[viewName];
if ($ns$IlvBrowserInfo.instance.ie5up || document.getElementById){
var doc = view.imageMapPanelPost.getContext().document;
view.imageMapPanel.setContent(doc.body.innerHTML);
}
if (view.imageMapVisible)
view.imageMapPanel.setVisible(true);
view.waitPanel.setVisible(false);
}
$ns$IlvView.prototype.imageMapDown = function (viewName) {
var view = $ns$IlvView.instances[viewName];
this._view = view;
return view._mouseDown();
}
$ns$IlvView.prototype.showImageMap = function() {
this.imageMapVisible = true;
if (this.imageMapPanel)
this.imageMapPanel.setVisible(true);
}
$ns$IlvView.prototype.hideImageMap = function() {
this.imageMapVisible = false;
if (this.imageMapPanel)
this.imageMapPanel.setVisible(false);
}
$ns$IlvView.prototype.addCapabilitiesOnLoadListener = function(listener) {
this.capabilitiesListeners.addListener(listener);
}
$ns$IlvView.prototype.removeCapabilitiesOnLoadListener = function(listener) {
this.capabilitiesListeners.removeListener(listener);
}
$ns$IlvView.prototype.addBeforeImageOnLoadListener = function(listener) {
this.beforeSwapListeners.addListener(listener);
}
$ns$IlvView.prototype.removeBeforeImageOnLoadListener = function(listener) {
this.beforeSwapListeners.removeListener(listener);
}
$ns$IlvView.prototype.addImageOnLoadListener = function(listener) {
this.updateListeners.addListener(listener);
}
$ns$IlvView.prototype.removeImageOnLoadListener = function(listener) {
this.updateListeners.removeListener(listener);
}
$ns$IlvView.prototype.addTimeoutErrorListener = function(listener) {
this.timeOutListeners.addListener(listener);
}
$ns$IlvView.prototype.removeTimeoutErrorListener = function(listener) {
this.timeOutListeners.removeListener(listener);
}
$ns$IlvView.prototype.addErrorListener = function(listener) {
this.errorListeners.addListener(listener);
}
$ns$IlvView.prototype.removeErrorListener = function(listener) {
this.errorListeners.removeListener(listener);
}
$ns$IlvView.prototype.startErrorTimer = function() {
this.stopErrorTimer();
this.errorInterval =
window.setTimeout('$ns$IlvView.onTimeoutError("' +
this.toString() + '")',
this.getTimeoutErrorInterval()*1000);
}
$ns$IlvView.prototype.stopErrorTimer = function() {
var inter = this.errorInterval;
this.errorInterval = null;
if (inter)
clearTimeout(inter);
}
$ns$IlvView.onTimeoutError = function(name) {
var view = $ns$IlvView.instances[name];
if (view)
view.timeoutError();
}
$ns$IlvView.prototype.timeoutError = function() {
this.error = true;
this.imagePanel.setVisible(false);
this.waitPanel.setContent(this.errorMessage);
this.waitPanel.setVisible(true);
this.timeOutListeners.notify(this.view);
}
$ns$IlvView.prototype.doRefresh = function(name) {
var view = $ns$IlvView.instances[name];
if (view != null) {
if (view.autoUpdateCapabilities)
view.updateAll(false, true);
else
view.updateImage();
}
}
$ns$IlvView.prototype.createCapabilitiesRequestURL = function() {
var request = this.requestURL + '?request=capabilities&format=html';
request += '&width=' + this.getWidth();
request += '&height=' + this.getHeight();
request += this.getAdditionalParameters();
request += '&again=' + this.againString();
return request;
}
$ns$IlvView.prototype.readAdditionalCapabilities = function(context) {
}
$ns$IlvView.prototype.getCapabilities = function(reload, showAll,
keepLayerVisibility) {
var request = this.createCapabilitiesRequestURL();
if (($ns$IlvBrowserInfo.instance.ie5up || document.getElementById) && !$ns$IlvBrowserInfo.instance.opera) {
request += "&parent=true";
}
var onload = "'" + this.toString() + "'," +
(reload?'true':'false') + ',' +
(showAll?'true':'false')+ ',' +
(keepLayerVisibility?'true':'false');
request += '&onload=' + escape(onload);
this.capabilitiesPanel.setURL(request);
this.startErrorTimer();
}
$ns$IlvView.endCapabilitiesLoaded = function(viewName, reload,
showAll,
keepLayerVisibility) {
var view = $ns$IlvView.instances[viewName];
view.stopErrorTimer();
var context = view.capabilitiesPanel.getContext();
view.minx = context.minx;
view.maxx = context.maxx;
view.miny = context.miny;
view.maxy = context.maxy;
view.readMaxZoomLevel(context);
view.readZoomLevels(context);
var i;
var oldLayers = view.allLayers;
var oldVisibility = view.visibleLayers;
view.allLayers = [];
view.visibleLayers = [];
view.overviewLayers = [];
for (i = 0;i < context.themes.length;i++) {
view.allLayers[i] = context.themes[i];
view.visibleLayers[i] = true;
view.overviewLayers[i] = context.overviewthemes[i];
}
view.readAdditionalCapabilities(context);
if ($ns$IlvBrowserInfo.instance.ie5up)
view.capabilitiesPanel.setURL($ns$IlvFrameworkConstants.basePath+'empty.gif');
view.capabilitiesLoaded = true;
if (reload) {
if (getCookie(view.cookieName + 'url') || !view.isStateInCookie()) {
view.capabilitiesListeners.notify(view);
if (getCookie(view.cookieName + 'url')) {
view.initFromCookie();
view.recenter();
view.updateImage();
} else
view.restoreState(view);
} else {
view.capabilitiesListeners.notify(view);
view.showAll();
}
} else {
view.capabilitiesListeners.notify(view);
if (keepLayerVisibility && oldLayers != null)
for (i = 0;i < oldLayers.length;i++)
if (!oldVisibility[i])
view.setLayerVisible(oldLayers[i], false, false);
if (showAll)
view.showAll();
else {
view.recenter();
view.updateImage();
}
}
}
$ns$IlvView.prototype.getCurrentZoomLevel = function() {
var mBBox = this.getManagerBBox();
var vBBox = this.getViewBBox();
var a = mBBox.width/vBBox.width;
var b = mBBox.height/vBBox.height;
return a > b? a: b;
}
$ns$IlvView.prototype.readMaxZoomLevel = function(context) {
this.maxZoom = context.maxZoom;
}
$ns$IlvView.prototype.readZoomLevels = function(context) {
this.zoomLevels = context.zoomLevels;
if (this.zoomLevels) {
this.maxZoom = this.zoomLevels[this.zoomLevels.length-1];
}
}
$ns$IlvView.prototype.initFromUrl = function(url) {
var view = this;
var bbox = this.parseValue(url, 'bbox');
var s = 0;
var e = bbox.indexOf(',', s);
view.qbboxx = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.indexOf(',', s);
view.qbboxy = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.indexOf(',', s);
view.qbboxw = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.length;
view.qbboxh = parseFloat(bbox.substring(s, e));
for (var i = 0;i < view.allLayers.length;i++)
view.visibleLayers[i] = false;
var layers = unescape(this.parseValue(url, 'layer'));
var layer;
var s = 0;
var e = 0;
var stop = false;
while (true) {
e = layers.indexOf(',', s);
if (e == -1) {
e = layers.length;
stop = true;
}
layer = layers.substring(s, e);
for (var i = 0;i < view.allLayers.length;i++)
if (view.allLayers[i] == layer)
view.visibleLayers[i] = true;
if (stop) break;
s = e + 1;
}
}
$ns$IlvView.prototype.initFromCookie = function() {
var view = this;
var url = getCookie(view.cookieName + 'url');
view.initFromUrl(url);
}
$ns$IlvView.prototype.parseValue = function(str, search) {
var s = str.indexOf(search, 0);
if (s == -1) return -1;
var e = str.indexOf('&', s + 1);
if (e == -1) e = str.length;
return str.substring(s + search.length + 1, e);
}
$ns$IlvView.prototype.getRequest = function() {
if (this.allLayers){
var layers = [];
for (var i = 0;i < this.allLayers.length;i++)
if (this.visibleLayers[i])
layers[layers.length] = this.allLayers[i];
return this.createRequestURL(this.qbboxx, this.qbboxy,
this.qbboxw, this.qbboxh,
this.getWidth(), this.getHeight(),
layers);
} else
return '';
}
$ns$IlvView.prototype.setImageBackgroundColor = function(color) {
this.imgbgcolor = color;
}
$ns$IlvView.prototype.getImageBackgroundColor = function() {
return this.imgbgcolor;
}
$ns$IlvView.prototype.createRequestURL = function(qx, qy, qw, qh, width, height,
layers) {
var request = this.requestURL + '?request=image';
var slayers = '';
for (var i = 0;i < layers.length;i++)
if (i == 0)
slayers = layers[i];
else
slayers += ',' + layers[i];
request += '&layer=' + escape(slayers);
request += '&bbox=' + escape(qx + ',' +  qy + ',' + qw + ',' + qh);
request += '&format='+this.format;
request += '&width=' + width;
request += '&height=' + height;
if (this.imgbgcolor)
request += '&bgcolor=0x' + this.imgbgcolor;
request += this.getAdditionalParameters();
request += '&again=' + this.againString();
return request;
}
$ns$IlvView.prototype.againString = function() {
var date = new Date();
var str = date.toUTCString();
str = str + ' ' + date.getMilliseconds();
return escape(str);
}
$ns$IlvView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
if (this._resized)
this.imagePanel.setVisible(false);
this.imagePanel.setBounds(left, top, width, height);
if (this.inHTML) {
this.waitPanel.setBounds(left, top, width, height);
this.imageMapPanel.setBounds(left, top, width, height);
this.waitPanel.setContent(this.getWaitPanelHTML());
this.recenter();
if (this._resized)
this.updateImage();
}
}
$ns$IlvView.prototype.childrenToHTML = function() {
this.imagePanel.setVisible(false);
this.imagePanel.toHTML();
this.waitPanel = new $ns$IlvHTMLPanel(this.getWaitPanelHTML());
this.waitPanel.setZIndex(5);
this.waitPanel.setBounds(this.getLeft(), this.getTop(),
this.getWidth(), this.getHeight());
this.waitPanel.setVisible(true);
this.rectPanel = new $ns$IlvRectangle();
this.capabilitiesPanel = new $ns$IlvURLPanel(0, 0, 0, 0);
this.superInvoke("childrenToHTML");
this.imageMapPanelPost = new $ns$IlvURLPanel(0,0,0,0);
this.imageMapPanel = new $ns$IlvHTMLPanel('');
this.imageMapPanel.setBounds(this.getLeft(), this.getTop(),
this.getWidth(), this.getHeight());
this.imageMapPanel.setZIndex(5);
}
$ns$IlvView.prototype.getWaitPanelHTML = function () {
return '<table width=' + this.getWidth() +
' height=' + this.getHeight() +
'><tr><td style="text-align:center" align="center" valign="middle">' +
'<img src="' + this.waitingImage +
'" galleryimg="false"></tr></td></table>';
}
$ns$IlvView.prototype.mouseMove = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseMove)
return this.interactor.mouseMove(e);
else if (this.interactor.onmousemove)
return this.interactor.onmousemove(e);
}
return true;
}
$ns$IlvView.prototype.mouseDrag = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseDrag)
return this.interactor.mouseDrag(e);
else if (this.interactor.onmousemove)
return this.interactor.onmousemove(e);
}
return true;
}
$ns$IlvView.prototype.keyPress = function(e) {
if (this.interactor != null) {
if (this.interactor.keyPress)
return this.interactor.keyPress(e);
else if (this.interactor.onkeypress)
return this.interactor.onkeypress(e);
}
return true;
}
$ns$IlvView.prototype.keyUp = function(e) {
if (this.interactor != null) {
if (this.interactor.keyUp)
return this.interactor.keyUp(e);
else if (this.interactor.onkeyup)
return this.interactor.onkeyup(e);
}
return true;
}
$ns$IlvView.prototype.keyDown = function(e) {
if (this.interactor != null) {
if (this.interactor.keyDown)
return this.interactor.keyDown(e);
else if (this.interactor.onkeydown)
return this.interactor.onkeydown(e);
}
return true;
}
$ns$IlvView.prototype.mouseUp = function(e) {
var interactor = this.interactor;
var popupMenu = this.popupMenu;
if (popupMenu!=null && popupMenu.isPopupTrigger(e)) {
var modelId;
if (interactor != null)
modelId = interactor.getMenuModelId();
return popupMenu.displayPopupMenu(this, e, modelId);
}  else {
if (this.interactor != null) {
if (this.interactor.mouseUp)
return this.interactor.mouseUp(e);
else if (this.interactor.onmouseup)
return this.interactor.onmouseup(e);
}
}
return true;
}
$ns$IlvView.prototype.mouseDown = function(e) {
var interactor = this.interactor;
var popupMenu = this.popupMenu;
if (popupMenu!=null && popupMenu.isPopupTrigger(e)) {
this.eventPanel._dragging = false;
return true;
} else {
if (popupMenu != null) {
popupMenu.internalResetEvent();
popupMenu.hidePopupMenu();
}
if (this.capabilitiesLoaded) {
if (interactor != null) {
if (interactor.mouseDown)
return interactor.mouseDown(e);
else if (interactor.onmousedown)
return interactor.onmousedown(e);
}
}
}
return true;
}
$ns$IlvView.prototype.mouseOver = function(e) {
var interactor = this.interactor;
if (interactor != null) {
if (interactor.message) {
window.status = interactor.message;
if (this.initialized && this.infoPanel)
this.infoPanel.setContent(interactor.message);
}
if (interactor.mouseOver)
return interactor.mouseOver(e);
else if (interactor.onmouseover)
return interactor.onmouseover(e);
}
return true;
}
$ns$IlvView.prototype.mouseOut = function(e) {
var interactor = this.interactor;
if (interactor != null) {
window.status='';
if (this.initialized && this.infoPanel)
this.infoPanel.setContent('');
if (interactor.mouseOut)
return interactor.mouseOut(e);
else if (interactor.onmouseout)
return interactor.onmouseout(e);
}
return true;
}
$ns$IlvView.prototype.mouseWheel = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseWheel)
return this.interactor.mouseWheel(e);
else if (this.interactor.onmousewheel)
return this.interactor.onmousewheel(e);
}
return true;
}
$ns$IlvView.prototype.recenter = function() {
if (this.getHeight() ==0 || this.getWidth() ==0)
return;
var ratio = this.getWidth()/this.getHeight();
var a = (this.maxx - this.minx)/this.qbboxw;
var b = ((this.maxy - this.miny)/this.qbboxh);
var  zooml = a > b? a: b;
if (zooml > this.maxZoom) {
if (a > b) {
var d = this.qbboxw - (this.maxx - this.minx)/this.maxZoom;
this.qbboxw = (this.maxx - this.minx)/this.maxZoom;
this.qbboxx += d/2;
d = this.qbboxh - this.qbboxw/ratio;
this.qbboxh = this.qbboxw/ratio;
this.qbboxy += d/2;
} else {
var d = this.qbboxh - (this.maxy - this.miny)/this.maxZoom;
this.qbboxh = (this.maxy - this.miny)/this.maxZoom;
this.qbboxy += d/2;
d = this.qbboxw - this.qbboxh*ratio;
this.qbboxw = this.qbboxh*ratio;
this.qbboxx += d/2;
}
}
if (this.qbboxx < this.minx)
this.qbboxx = this.minx;
if (this.qbboxy <  this.miny)
this.qbboxy = this.miny;
if (this.qbboxw >  this.maxx - this.minx)
this.qbboxw = this.maxx - this.minx;
if (this.qbboxh >  this.maxy - this.miny)
this.qbboxh = this.maxy - this.miny;
if (this.qbboxx + this.qbboxw >  this.maxx)
this.qbboxx = this.maxx - this.qbboxw;
if (this.qbboxy + this.qbboxh >  this.maxy)
this.qbboxy = this.maxy - this.qbboxh;
if (this.qbboxw < this.qbboxh *ratio) {
var dif = this.qbboxw - this.qbboxh*ratio;
this.qbboxw = this.qbboxh*ratio;
this.qbboxx += dif/2;
} else {
var dif = this.qbboxh - this.qbboxw/ratio;
this.qbboxh = this.qbboxw/ratio;
this.qbboxy += dif/2;
}
}
$ns$IlvView.prototype.performAction = function(actionName, params) {
var buf = actionName + '(';
if (params != null)
buf += params.join(',')
buf += ')';
this.setAdditionalParameters('action', buf);
this.updateImage();
this.setAdditionalParameters('action', null);
}
$ns$IlvView.prototype.getAdditionalParameters = function() {
return $ns$IlvRequestParameters.getRequestParameters(this.additionalParams);
}
$ns$IlvView.prototype.setAdditionalParameters = function(key, value) {
$ns$IlvRequestParameters.setParameter(this.additionalParams, key, value);
}
$ns$IlvView.prototype.removeAdditionalParameter = function(key) {
$ns$IlvRequestParameters.removeParameter(this.additionalParams, key);
}
$ns$IlvView.prototype.getRectangle = function() {
return this.rectPanel;
}
$ns$IlvView.prototype.getZoomLevels = function() {
return this.zoomLevels;
}
$ns$IlvView.prototype.dispose = function() {
this.superInvoke("dispose");
if(this.isDeletingCookieOnDispose())
deleteCookie(this.cookieName + 'url');
}
