/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvZoomInteractor() {
this.superConstructor();
var inter = this;
this.addRectangleDraggedListener(function(event) { inter.onEndDrag(event);});
this.setMessage("Select an area to zoom in or click to recenter");
}
$ns$IlvZoomInteractor.prototype = new $ns$IlvDragRectangleInteractor;
$ns$IlvZoomInteractor.prototype.setClassName("$ns$IlvZoomInteractor");
$ns$IlvZoomInteractor.prototype.onEndDrag = function(event) {
var x = event.left;
var y = event.top;
var w = event.width;
var h = event.height;
var bbox = this.view.getViewBBox();
var width = this.view.getWidth();
var height = this.view.getHeight();
var s1 =  bbox.width/width;
var s2 =  bbox.height/height;
x = bbox.left + x*s1;
y = bbox.top + y*s2;
if (event.width >= 3 && event.height >= 3) {
h = h*s2;
var ratio = this.getXYRatio();
if (ratio != 0) {
w = h*ratio;
} else {
w = w*s1;
}
this.view.setViewBBox(x, y, w, h, true);
} else {
this.view.centerAt(x,y);
}
}
$ns$IlvZoomInteractor.prototype.getXYRatio = function() {
if (this.view.height != 0)
return this.view.getWidth()/this.view.getHeight();
else return 0;
}
$ns$IlvZoomInteractor.prototype.mouseWheel = function(e) {
if (e.wheelDelta > 0) {
this.view.zoomIn();
} else {
this.view.zoomOut();
}
}
