/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvZoomTool(left, top, width, height, nbbuttons, view, plusminus) {
if (!window.$ns$IlvEmptyView)
alert("$ns$IlvZoomTool requires $ns$IlvEmptyView");
if (!window.$ns$IlvButton)
alert("$ns$IlvZoomTool requires $ns$IlvButton");
this.infoPanel = null;
this.superConstructor(left, top, width, height);
this.acc = 1;
this.orientation = $ns$IlvZoomTool.prototype.Horizontal;
this.nbbuttons = nbbuttons;
this.zoomLevels = new Array(this.nbbuttons);
this.buttons = null;
this.plusminus = plusminus;
this.buttonSize = $ns$IlvZoomTool.buttonSize;
$ns$IlvZoomTool.instances[this.toString()] = this;
this.setViewInternal(view);
}
$ns$IlvZoomTool.prototype = new $ns$IlvEmptyView;
$ns$IlvZoomTool.prototype.setClassName("$ns$IlvZoomTool");
$ns$IlvZoomTool.buttonSize = 16;
$ns$IlvZoomTool.instances = new Array();
$ns$IlvZoomTool.prototype.Vertical = 'Vertical';
$ns$IlvZoomTool.prototype.Horizontal = 'Horizontal';
$ns$IlvZoomTool.prototype.upImage = $ns$IlvFrameworkConstants.frameworkPath + 'top.gif';
$ns$IlvZoomTool.prototype.rolloverUpImage = $ns$IlvFrameworkConstants.frameworkPath + 'toph.gif';
$ns$IlvZoomTool.prototype.downImage = $ns$IlvFrameworkConstants.frameworkPath + 'bottom.gif';
$ns$IlvZoomTool.prototype.rolloverDownImage = $ns$IlvFrameworkConstants.frameworkPath + 'bottomh.gif';
$ns$IlvZoomTool.prototype.rightImage = $ns$IlvFrameworkConstants.frameworkPath + 'right.gif';
$ns$IlvZoomTool.prototype.rolloverRightImage = $ns$IlvFrameworkConstants.frameworkPath + 'righth.gif';
$ns$IlvZoomTool.prototype.leftImage = $ns$IlvFrameworkConstants.frameworkPath + 'left.gif';
$ns$IlvZoomTool.prototype.rolloverLeftImage = $ns$IlvFrameworkConstants.frameworkPath + 'lefth.gif';
$ns$IlvZoomTool.prototype.currentImage = $ns$IlvFrameworkConstants.frameworkPath + 'zoom.gif';
$ns$IlvZoomTool.prototype.rolloverCurrentImage = $ns$IlvFrameworkConstants.frameworkPath + 'zoomh.gif';
$ns$IlvZoomTool.prototype.plusImage = $ns$IlvFrameworkConstants.frameworkPath + 'plus.gif';
$ns$IlvZoomTool.prototype.rolloverPlusImage = $ns$IlvFrameworkConstants.frameworkPath + 'plush.gif';
$ns$IlvZoomTool.prototype.minusImage = $ns$IlvFrameworkConstants.frameworkPath + 'minus.gif';
$ns$IlvZoomTool.prototype.rolloverMinusImage = $ns$IlvFrameworkConstants.frameworkPath + 'minush.gif';
$ns$IlvZoomTool.prototype.setViewInternal = function(view) {
if (view) {
this.view = view;
var tool = this;
view.addCapabilitiesOnLoadListener(
function(view) {
tool.resetZoomButton();
}
);
view.addImageOnLoadListener(
function(view) {
tool.resetCurrentZoom();
}
);
}
}
$ns$IlvZoomTool.prototype.removeHTML = function() {
if (this.buttons)
for (i = 0; i < this.nbbuttons; i++)
this.buttons[i].removeHTML();
}
$ns$IlvZoomTool.prototype.updateVisibility = function() {
if (this.buttons)
for (i = 0; i < this.nbbuttons; i++)
this.buttons[i].updateVisibility();
}
$ns$IlvZoomTool.prototype.getView = function() {
return this.view;
}
$ns$IlvZoomTool.prototype.setOrientation = function(orientation) {
this.orientation = orientation;
var bounds = this.getBounds();
this.setBounds(bounds.left, bounds.top, bounds.width, bounds.height);
this.resetCurrentZoom();
}
$ns$IlvZoomTool.prototype.getOrientation = function() {
return this.orientation;
}
$ns$IlvZoomTool.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
var horizontal = (this.orientation == this.Horizontal);
var x;
var y;
var tb = this.topButton;
var bb = this.bottomButton;
var size = this.buttonSize;
var nb = this.nbbuttons;
if(tb)
nb = nb + 1;
if(bb)
nb = nb + 1;
if (!horizontal) {
x = this.left - size/2;
y = this.top + (this.height/nb)/2 - this.buttonSize/2;
} else {
x = this.left + (this.width/nb)/2 - this.buttonSize/2;
y = this.top - size/2;
}
var dy = this.height/nb;
var dx = this.width/nb;
if(tb) {
tb.setLocation(x - this.buttonSize / 2, y);
y += dy;
}
if (this.buttons != null) {
for (i = 0; i< this.nbbuttons; i++) {
this.buttons[i].setLocation(x, y);
if (!horizontal)
y += dy;
else
x += dx;
}
}
if(bb)
bb.setLocation(x - this.buttonSize / 2, y);
}
$ns$IlvZoomTool.prototype.childrenToHTML = function() {
this.superInvoke("childrenToHTML");
var horizontal = (this.orientation == this.Horizontal);
var x, y;
var image, rollover;
var size = this.buttonSize;
var nb = this.nbbuttons;
if (this.plusminus) {
nb = nb + 1;
nb = nb + 1;
}
if (!horizontal) {
x = this.left - size/2;
y = this.top + (this.height/nb)/2 - size/2;
image = this.upImage;
rollover = this.rolloverUpImage;
} else {
y = this.top - size/2;
x = this.left + (this.width/nb)/2 - size/2;
image = this.rightImage;
rollover = this.rolloverRightImage;
}
var dx = this.width/nb;
var dy = this.height/nb;
if (this.plusminus) {
var top = new $ns$IlvButton(x, y, size, size, this.plusImage,
'$ns$IlvZoomTool.instances["' +
this.toString() +
'"].plus()');
top.setRolloverImage(this.rolloverPlusImage);
top.setMessage('Click to zoom');
top.setToolTipText('Click to zoom');
top.toHTML();
this.topButton = top;
if (!horizontal)
y += dy;
else
x += dx;
}
this.buttons = new Array(this.nbbuttons);
for (i = 0; i < this.nbbuttons; i++) {
this.buttons[i] = new $ns$IlvButton(x, y, size, size, image,
'$ns$IlvZoomTool.instances["' +
this.toString() +
'"].buttonClick('+ i +')');
this.buttons[i].setRolloverImage(rollover);
this.buttons[i].setMessage('Click to change zoom level');
this.buttons[i].setToolTipText('Click to change zoom level');
this.buttons[i].toHTML();
this.buttons[i].tool = this;
if (!horizontal)
y += dy;
else
x += dx;
}
if (this.plusminus) {
var bot = new $ns$IlvButton(x, y, size, size, this.minusImage,
'$ns$IlvZoomTool.instances["' +
this.toString() +
'"].minus()');
bot.setRolloverImage(this.rolloverMinusImage);
bot.setMessage('Click to unzoom');
bot.setToolTipText('Click to unzoom');
bot.toHTML();
this.bottomButton = bot;
}
}
$ns$IlvZoomTool.prototype.buttonClick = function(index) {
var view = this.view;
if (view.isCapabilitiesLoaded()) {
var bbox = view.getViewBBox();
var managerBBox = view.getManagerBBox();
var zoom = Math.max(managerBBox.width/bbox.width,
managerBBox.height/bbox.height);
if (this.zoomLevels && index < this.zoomLevels.length)
view.zoomBy(this.zoomLevels[index]/zoom);
}
}
$ns$IlvZoomTool.prototype.resetCurrentZoom = function() {
var view = this.view;
if (view == null || !view.isCapabilitiesLoaded())
return ;
var bbox = view.getViewBBox();
var managerBBox = view.getManagerBBox();
var zoom = Math.max(managerBBox.width/bbox.width,
managerBBox.height/bbox.height);
var best = 0;
var diff = 0;
for (var i = 0; i < this.nbbuttons; i++) {
if (i == 0 || (diff > Math.abs(this.zoomLevels[i] - zoom))) {
best = i;
diff = Math.abs(this.zoomLevels[i] - zoom);
}
}
var after, before, rolloverafter, rolloverbefore;
if (this.orientation == this.Vertical) {
after = this.downImage;
rolloverafter = this.rolloverDownImage;
before = this.upImage;
rolloverbefore = this.rolloverUpImage;
} else {
after = this.rightImage;
rolloverafter = this.rolloverRightImage;
before = this.leftImage;
rolloverbefore = this.rolloverLeftImage;
}
if (this.buttons != null) {
for (var i = 0; i < this.nbbuttons; i++) {
if (i < best) {
this.buttons[i].setImage(before);
this.buttons[i].setRolloverImage(rolloverbefore);
}
else if (i >best) {
this.buttons[i].setImage(after);
this.buttons[i].setRolloverImage(rolloverafter);
}
else {
this.buttons[i].setImage(this.currentImage);
this.buttons[i].setRolloverImage(this.rolloverCurrentImage);
}
}
}
}
$ns$IlvZoomTool.prototype.currentIndex = function() {
var view = this.view;
if (view == null || !view.isCapabilitiesLoaded())
return -1;
var bbox = view.getViewBBox();
var managerBBox = view.getManagerBBox();
var zoom = Math.max(managerBBox.width/bbox.width,
managerBBox.height/bbox.height);
var best = 0;
var diff = 0;
for (var i = 0; i < this.nbbuttons; i++) {
if (i == 0 || (diff > Math.abs(this.zoomLevels[i] - zoom))) {
best = i;
diff = Math.abs(this.zoomLevels[i] - zoom);
}
}
return best;
}
$ns$IlvZoomTool.prototype.plus = function(index) {
var i = this.currentIndex();
if(i < this.nbbuttons - 1)
this.buttonClick(i + 1);
}
$ns$IlvZoomTool.prototype.minus = function(index) {
var i = this.currentIndex();
if(i > 0)
this.buttonClick(i - 1);
}
$ns$IlvZoomTool.prototype.resetZoomButton = function() {
var view = this.view;
if (view == null || !view.capabilitiesLoaded)
return;
var zoomMax = view.getMaxZoomLevel();
var zooms = view.getZoomLevels();
if(zooms) {
this.zoomLevels = zooms;
} else {
var m = Math.pow(zoomMax, 1/this.acc);
for (var i = 0; i < this.nbbuttons; i++)
this.zoomLevels[i] = Math.pow(1+i*(m - 1)/(this.nbbuttons - 1), this.acc);
}
this.resetCurrentZoom();
}
$ns$IlvZoomTool.prototype.setMessagePanel = function(panel) {
var i;
for (i = 0 ; i < this.nbbuttons ; i++) {
this.buttons[i].setMessagePanel(panel);
}
this.infoPanel = panel;
}
$ns$IlvZoomTool.prototype.getMessagePanel = function() {
return this.infoPanel;
}
$ns$IlvZoomTool.prototype.setNonLinearFactor = function(a) {
this.acc = a;
this.resetZoomButton();
}
$ns$IlvZoomTool.prototype.getNonLinearFactor = function() {
return this.acc;
}
