/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.BinaryExpression;
import org.josql.internal.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LikeExpression
extends BinaryExpression {
    private boolean not;
    private boolean ignoreCase;
    private List pattern;

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void init(Query q) throws QueryParseException {
        super.init(q);
        if (this.right.hasFixedResult(q)) {
            Object r = null;
            try {
                r = this.right.getValue(null, q);
            }
            catch (Exception e) {
                throw new QueryParseException("Unable to get RHS value from: \"" + this.right + "\", expected to RHS to have fixed result.", e);
            }
            if (r == null) {
                return;
            }
            String rs = r.toString();
            if (this.ignoreCase) {
                rs = rs.toLowerCase();
            }
            char wc = q.getWildcardCharacter();
            this.pattern = Utilities.getLikePattern(rs, String.valueOf(wc));
        }
    }

    public void setIgnoreCase(boolean v) {
        this.ignoreCase = v;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean v) {
        this.not = v;
    }

    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        Object l = this.left.getValue(o, q);
        if (this.pattern != null) {
            return Utilities.matchLikePattern(this.pattern, l, this.not, this.ignoreCase);
        }
        Object r = this.right.getValue(o, q);
        if (l == null && r == null) {
            return !this.not;
        }
        if (l == null || r == null) {
            return this.not;
        }
        String rs = r.toString();
        if (this.ignoreCase) {
            rs = rs.toLowerCase();
        }
        char wc = q.getWildcardCharacter();
        List pat = Utilities.getLikePattern(rs, String.valueOf(wc));
        return Utilities.matchLikePattern(pat, l, this.not, this.ignoreCase);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.left.toString());
        if (this.isNot()) {
            buf.append(" NOT");
        }
        buf.append(" ");
        if (this.ignoreCase) {
            buf.append("$");
        }
        buf.append("LIKE ");
        buf.append(this.right);
        if (this.isBracketed()) {
            buf.insert(0, "(");
            buf.append(")");
        }
        return buf.toString();
    }

    private final /* synthetic */ void this() {
        this.not = false;
        this.ignoreCase = false;
        this.pattern = null;
    }

    public LikeExpression() {
        this.this();
    }
}

