/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;

public class SSLClientAxisEngineConfig
extends SimpleProvider {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$client$SSLClientAxisEngineConfig == null ? (class$org$apache$axis$client$SSLClientAxisEngineConfig = SSLClientAxisEngineConfig.class$("org.apache.axis.client.SSLClientAxisEngineConfig")) : class$org$apache$axis$client$SSLClientAxisEngineConfig).getName());
    protected static final String CLIENT_CONFIG_FILE = "client-config.wsdd";
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String protocol;
    private String algorithm;
    private String keyStore;
    private String keyStoreType;
    private String keyStorePassword;
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType;
    private Hashtable options;
    static /* synthetic */ Class class$org$apache$axis$client$SSLClientAxisEngineConfig;

    public SSLClientAxisEngineConfig() {
        this.loadOptions(CLIENT_CONFIG_FILE);
    }

    public SSLClientAxisEngineConfig(String configFile) {
        this.loadOptions(configFile);
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        super.configureEngine(engine);
        this.initializeAxisProperties();
        this.initializeGlobalOptions(engine);
        this.initializeTransport();
    }

    private void initializeAxisProperties() {
        log.debug((Object)"SSLClientAxisEngineConfig::AxisProperties::init");
        AxisProperties.setProperty("axis.socketSecureFactory", "org.apache.axis.components.net.CertificateSecureSocketFactory");
        AxisProperties.setProperty("https.proxyHost", this.proxyHost);
        AxisProperties.setProperty("https.proxyPort", this.proxyPort);
        AxisProperties.setProperty("https.proxyUser", this.proxyUser);
        AxisProperties.setProperty("https.proxyPassword", this.proxyPassword);
    }

    private void initializeGlobalOptions(AxisEngine engine) throws ConfigurationException {
        this.setGlobalOptions(this.getOptions());
        engine.refreshGlobalOptions();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Global options: " + this.getGlobalOptions()));
        }
    }

    private void initializeTransport() throws ConfigurationException {
        QName http = new QName(null, "http");
        Handler transport = this.getTransport(http);
        if (transport == null) {
            log.debug((Object)"SSLClientAxisEngineConfig::Transport::init");
            HTTPSender pivot = new HTTPSender();
            if (this.protocol != null) {
                pivot.setOption("protocol", this.protocol);
            }
            if (this.algorithm != null) {
                pivot.setOption("algorithm", this.algorithm);
            }
            if (this.keyStore != null) {
                pivot.setOption("clientauth", "true");
                pivot.setOption("keyStore", this.keyStore);
                if (this.keyStoreType != null) {
                    pivot.setOption("keyStoreType", this.keyStoreType);
                }
                if (this.keyStorePassword != null) {
                    pivot.setOption("keyStorePassword", this.keyStorePassword);
                }
            }
            if (this.trustStore != null) {
                pivot.setOption("trustStore", this.trustStore);
                if (this.trustStoreType != null) {
                    pivot.setOption("trustStoreType", this.trustStoreType);
                }
                if (this.trustStorePassword != null) {
                    pivot.setOption("trustStorePassword", this.trustStorePassword);
                }
            }
            transport = new SimpleTargetedChain(pivot);
            this.deployTransport(http, transport);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadOptions(String configFile) throws ExceptionInInitializerError {
        InputStream input;
        block10: {
            log.info((Object)("Enter::SSLClientAxisEngineConfig::init::" + configFile));
            input = null;
            try {
                input = new FileInputStream(configFile);
            }
            catch (Exception e) {
                input = ClassUtils.getResourceAsStream(this.getClass(), configFile, true);
            }
            if (input == null) {
                throw new ConfigurationException(Messages.getMessage("noConfigFile"));
            }
            WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument(input));
            if (doc.getDeployment().getGlobalConfiguration() == null) break block10;
            this.options = doc.getDeployment().getGlobalOptions();
        }
        Object var5_6 = null;
        if (input == null) return;
        try {
            input.close();
            return;
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return;
        {
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            throw throwable;
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setDisablePrettyXML(Boolean disablePrettyXML) {
        this.getOptions().put("disablePrettyXML", disablePrettyXML);
    }

    public void setEnableNamespacePrefixOptimization(Boolean enableNamespacePrefixOptimization) {
        this.getOptions().put("enableNamespacePrefixOptimization", enableNamespacePrefixOptimization);
    }

    public void setSendMultiRefs(Boolean sendMultiRefs) {
        this.getOptions().put("sendMultiRefs", sendMultiRefs);
    }

    public void setOption(String key, Object value) {
        this.getOptions().put(key, value);
    }

    public Hashtable getOptions() {
        if (this.options == null) {
            this.options = new Hashtable();
        }
        return this.options;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

