/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import subzero.lib.exceptions.SSHRuntimeException;
import subzero.lib.io.CopyFrom;
import subzero.lib.io.IFileEntry;
import subzero.lib.io.SFTPFileEntry;
import subzero.lib.io.SSHConnection;

public class CopyFromSFTP
extends CopyFrom {
    private final ChannelSftp m_sftp;
    private final SSHConnection m_ssh;

    public CopyFromSFTP(SSHConnection ssh, String from) {
        super(from);
        try {
            this.m_ssh = ssh;
            this.m_sftp = (ChannelSftp)ssh.openChannel("sftp");
            this.m_sftp.connect();
        }
        catch (JSchException e) {
            SSHRuntimeException re = new SSHRuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = this.getInputStream();
        try {
            byte[] buffer = new byte[16384];
            int numread = 0;
            while (0 <= (numread = in.read(buffer))) {
                baos.write(buffer, 0, numread);
            }
        }
        finally {
            in.close();
            baos.close();
        }
        return baos.toByteArray();
    }

    public int length() {
        return (int)this.getFileEntry().getLength();
    }

    public boolean supportStreaming() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(this.getFileEntry());
    }

    public InputStream getInputStream(IFileEntry child) throws IOException {
        try {
            return this.m_sftp.get(child.getSystemPath());
        }
        catch (SftpException e) {
            throw new IOException();
        }
    }

    public IFileEntry getFileEntry() {
        return new SFTPFileEntry(this.m_sftp, this, this.getFrom());
    }
}

