/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import jcifs.smb.SmbFile;
import subzero.lib.io.CopyFrom;
import subzero.lib.io.IFileEntry;
import subzero.lib.io.SmbFileEntry;

public class CopyFromSMB
extends CopyFrom {
    private SmbFile m_file;

    public CopyFromSMB(String smburl) {
        super(smburl);
        try {
            this.m_file = new SmbFile(this.getFrom());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        int length;
        if (this.length() == 0) {
            this.waitForData();
        }
        if ((length = this.length()) == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        InputStream in = this.getInputStream();
        try {
            byte[] buffer = new byte[16384];
            int numread = 0;
            while ((numread = in.read(buffer)) != -1) {
                baos.write(buffer, 0, numread);
            }
        }
        finally {
            in.close();
            baos.close();
        }
        byte[] bytes = baos.toByteArray();
        if (bytes.length == this.length()) {
            return bytes;
        }
        return this.getBytes();
    }

    public int length() {
        return this.m_file.getContentLength();
    }

    public boolean supportStreaming() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return this.m_file.getInputStream();
    }

    public InputStream getInputStream(IFileEntry child) throws IOException {
        return new SmbFile(this.m_file, child.getPath()).getInputStream();
    }

    public IFileEntry getFileEntry() {
        return new SmbFileEntry(this.m_file);
    }
}

