/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import subzero.lib.io.AbstractBufferingInputStream;
import subzero.lib.io.TelnetConnectionProtocolHandler;

public class TelnetInputStream
extends AbstractBufferingInputStream {
    private final TelnetConnectionProtocolHandler m_handler;
    private static int num = 0;
    private static byte[] arrByte = new byte[1024];

    public TelnetInputStream(TelnetConnectionProtocolHandler handler) {
        super(1024);
        this.m_handler = handler;
    }

    protected int getNextChunk(byte[] b) throws IOException {
        int n = 0;
        do {
            if ((n = this.m_handler.negotiate(b)) <= 0) continue;
            return n;
        } while (n == 0);
        while (n <= 0) {
            do {
                if ((n = this.m_handler.negotiate(b)) <= 0) continue;
                return n;
            } while (n == 0);
            n = this.m_handler.getInputStream().read(b);
            if (n < 0) {
                return n;
            }
            this.m_handler.inputfeed(b, n);
            n = this.m_handler.negotiate(b);
        }
        return n;
    }

    public synchronized int initNegociation(byte[] b, String host) throws IOException {
        int n = 0;
        do {
            if ((n = this.m_handler.negotiate(b)) <= 0) continue;
            return n;
        } while (n == 0);
        while (n <= 0) {
            do {
                if ((n = this.m_handler.negotiate(b)) <= 0) continue;
                return n;
            } while (n == 0);
            n = this.m_handler.getInputStream().read(b);
            if (n < 0) {
                return n;
            }
            this.m_handler.inputfeed(b, n);
            n = this.m_handler.negotiate(b);
        }
        return n;
    }

    protected void closeInternal() throws IOException {
        this.m_handler.close();
    }
}

