/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import subzero.lib.scep.ScepException;

public class KeyPairUtil {
    private static final Logger LOGGER = Logger.getLogger(KeyPairUtil.class);
    private static int keySize = 4;
    private static String fileDir = "";
    private static int genNum = 10;

    public static int getKeySize() {
        return keySize;
    }

    public static void setKeySize(int keySize) {
        KeyPairUtil.keySize = keySize;
    }

    public static String getFileDir() {
        return fileDir;
    }

    public static void setFileDir(String fileDir) {
        KeyPairUtil.fileDir = fileDir;
    }

    public static int getGenNum() {
        return genNum;
    }

    public static void setGenNum(int genNum) {
        KeyPairUtil.genNum = genNum;
    }

    public KeyPair genKeyPair() throws ScepException {
        KeyPairGenerator keyGen;
        Security.addProvider((Provider)new BouncyCastleProvider());
        int mKeySize = keySize * 1024;
        LOGGER.debug((Object)("generating key pair with size " + mKeySize + " ....."));
        try {
            keyGen = KeyPairGenerator.getInstance("RSA", BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ScepException("Internal Error, NoSuchAlgorithm exception during keypair generation", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new ScepException("Internal Error, NoSuchProvider exception during keypair generation", (Throwable)e);
        }
        SecureRandom sr = new SecureRandom();
        keyGen.initialize(mKeySize, sr);
        KeyPair keyPair = keyGen.generateKeyPair();
        LOGGER.debug((Object)"... done generating keypair");
        return keyPair;
    }

    public void writeKeyPairToFile(String mFilename, KeyPair keyPair) throws IOException {
        if (fileDir != "") {
            File createDir = new File(fileDir);
            if (!createDir.exists()) {
                createDir.mkdirs();
            }
            mFilename = fileDir + "/" + mFilename;
        }
        FileOutputStream fOut = new FileOutputStream(mFilename);
        PEMWriter pWrt = new PEMWriter((Writer)new OutputStreamWriter(fOut));
        pWrt.writeObject((Object)keyPair.getPrivate());
        pWrt.writeObject((Object)keyPair.getPublic());
        pWrt.close();
    }

    public KeyPair readPemFile(String mfilename) throws IOException {
        File keyFile = new File(mfilename);
        PEMParser pemParser = new PEMParser((Reader)new FileReader(keyFile));
        Object object = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(BouncyCastleProvider.PROVIDER_NAME);
        KeyPair keyPair = converter.getKeyPair((PEMKeyPair)object);
        return keyPair;
    }
}

