/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import subzero.lib.exceptions.IORuntimeException;
import subzero.lib.io.IOCommands;
import subzero.lib.io.IOConnection;
import subzero.lib.io.TimeoutInputStream;

public abstract class AbstractIOConnection
implements IOConnection {
    protected IOCommands m_returnChar = IOCommands.LF;

    public synchronized String readRemaining() {
        return this.readRemaining(-1);
    }

    public synchronized String readRemaining(int timeout) {
        InputStream in = this.getInputStream();
        if (in instanceof TimeoutInputStream) {
            ((TimeoutInputStream)in).setReadTimeout(timeout);
        }
        StringBuffer buf = new StringBuffer();
        try {
            int read;
            while ((read = in.read()) != -1) {
                buf.append((char)read);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return buf.toString();
    }

    public synchronized void skipRemaining() {
        this.skipRemaining(-1);
    }

    public synchronized void skipRemaining(int timeout) {
        InputStream in = this.getInputStream();
        if (in instanceof TimeoutInputStream) {
            ((TimeoutInputStream)in).setReadTimeout(timeout);
        }
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void setReturnCharacter(IOCommands rc) {
        this.m_returnChar = rc;
    }
}

