/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import subzero.lib.io.CopyTo;
import subzero.lib.io.FileEntryImpl;
import subzero.lib.io.ICopyTo;
import subzero.lib.io.IFileEntry;
import subzero.lib.util.FileUtils;

public class CopyToLocal
extends CopyTo {
    private File m_file;

    public CopyToLocal(String to) {
        super(to);
        this.m_file = new File(this.getTo());
    }

    public CopyToLocal(File to) {
        super(to.getAbsolutePath());
        this.m_file = to;
    }

    public Class getInterfaceClass() {
        return ICopyTo.class;
    }

    public boolean supportsStreaming() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(byte[] b, IFileEntry entry) throws IOException {
        OutputStream out = this.getOutputStream(entry, b.length);
        try {
            if (b != null) {
                out.write(b);
            }
        }
        finally {
            out.close();
        }
    }

    public OutputStream getOutputStream(IFileEntry child, long size) throws IOException {
        return new FileOutputStream(this.getFile(child));
    }

    public IFileEntry getFileEntry() {
        return new FileEntryImpl(this, this.m_file);
    }

    public boolean makeDirectory(IFileEntry child) throws IOException {
        File dir = this.getFile(child);
        if (dir.exists()) {
            return dir.isDirectory();
        }
        return dir.mkdirs();
    }

    public boolean setLastModified(IFileEntry child, long lastModified) throws IOException {
        File file = this.getFile(child);
        if (!file.exists()) {
            return false;
        }
        return file.setLastModified(lastModified);
    }

    private File getFile(IFileEntry entry) throws IOException {
        if (entry.getParent() instanceof ICopyTo) {
            return this.m_file;
        }
        if (entry.getParent() instanceof IFileEntry) {
            return new File(this.getFile((IFileEntry)entry.getParent()), entry.getName());
        }
        throw new IOException("Unexpected parent type [" + entry.getClass().getName());
    }

    public boolean deleteFile(int flag) throws IOException {
        return this.deleteFile(this.getFileEntry(), flag);
    }

    public boolean deleteFile(IFileEntry file, int flag) throws IOException {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            File f = new File(file.getSystemPath());
            try {
                return f.delete();
            }
            catch (SecurityException se) {
                throw new IOException("Could not delete the file " + f.getAbsolutePath() + File.separator + f.getName());
            }
        }
        if (file.isDirectory()) {
            File f = new File(file.getSystemPath());
            if (flag == 0) {
                try {
                    return f.delete();
                }
                catch (SecurityException se) {
                    throw new IOException("Could not delete the directory " + f.getAbsolutePath() + File.separator + f.getName());
                }
            }
            if (flag == 1) {
                return FileUtils.recursiveDelete(f);
            }
        }
        return false;
    }
}

