/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.SmbFile;
import subzero.lib.io.CopyTo;
import subzero.lib.io.IFileEntry;
import subzero.lib.io.SmbFileEntry;

public class CopyToSMB
extends CopyTo {
    private SmbFile m_file;

    public CopyToSMB(String smburl) {
        super(smburl);
        try {
            this.m_file = new SmbFile(this.getTo());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBytes(byte[] b, IFileEntry entry) throws IOException {
        OutputStream out = this.getOutputStream(entry, b.length);
        out.write(b);
        out.close();
    }

    public boolean supportsStreaming() {
        return true;
    }

    public OutputStream getOutputStream(IFileEntry child, long length) throws IOException {
        SmbFileEntry smbfileentry = (SmbFileEntry)child;
        SmbFile smbfile = smbfileentry.getRealFile();
        if (smbfile.exists()) {
            smbfile.setReadWrite();
        }
        return smbfile.getOutputStream();
    }

    public IFileEntry getFileEntry() {
        return new SmbFileEntry(this.m_file);
    }

    public boolean makeDirectory(IFileEntry child) throws IOException {
        ((SmbFileEntry)child).getRealFile().mkdirs();
        return true;
    }

    public boolean setLastModified(IFileEntry child, long lastModified) throws IOException {
        new SmbFile(this.m_file, child.getPath()).setLastModified(lastModified);
        return true;
    }

    public boolean deleteFile(int flag) throws IOException {
        this.m_file.delete();
        return true;
    }

    public boolean deleteFile(IFileEntry file, int flag) throws IOException {
        new SmbFile(this.m_file, file.getPath()).delete();
        return true;
    }
}

