/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public class TimeoutOutputStream
extends OutputStream {
    private static final Timer _timer = new Timer(true);
    private final OutputStream _output;
    private volatile long _timeout;
    private final Timeout _timeoutobj;
    private volatile boolean _ioInterrupted = false;
    private volatile long m_stopTime = -1L;

    public TimeoutOutputStream(OutputStream output, long initialTimeout) {
        this._output = output;
        this.setWriteTimeout(initialTimeout);
        this._timeoutobj = new Timeout(this);
        _timer.scheduleAtFixedRate((TimerTask)this._timeoutobj, 50L, 50L);
    }

    public long getWriteTimeout() {
        return this._timeout;
    }

    public void setWriteTimeout(long timeout) {
        if (timeout <= 0L) {
            this._timeout = -1L;
            return;
        }
        this._timeout = timeout;
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this._ioInterrupted = false;
        try {
            this.m_stopTime = this.calculateStopTime();
            try {
                this._output.write(b, off, len);
            }
            finally {
                this.m_stopTime = -1L;
            }
        }
        catch (IOException ioe) {
            if (this._ioInterrupted) {
                throw new InterruptedIOException(ioe.getMessage());
            }
            throw ioe;
        }
        finally {
            if (this._ioInterrupted) {
                throw new InterruptedIOException("The write operation did not complete within the " + this._timeout + "ms timeout");
            }
        }
    }

    public synchronized void write(int b) throws IOException {
        this._ioInterrupted = false;
        try {
            this.m_stopTime = this.calculateStopTime();
            try {
                this._output.write(b);
            }
            finally {
                this.m_stopTime = -1L;
            }
        }
        catch (IOException ioe) {
            if (this._ioInterrupted) {
                throw new InterruptedIOException(ioe.getMessage());
            }
            throw ioe;
        }
        finally {
            if (this._ioInterrupted) {
                throw new InterruptedIOException("The write operation did not complete within the " + this._timeout + "ms timeout");
            }
        }
    }

    public void flush() throws IOException {
        this._output.flush();
    }

    private synchronized long calculateStopTime() {
        long writeTimeout = this.getWriteTimeout();
        if (writeTimeout < 0L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long stopTime = now + writeTimeout;
        if (stopTime <= now) {
            return Long.MAX_VALUE;
        }
        return stopTime;
    }

    private static class Timeout
    extends TimerTask {
        private WeakReference<TimeoutOutputStream> m_tos;

        public Timeout(TimeoutOutputStream tos) {
            this.m_tos = new WeakReference<TimeoutOutputStream>(tos);
        }

        public void run() {
            TimeoutOutputStream tos = (TimeoutOutputStream)this.m_tos.get();
            if (tos == null) {
                this.cancel();
                return;
            }
            long stoptime = tos.m_stopTime;
            if (stoptime == -1L || System.currentTimeMillis() < stoptime) {
                return;
            }
            try {
                tos._ioInterrupted = true;
                tos._output.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

