/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.tacacsclient.util;

public class BitArray {
    public static final int INT_SIZE = 32;
    public static final int BYTE_SIZE = 8;
    private int[] bitList;
    private int maxBits = 0;
    private static final int BYTES_PER_INT = 4;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] bin = new char[]{'0', '1'};

    public BitArray(int length) {
        this.maxBits = length;
        this.bitList = new int[(this.maxBits + 32 - 1) / 32];
    }

    public BitArray(byte[] b) {
        this.init(b, b.length);
    }

    public BitArray(byte[] b, int maxBytes) {
        this.init(b, maxBytes);
    }

    private void init(byte[] b, int maxBytes) {
        this.maxBits = 8 * maxBytes;
        this.bitList = new int[(this.maxBits + 32 - 1) / 32];
        int bitListLen = this.bitList.length;
        byte[] tb = new byte[this.bitList.length * 4];
        System.arraycopy(b, 0, tb, 0, b.length);
        int bPos = 0;
        for (int i = 0; i < bitListLen; ++i) {
            this.bitList[i] = tb[bPos++] << 24 | (tb[bPos++] & 0xFF) << 16 | (tb[bPos++] & 0xFF) << 8 | tb[bPos++] & 0xFF;
        }
    }

    public void set(int n) {
        if (n >= this.maxBits) {
            return;
        }
        int shift = 32 - n % 32 - 1;
        int n2 = n / 32;
        this.bitList[n2] = this.bitList[n2] | 1 << shift;
    }

    public void set(int n, boolean v) {
        if (v) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public boolean get(int n) {
        if (n >= this.maxBits) {
            return false;
        }
        int shift = 32 - n % 32 - 1;
        return (this.bitList[n / 32] & 1 << shift) != 0;
    }

    public int cardinality() {
        int counter = 0;
        for (int i = 0; i < this.maxBits; ++i) {
            if (!this.get(i)) continue;
            ++counter;
        }
        return counter;
    }

    public boolean xor() {
        if (this.maxBits > 1) {
            boolean result = this.get(0);
            for (int i = 1; i < this.maxBits; ++i) {
                result ^= this.get(i);
            }
            return result;
        }
        return false;
    }

    public int extractInt(int start, int length) {
        int end = start + length;
        if (end > this.maxBits) {
            end = this.maxBits;
        }
        if (length > 32) {
            length = 32;
        }
        BitArray ex = new BitArray(32);
        int oi = 32 - length;
        for (int i = start; i < end; ++i) {
            ex.set(oi++, this.get(i));
        }
        return BitArray.concoctInt(ex.toByteArray(), 0);
    }

    public long extractLong(int start, int length) {
        int end = start + length;
        if (end > this.maxBits) {
            end = this.maxBits;
        }
        if (length > 64) {
            length = 64;
        }
        BitArray ex = new BitArray(64);
        int oi = 64 - length;
        for (int i = start; i < end; ++i) {
            ex.set(oi++, this.get(i));
        }
        return BitArray.concoctLong(ex.toByteArray());
    }

    public byte[] extractBytes(int start, int length) {
        int end = start + length;
        if (end > this.maxBits) {
            end = this.maxBits;
        }
        if (length > end - start) {
            length = end - start;
        }
        BitArray ex = new BitArray(length);
        int oi = this.maxBits - length;
        for (int i = start; i < end; ++i) {
            ex.set(oi++, this.get(i));
        }
        return ex.toByteArray();
    }

    public void clear(int n) {
        if (n >= this.maxBits) {
            return;
        }
        int shift = 32 - n % 32 - 1;
        int n2 = n / 32;
        this.bitList[n2] = this.bitList[n2] & ~(1 << shift);
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex > this.maxBits) {
            return;
        }
        if (fromIndex > toIndex) {
            return;
        }
        if (toIndex > this.maxBits) {
            toIndex = this.maxBits + 1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.clear(i);
        }
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    public void clear() {
        int blen = this.bitList.length;
        for (int i = 0; i < blen; ++i) {
            this.bitList[i] = 0;
        }
    }

    public void reset() {
        for (int i = 0; i < this.bitList.length; ++i) {
            this.bitList[0] = 0;
        }
    }

    public byte[] toByteArray() {
        byte[] byteList = new byte[this.bitList.length * 4];
        int bposn = 0;
        for (int i = 0; i < this.bitList.length; ++i) {
            int x = this.bitList[i];
            byteList[bposn++] = (byte)(x >>> 24);
            byteList[bposn++] = (byte)(x >>> 16);
            byteList[bposn++] = (byte)(x >>> 8);
            byteList[bposn++] = (byte)x;
        }
        byte[] tb = new byte[this.maxBits / 8];
        System.arraycopy(byteList, 0, tb, 0, tb.length);
        return tb;
    }

    public String toHexString() {
        return this.toHexString(this.toByteArray());
    }

    private String toHexString(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int buflen = buf.length;
        for (int i = 0; i < buflen; ++i) {
            sb.append(hex[buf[i] >>> 4 & 0xF]).append(hex[buf[i] & 0xF]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        byte[] byteList = this.toByteArray();
        for (int i = 0; i < byteList.length; ++i) {
            sb.append(bin[byteList[i] >>> 7 & 1]);
            sb.append(bin[byteList[i] >>> 6 & 1]);
            sb.append(bin[byteList[i] >>> 5 & 1]);
            sb.append(bin[byteList[i] >>> 4 & 1]);
            sb.append(bin[byteList[i] >>> 3 & 1]);
            sb.append(bin[byteList[i] >>> 2 & 1]);
            sb.append(bin[byteList[i] >>> 1 & 1]);
            sb.append(hex[byteList[i] & 1]);
        }
        return sb.toString();
    }

    public int getMaximumBits() {
        return this.maxBits;
    }

    public static void main(String[] a) {
        int i;
        byte[] b = new byte[5];
        BitArray bits = new BitArray(b);
        for (i = 0; i <= 41; ++i) {
            BitArray.test(bits, i);
        }
        b = new byte[2];
        bits = new BitArray(b, 4);
        for (i = 0; i <= 41; ++i) {
            BitArray.test(bits, i);
        }
    }

    private static void test(BitArray bits, int pos) {
        bits.set(pos);
        System.out.println(pos + " " + bits);
        System.out.println(pos + " " + bits.get(pos));
        bits.clear(pos);
        System.out.println(pos + " " + bits);
        System.out.println(pos + " " + bits.get(0));
        System.out.println();
    }

    public static int concoctInt(byte[] b, int start) {
        return b[start] << 24 | (b[start + 1] & 0xFF) << 16 | (b[start + 2] & 0xFF) << 8 | b[start + 3] & 0xFF;
    }

    private static long concoctLong(byte[] b) {
        long u = (long)BitArray.concoctInt(b, 0) & 0xFFFFFFFFL;
        long l = (long)BitArray.concoctInt(b, 4) & 0xFFFFFFFFL;
        return u << 32 | l;
    }

    public int nextClearBit(int posn) {
        int i;
        for (i = posn; i < this.maxBits && this.get(i); ++i) {
        }
        return i;
    }

    public int length() {
        return this.maxBits;
    }
}

