/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.tacacsclient.util;

import subzero.lib.tacacsclient.util.Ctype;

public class ByteIterator {
    private byte[] array;
    private int current;
    private static final String Filler = "                        ";
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MAXCHAR = 256;
    private byte[] pat;
    private int patLen;
    private int partial;
    private int[] skip;
    private int[] d;

    public ByteIterator(byte[] d) {
        this.array = new byte[d.length];
        System.arraycopy(d, 0, this.array, 0, d.length);
        this.current = 0;
    }

    public ByteIterator(byte[] d, boolean newBuf) {
        if (newBuf) {
            this.array = new byte[d.length];
            System.arraycopy(d, 0, this.array, 0, d.length);
        } else {
            this.array = d;
        }
        this.current = 0;
    }

    public ByteIterator(byte[] d, int start, int length) {
        this.array = new byte[length];
        System.arraycopy(d, start, this.array, 0, length);
        this.current = 0;
    }

    public int available() {
        return this.array.length - this.current;
    }

    public byte[] getBuffer() {
        return this.array;
    }

    public byte[] getBuffer(int start, int length) {
        byte[] cp = new byte[length];
        if (start >= length || length == 0) {
            return cp;
        }
        int copyLength = this.array.length - start;
        if (length < copyLength) {
            copyLength = length;
        }
        System.arraycopy(this.array, start, cp, 0, copyLength);
        return cp;
    }

    public byte first() {
        this.current = 0;
        return this.array[0];
    }

    public byte last() {
        this.current = this.array.length - 1;
        return this.array[this.current];
    }

    public void setIndex(int posn) {
        this.current = posn;
    }

    public void move(int count) {
        this.current += count;
    }

    public int current() {
        return this.current;
    }

    public long nextLong() {
        return ByteIterator.concoctLong(this.array, this.current);
    }

    public void moveLong() {
        this.current += 8;
    }

    public int nextInt() {
        return ByteIterator.concoctInt(this.array, this.current);
    }

    public void moveInt() {
        this.current += 4;
    }

    public void move24() {
        this.current += 3;
    }

    public short nextShort() {
        return ByteIterator.concoctShort(this.array, this.current);
    }

    public int nextUnsignedShort() {
        return ByteIterator.concoctShort(this.array, this.current) & 0xFFFF;
    }

    public int next24() {
        return ByteIterator.concoct24(this.array, this.current);
    }

    public int nextUnsignedByte() {
        return this.array[this.current] & 0xFF;
    }

    public void moveShort() {
        this.current += 2;
    }

    public byte nextByte() {
        return this.array[this.current];
    }

    public void moveByte() {
        ++this.current;
    }

    public void setByte(byte i) {
        this.array[this.current] = i;
    }

    public void setShort(short i) {
        byte[] b = ByteIterator.decoct(i);
        this.array[this.current] = b[0];
        this.array[this.current + 1] = b[1];
    }

    public void setInt(int i) {
        byte[] b = ByteIterator.decoct(i);
        this.array[this.current] = b[0];
        this.array[this.current + 1] = b[1];
        this.array[this.current + 2] = b[2];
        this.array[this.current + 3] = b[3];
    }

    public void set24(int i) {
        byte[] b = ByteIterator.decoct(i);
        this.array[this.current] = b[0];
        this.array[this.current + 1] = b[1];
        this.array[this.current + 2] = b[2];
    }

    public void setLong(long i) {
        byte[] b = ByteIterator.decoct(i);
        this.array[this.current] = b[0];
        this.array[this.current + 1] = b[1];
        this.array[this.current + 2] = b[2];
        this.array[this.current + 3] = b[3];
        this.array[this.current + 4] = b[4];
        this.array[this.current + 5] = b[5];
        this.array[this.current + 6] = b[6];
        this.array[this.current + 7] = b[7];
    }

    public static long toLong(byte[] b) {
        return ByteIterator.concoctLong(b);
    }

    public static long toLong(byte[] b, int start) {
        return ByteIterator.concoctLong(b, start);
    }

    public static long concoctLong(byte[] b) {
        long l = ((long)b[0] & 0xFFL) << 56;
        l |= ((long)b[1] & 0xFFL) << 48;
        l |= ((long)b[2] & 0xFFL) << 40;
        l |= ((long)b[3] & 0xFFL) << 32;
        l |= ((long)b[4] & 0xFFL) << 24;
        l |= ((long)b[5] & 0xFFL) << 16;
        l |= ((long)b[6] & 0xFFL) << 8;
        return l |= (long)b[7] & 0xFFL;
    }

    public static long concoctLong(byte[] b, int start) {
        long u = (long)ByteIterator.concoctInt(b, start) & 0xFFFFFFFFL;
        long l = (long)ByteIterator.concoctInt(b, start + 4) & 0xFFFFFFFFL;
        return u << 32 | l;
    }

    public static int toInt(byte[] b) {
        return ByteIterator.concoctInt(b);
    }

    public static int toInt(byte[] b, int start) {
        return ByteIterator.concoctInt(b, start);
    }

    public static int concoctInt(byte[] b) {
        return b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static int to24(byte[] b) {
        return ByteIterator.concoct24(b);
    }

    public static int to24(byte[] b, int start) {
        return ByteIterator.concoct24(b, start);
    }

    public static int concoct24(byte[] b) {
        return b[0] << 16 | (b[1] & 0xFF) << 8 | b[2] & 0xFF;
    }

    public static int concoct24(byte[] b, int start) {
        return b[start + 0] << 16 | (b[start + 1] & 0xFF) << 8 | b[start + 2] & 0xFF;
    }

    public static int concoctInt(byte[] b, int start) {
        return b[start] << 24 | (b[start + 1] & 0xFF) << 16 | (b[start + 2] & 0xFF) << 8 | b[start + 3] & 0xFF;
    }

    public static short toShort(byte[] b) {
        return ByteIterator.concoctShort(b);
    }

    public static short toShort(byte[] b, int start) {
        return ByteIterator.concoctShort(b, start);
    }

    public static short concoctShort(byte[] b) {
        return (short)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
    }

    public static short concoctShort(byte[] b, int start) {
        return (short)((b[start] & 0xFF) << 8 | b[start + 1] & 0xFF);
    }

    public static byte[] decoct(short i) {
        byte[] b = new byte[]{(byte)(i >>> 8), (byte)i};
        return b;
    }

    public static byte[] toBytes(int i) {
        return ByteIterator.decoct(i);
    }

    public static byte[] decoct(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        return b;
    }

    public static byte[] toBytes(long i) {
        return ByteIterator.decoct(i);
    }

    public static byte[] toBytes24High(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8)};
        return b;
    }

    public static byte[] toBytes24Low(int i) {
        byte[] b = new byte[]{(byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        return b;
    }

    public static byte[] decoct(long i) {
        byte[] b = new byte[]{(byte)(i >>> 56), (byte)(i >>> 48), (byte)(i >>> 40), (byte)(i >>> 32), (byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        return b;
    }

    public int readInt() {
        int i = this.nextInt();
        this.moveInt();
        return i;
    }

    public short readShort() {
        short i = this.nextShort();
        this.moveShort();
        return i;
    }

    public int read24() {
        int i = ByteIterator.concoct24(this.array, this.current);
        this.move24();
        return i;
    }

    public long readLong() {
        long i = this.nextLong();
        this.moveLong();
        return i;
    }

    public int readUnsignedShort() {
        int i = this.nextUnsignedShort();
        this.moveShort();
        return i;
    }

    public int readUnsignedByte() {
        int i = this.nextByte() & 0xFF;
        this.moveByte();
        return i;
    }

    public byte readByte() {
        byte i = this.nextByte();
        this.moveByte();
        return i;
    }

    public void skipBytes(int count) {
        this.move(count);
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int count) {
        if (offset + count > b.length) {
            count = b.length - offset;
        }
        if (count > this.array.length - this.current) {
            count = this.array.length - this.current;
        }
        if (count <= 0) {
            return 0;
        }
        System.arraycopy(this.array, this.current, b, offset, count);
        this.move(count);
        return count;
    }

    public void seek(long posn) {
        this.setIndex((int)posn);
    }

    public void seek(int posn) {
        this.setIndex(posn);
    }

    public void writeByte(byte i) {
        this.setByte(i);
        this.moveByte();
    }

    public void writeByte(int i) {
        this.writeByte((byte)i);
    }

    public void writeInt(int i) {
        this.setInt(i);
        this.moveInt();
    }

    public void write24(int i) {
        this.set24(i);
        this.move24();
    }

    public void writeLong(long i) {
        this.setLong(i);
        this.moveLong();
    }

    public void writeShort(short i) {
        this.setShort(i);
        this.moveShort();
    }

    public void writeShort(int i) {
        this.writeShort((short)i);
    }

    public int write(byte[] b) {
        int blen = b.length;
        System.arraycopy(b, 0, this.array, this.current(), blen);
        this.move(blen);
        return blen;
    }

    public int write(byte[] b, int start, int length) {
        int blen = b.length;
        if (this.current() + blen > this.array.length) {
            return -1;
        }
        System.arraycopy(b, start, this.array, this.current(), length);
        this.move(blen);
        return blen;
    }

    public long length() {
        return this.array.length;
    }

    public byte[] extend(int diff) {
        byte[] newBuf = new byte[this.array.length + diff];
        int smallest = newBuf.length > this.array.length ? this.array.length : newBuf.length;
        System.arraycopy(this.array, 0, newBuf, 0, smallest);
        this.array = newBuf;
        return this.array;
    }

    public String readLine() {
        if (this.current == this.array.length) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            byte c;
            while ((c = this.nextByte()) != -1) {
                ++this.current;
                if (c != 13 && c != 10) {
                    sb.append((char)c);
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.last();
        }
        return sb.toString();
    }

    public static String dump(byte[] buf, int start, int length) {
        return new ByteIterator(buf, false).dump(start, length);
    }

    public String dump(int start, int length) {
        StringBuffer sb = new StringBuffer();
        int origPosn = this.current();
        byte[] b = new byte[16];
        int end = length + start;
        boolean posn = false;
        int fmtLength = this.fmtLength(end);
        this.seek(start);
        for (int here = start; here < end; here += 16) {
            int br = this.read(b, 0, 16);
            if (here + 16 > end) {
                br = length % 16;
            }
            int residA = br > 8 ? 8 : br;
            int blanksA = (8 - residA) * 3;
            int residB = br - residA;
            int blanksB = (8 - residB) * 3 - 1;
            sb.append(this.fmtPosn(here, fmtLength)).append(": ");
            sb.append(ByteIterator.toHexString(b, 0, residA));
            if (blanksA > 0) {
                sb.append(Filler.substring(0, blanksA));
            }
            sb.append(" - ");
            sb.append(ByteIterator.toHexString(b, 8, residB));
            if (blanksB > 0) {
                sb.append(Filler.substring(0, blanksB));
            }
            sb.append("  ");
            for (int i = 0; i < br; ++i) {
                if (i == 8) {
                    sb.append(" - ");
                }
                if (Ctype.isprint(b[i])) {
                    if (Ctype.isspace(b[i])) {
                        sb.append(' ');
                        continue;
                    }
                    sb.append((char)b[i]);
                    continue;
                }
                sb.append('.');
            }
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        this.seek(origPosn);
        return sb.toString();
    }

    private int fmtLength(int length) {
        int flen = 0;
        int tmp = length;
        int i = 0;
        while (tmp > 0) {
            tmp >>>= 4;
            ++flen;
            ++i;
        }
        if (++flen < 2) {
            flen = 2;
        }
        return flen;
    }

    private String fmtPosn(int posn, int flen) {
        StringBuffer sb = new StringBuffer(Integer.toHexString(posn));
        while (sb.length() < flen) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    private static String toHexString(byte[] buf, int start, int length) {
        StringBuffer sb = new StringBuffer();
        int buflen = buf.length;
        int c = 0;
        for (int i = start; i < buflen && c < length; ++i, ++c) {
            sb.append(hex[buf[i] >>> 4 & 0xF]).append(hex[buf[i] & 0xF]).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String toHexString(byte[] buf) {
        return ByteIterator.toHexString(buf, 0, buf.length);
    }

    public void compile(String pattern) {
        int j;
        int k;
        if (this.skip == null) {
            this.skip = new int[256];
        }
        this.pat = pattern.getBytes();
        this.patLen = this.pat.length;
        int[] f = new int[this.patLen];
        this.d = new int[this.patLen];
        int m = this.patLen;
        for (k = 0; k < 256; ++k) {
            this.skip[k] = m;
        }
        for (k = 1; k <= m; ++k) {
            this.d[k - 1] = (m << 1) - k;
            this.skip[this.pat[k - 1]] = m - k;
        }
        int t = m + 1;
        for (j = m; j > 0; --j) {
            f[j - 1] = t;
            while (t <= m && this.pat[j - 1] != this.pat[t - 1]) {
                this.d[t - 1] = this.d[t - 1] < m - j ? this.d[t - 1] : m - j;
                t = f[t - 1];
            }
            --t;
        }
        int q = t;
        t = m + 1 - q;
        int q1 = 1;
        int t1 = 0;
        for (j = 1; j <= t; ++j) {
            f[j - 1] = t1;
            while (t1 >= 1 && this.pat[j - 1] != this.pat[t1 - 1]) {
                t1 = f[t1 - 1];
            }
            ++t1;
        }
        while (q < m) {
            for (k = q1; k <= q; ++k) {
                this.d[k - 1] = this.d[k - 1] < m + q - k ? this.d[k - 1] : m + q - k;
            }
            q1 = q + 1;
            q = q + t - f[t - 1];
            t = f[t - 1];
        }
    }

    public int search(int start, int length) {
        int k;
        byte[] text = this.array;
        int textLen = length + start;
        this.partial = -1;
        if (start > this.array.length) {
            return -1;
        }
        if (this.d == null) {
            return -1;
        }
        int m = this.patLen;
        if (m == 0) {
            return 0;
        }
        int j = 0;
        int max = 0;
        for (k = start + m - 1; k < textLen; k += max) {
            for (j = m - 1; j >= 0 && text[k] == this.pat[j]; --j) {
                --k;
            }
            if (j == -1) {
                return k + 1;
            }
            int z = this.skip[text[k]];
            max = z > this.d[j] ? z : this.d[j];
        }
        if (k >= textLen && j > 0) {
            this.partial = k - max - 1;
            return -1;
        }
        return -1;
    }

    public int partialMatch() {
        return this.partial;
    }
}

