/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import subzero.lib.util.RegExpressionFileFilter;

public class FileUtils {
    public static void writeXmlFile(Document doc, File filename) {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(filename);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static String readFile(String filename) {
        return FileUtils.readFile(new File(filename));
    }

    public static String readFile(File filename) {
        String FileContents = "";
        try {
            BufferedReader ScriptFileReader = new BufferedReader(new FileReader(filename));
            char[] cbuf = new char[(int)filename.length()];
            ScriptFileReader.read(cbuf);
            char[] finalbuf = new char[cbuf.length];
            int j = 0;
            for (int i = 0; i < cbuf.length; ++i) {
                if (cbuf[i] == '\r') continue;
                finalbuf[j++] = cbuf[i];
            }
            while (j < cbuf.length) {
                finalbuf[j++] = 32;
            }
            FileContents = new String(finalbuf);
            ScriptFileReader.close();
        }
        catch (Exception e) {
            return null;
        }
        return FileContents.trim();
    }

    public static void writeFile(String filename, String data) {
        FileUtils.writeFile(new File(filename), data);
    }

    public static void writeFile(File file, String data) {
        BufferedReader OurDataReader = new BufferedReader(new StringReader(data));
        String ls = System.getProperty("line.separator", "\n");
        try {
            String line;
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            PrintWriter OurFileWriter = new PrintWriter(new FileWriter(file));
            while ((line = OurDataReader.readLine()) != null) {
                OurFileWriter.write(line + ls);
            }
            OurFileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean patternDelete(String directory, String strPattern) {
        File dir = new File(directory);
        RegExpressionFileFilter regexFilter = new RegExpressionFileFilter(strPattern);
        File[] fileList = dir.listFiles(regexFilter);
        if (fileList.length == 0) {
            return false;
        }
        for (File rmFile : fileList) {
            rmFile.delete();
        }
        return true;
    }

    public static boolean recursiveDelete(File f) {
        if (f == null || !f.exists()) {
            return true;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.recursiveDelete(children[i]);
            }
        }
        return f.delete();
    }

    public static CRC32 getCRC(File f) {
        try {
            int len;
            CRC32 crc = new CRC32();
            crc.reset();
            FileInputStream fin = new FileInputStream(f);
            byte[] buf = new byte[16384];
            while ((len = fin.read(buf)) != -1) {
                crc.update(buf, 0, len);
            }
            return crc;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
}

