/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IPreparedStatement;
import ianywhere.ml.jdbcodbc.IResource;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class ICallableStatement
extends IPreparedStatement
implements CallableStatement {
    private ArrayList outParamTypes = new ArrayList();

    private ICallableStatement(long l) {
        super(l);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native BigDecimal getBigDecimal(int var1, int var2) throws SQLException;

    public native BigDecimal getBigDecimal(int var1) throws SQLException;

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native boolean getBoolean(int var1) throws SQLException;

    public native byte getByte(int var1) throws SQLException;

    public native byte[] getBytes(int var1) throws SQLException;

    public Clob getClob(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native Date getDate(int var1) throws SQLException;

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return new Date(calendar.get(1) - 1900, calendar.get(2), calendar.get(5));
    }

    public native double getDouble(int var1) throws SQLException;

    public native float getFloat(int var1) throws SQLException;

    public native int getInt(int var1) throws SQLException;

    public native long getLong(int var1) throws SQLException;

    public Object getObject(int n) throws SQLException {
        switch (this.getParamType(n)) {
            case -7: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case -6: {
                byte by = this.getByte(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Byte(by);
            }
            case 4: 
            case 5: {
                int n2 = this.getInt(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(n2);
            }
            case -5: {
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case 6: 
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
        }
        throw new SQLException(IResource.getString("CANNOT_MAP_CLASS", String.valueOf(n)));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native short getShort(int var1) throws SQLException;

    public native String getString(int var1) throws SQLException;

    public native Time getTime(int var1) throws SQLException;

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public native Timestamp getTimestamp(int var1) throws SQLException;

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0 + 0.5));
        return new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.nativeRegisterOutParameter(n, n2);
        this.setParamType(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.nativeRegisterOutParameter(n, n2, n3);
        this.setParamType(n, n2);
    }

    public native void nativeRegisterOutParameter(int var1, int var2) throws SQLException;

    public native void nativeRegisterOutParameter(int var1, int var2, int var3) throws SQLException;

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native boolean wasNull() throws SQLException;

    public void setParamType(int n, int n2) {
        this.outParamTypes.ensureCapacity(n);
        int n3 = this.outParamTypes.size();
        while (n3 < n) {
            this.outParamTypes.add(n3, null);
            ++n3;
        }
        this.outParamTypes.set(n - 1, new Integer(n2));
    }

    public int getParamType(int n) throws SQLException {
        return (Integer)this.outParamTypes.get(n - 1);
    }
}

