/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.acs.mgmt.ucp.service;

import com.cisco.nm.acs.mgmt.ucp.service.UCP;
import com.cisco.nm.acs.mgmt.ucp.service.UCPService;
import com.cisco.nm.acs.mgmt.ucp.service.UCPStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class UCPServiceLocator
extends Service
implements UCPService {
    private String UCP_address = "https://localhost/PI/services/UCP/";
    private String UCPWSDDServiceName = "UCP";
    private HashSet ports = null;

    public UCPServiceLocator() {
    }

    public UCPServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public UCPServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getUCPAddress() {
        return this.UCP_address;
    }

    public String getUCPWSDDServiceName() {
        return this.UCPWSDDServiceName;
    }

    public void setUCPWSDDServiceName(String name) {
        this.UCPWSDDServiceName = name;
    }

    public UCP getUCP() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.UCP_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getUCP(endpoint);
    }

    public UCP getUCP(URL portAddress) throws ServiceException {
        try {
            UCPStub _stub = new UCPStub(portAddress, this);
            _stub.setPortName(this.getUCPWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setUCPEndpointAddress(String address) {
        this.UCP_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (UCP.class.isAssignableFrom(serviceEndpointInterface)) {
                UCPStub _stub = new UCPStub(new URL(this.UCP_address), this);
                _stub.setPortName(this.getUCPWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("UCP".equals(inputPortName)) {
            return this.getUCP();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://cisco.com/nm/acs/mgmt/ucp/service/", "UCPService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://cisco.com/nm/acs/mgmt/ucp/service/", "UCP"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"UCP".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setUCPEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

