/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.JSSESocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.commons.logging.Log;

public class CertificateSecureSocketFactory
extends JSSESocketFactory
implements SecureSocketFactory {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$components$net$CertificateSecureSocketFactory == null ? (class$org$apache$axis$components$net$CertificateSecureSocketFactory = CertificateSecureSocketFactory.class$("org.apache.axis.components.net.CertificateSecureSocketFactory")) : class$org$apache$axis$components$net$CertificateSecureSocketFactory).getName());
    static final String DEFAULT_PROTOCOL = "TLS";
    static /* synthetic */ Class class$org$apache$axis$components$net$CertificateSecureSocketFactory;

    public CertificateSecureSocketFactory(Hashtable attributes) {
        super(attributes);
    }

    protected void initFactory() throws IOException {
        try {
            log.info((Object)"Enter::CertificateSecureSocketFactory::init");
            SSLContext context = this.getContext();
            this.sslFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected SSLContext getContext() throws IOException {
        try {
            if (this.attributes == null || this.attributes.get("keyStore") == null && this.attributes.get("trustStore") == null) {
                SSLContext context = SSLContext.getInstance(DEFAULT_PROTOCOL);
                context.init(null, null, null);
                return context;
            }
            String protocol = this.getProtocol();
            KeyManager[] keyManagers = this.getKeyManagers();
            TrustManager[] trustManagers = this.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Exception trying to load sslContext " + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException("Exception trying to load sslContext " + e.getMessage());
        }
    }

    private KeyManager[] getKeyManagers() throws IOException {
        String keyStoreFile = (String)this.attributes.get("keyStore");
        try {
            KeyManager[] keyManagers = null;
            if (keyStoreFile != null) {
                String algorithm;
                String keyStorePass = (String)this.attributes.get("keyStorePassword");
                String keyStoreType = (String)this.attributes.get("keyStoreType");
                if (keyStoreType == null) {
                    keyStoreType = KeyStore.getDefaultType();
                }
                if ((algorithm = this.getAlgorithm()) == null) {
                    algorithm = KeyManagerFactory.getDefaultAlgorithm();
                }
                KeyStore keyStore = this.initKeyStore(keyStoreFile, keyStorePass, keyStoreType);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(keyStore, keyStorePass.toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            return keyManagers;
        }
        catch (Exception e) {
            throw new IOException("Exception trying to load keyStore " + keyStoreFile + ": " + e.getMessage());
        }
    }

    private TrustManager[] getTrustManagers() throws IOException {
        String trustStoreFile = (String)this.attributes.get("trustStore");
        try {
            TrustManager[] trustManagers = null;
            if (trustStoreFile != null) {
                String algorithm;
                String trustStorePass = (String)this.attributes.get("trustStorePassword");
                String trustStoreType = (String)this.attributes.get("trustStoreType");
                if (trustStoreType == null) {
                    trustStoreType = KeyStore.getDefaultType();
                }
                if ((algorithm = this.getAlgorithm()) == null) {
                    algorithm = TrustManagerFactory.getDefaultAlgorithm();
                }
                KeyStore trustStore = this.initKeyStore(trustStoreFile, trustStorePass, trustStoreType);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            return trustManagers;
        }
        catch (Exception e) {
            throw new IOException("Exception trying to load trustStore " + trustStoreFile + ": " + e.getMessage());
        }
    }

    private String getProtocol() {
        String protocol = (String)this.attributes.get("protocol");
        if (protocol == null) {
            protocol = DEFAULT_PROTOCOL;
        }
        return protocol;
    }

    private String getAlgorithm() {
        return (String)this.attributes.get("algorithm");
    }

    protected KeyStore initKeyStore(String keyFile, String keyPassword, String keyType) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CertificateSecureSocketFactory::init key store::" + keyFile + "::" + keyPassword + "::" + keyType));
            }
            KeyStore kStore = KeyStore.getInstance(keyType);
            FileInputStream istream = new FileInputStream(keyFile);
            kStore.load(istream, keyPassword.toCharArray());
            return kStore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("Exception trying to load keyStore " + keyFile + ": " + ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

