/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.BERFactory;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERFactory;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSetParser;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int baseTag, int tagNumber, InputStream contentStream) {
        this._baseTag = baseTag;
        this._tagNumber = tagNumber;
        this._contentStream = contentStream;
        this._indefiniteLength = contentStream instanceof IndefiniteLengthInputStream;
    }

    public boolean isConstructed() {
        return (this._baseTag & 0x20) != 0;
    }

    public int getTagNo() {
        return this._tagNumber;
    }

    public DEREncodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (isExplicit) {
            return new ASN1StreamParser(this._contentStream).readObject();
        }
        switch (tag) {
            case 17: {
                if (this._indefiniteLength) {
                    return new BERSetParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSetParser(new ASN1StreamParser(this._contentStream));
            }
            case 16: {
                if (this._indefiniteLength) {
                    return new BERSequenceParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSequenceParser(new ASN1StreamParser(this._contentStream));
            }
            case 4: {
                if (this._indefiniteLength || this.isConstructed()) {
                    return new BEROctetStringParser(new ASN1StreamParser(this._contentStream));
                }
                return new DEROctetStringParser((DefiniteLengthInputStream)this._contentStream);
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    private ASN1EncodableVector rLoadVector(InputStream in) {
        try {
            return new ASN1StreamParser(in).readVector();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage(), e);
        }
    }

    public DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            return v.size() == 1 ? new BERTaggedObject(true, this._tagNumber, v.get(0)) : new BERTaggedObject(false, this._tagNumber, BERFactory.createSequence(v));
        }
        if (this.isConstructed()) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            return v.size() == 1 ? new DERTaggedObject(true, this._tagNumber, v.get(0)) : new DERTaggedObject(false, this._tagNumber, DERFactory.createSequence(v));
        }
        try {
            DefiniteLengthInputStream defIn = (DefiniteLengthInputStream)this._contentStream;
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(defIn.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

