/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractBufferingInputStream
extends InputStream {
    private Object closeSyncObject = new Object();
    private final int m_bufferSize;
    private byte[] m_buffer;
    private int m_pos = 0;
    private int m_size = 0;

    protected AbstractBufferingInputStream(int bufferSize) {
        this.m_bufferSize = bufferSize;
        this.m_buffer = new byte[bufferSize];
    }

    protected abstract void closeInternal() throws IOException;

    protected abstract int getNextChunk(byte[] var1) throws IOException;

    public final int available() throws IOException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        this.m_buffer = null;
        Object object = this.closeSyncObject;
        synchronized (object) {
            this.closeInternal();
        }
    }

    public final void mark(int readlimit) {
        throw new RuntimeException("Not supported");
    }

    public final boolean markSupported() {
        return false;
    }

    public final synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.m_buffer == null) {
            return -1;
        }
        this.fillBuffer();
        if (this.m_buffer == null) {
            return -1;
        }
        int toread = Math.min(this.m_size - this.m_pos, len);
        System.arraycopy(this.m_buffer, this.m_pos, b, off, toread);
        this.m_pos += toread;
        return toread;
    }

    public final synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final void reset() throws IOException {
        throw new IOException("Not implemented");
    }

    public final synchronized long skip(long n) throws IOException {
        int nextskip;
        byte[] buffer = new byte[this.m_bufferSize];
        for (long remaining = n; remaining > 0L; remaining -= (long)this.read(buffer, 0, nextskip)) {
            nextskip = (int)Math.min((long)this.m_bufferSize, remaining);
        }
        return n;
    }

    public final synchronized int read() throws IOException {
        if (this.m_buffer == null) {
            return -1;
        }
        this.fillBuffer();
        if (this.m_buffer == null) {
            return -1;
        }
        int pos = this.m_pos++;
        return this.m_buffer[pos];
    }

    private final void fillBuffer() throws IOException {
        if (this.m_buffer == null) {
            return;
        }
        if (this.m_size == 0 || this.m_pos == this.m_size) {
            this.m_size = this.getNextChunk(this.m_buffer);
            this.m_pos = 0;
            if (this.m_size == -1) {
                this.m_size = 0;
                this.m_buffer = null;
            }
        }
    }
}

