/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import subzero.lib.io.IFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryImpl
implements IFileEntry {
    private final File m_file;
    private final String m_name;
    private final long m_lastModified;
    private final boolean m_isDirectory;
    private final Object m_parent;
    private final long m_length;
    private List<IFileEntry> m_children = null;

    public FileEntryImpl(Object parent, File file) {
        this.m_name = file.getName();
        this.m_lastModified = file.lastModified();
        this.m_isDirectory = file.isDirectory();
        this.m_file = file;
        this.m_parent = parent;
        this.m_length = -1L;
    }

    public FileEntryImpl(Object parent, String name, boolean isDirectory, long length) {
        this.m_name = name.substring(name.replace('\\', '/').lastIndexOf(47) + 1);
        this.m_lastModified = 0L;
        this.m_isDirectory = isDirectory;
        this.m_file = null;
        this.m_parent = parent;
        this.m_length = length;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public long getLastModified() {
        return this.m_file != null ? this.m_file.lastModified() : this.m_lastModified;
    }

    @Override
    public boolean exists() {
        return this.m_file == null || this.m_file.exists();
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.m_file != null ? this.m_file.isDirectory() : this.m_isDirectory;
    }

    @Override
    public List<IFileEntry> getChildren() {
        if (this.m_file == null) {
            return null;
        }
        if (!this.isDirectory()) {
            return null;
        }
        if (this.m_children != null) {
            return this.m_children;
        }
        File[] files = this.m_file.listFiles();
        this.m_children = new ArrayList<IFileEntry>(files.length);
        for (int i = 0; i < files.length; ++i) {
            this.m_children.add(new FileEntryImpl(this, files[i]));
        }
        return this.m_children;
    }

    @Override
    public List<IFileEntry> getChildren(boolean refresh) {
        if (refresh) {
            this.m_children = null;
        }
        return this.getChildren();
    }

    public Class getInterfaceClass() {
        return IFileEntry.class;
    }

    @Override
    public long getLength() {
        if (this.m_file == null) {
            return this.m_length;
        }
        return this.m_file.length();
    }

    @Override
    public Object getParent() {
        return this.m_parent;
    }

    @Override
    public IFileEntry newChild(String name) {
        if (this.m_file == null) {
            return null;
        }
        List<IFileEntry> children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (IFileEntry child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        FileEntryImpl newChild = new FileEntryImpl(this, new File(this.m_file, name));
        this.m_children.add(newChild);
        return newChild;
    }

    @Override
    public String getPath() {
        StringBuffer buf = new StringBuffer();
        this.getPath(buf);
        return buf.toString();
    }

    @Override
    public String getSystemPath() {
        return this.m_file.getAbsolutePath();
    }

    private void getPath(StringBuffer buf) {
        if (this.m_parent instanceof FileEntryImpl) {
            ((FileEntryImpl)this.m_parent).getPath(buf);
        }
        buf.append(this.m_name);
        if (this.isDirectory()) {
            buf.append('/');
        }
    }
}

