/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import subzero.lib.exceptions.IORuntimeException;
import subzero.lib.exceptions.IOTimeoutException;
import subzero.lib.io.AbstractIOConnection;
import subzero.lib.io.IOConnection;
import subzero.lib.io.IOptionalRegexHandler;
import subzero.lib.io.TimeoutInputStream;
import subzero.lib.io.TimeoutOutputStream;

public class RegexConnection
extends AbstractIOConnection
implements IOConnection {
    private final IOConnection m_ioConnection;
    private final TimeoutInputStream m_in;
    private final TimeoutOutputStream m_out;
    private int m_maxBufferSize = 0;
    private final List<IOptionalRegexHandler> m_optionalRegexHandlers;
    private StringBuffer _bufferedOutput = null;
    private boolean _bEnableOutputBuffer = false;
    private final InputStream _rawIn;
    private final OutputStream _rawOut;
    private static boolean enableDebug = false;

    public RegexConnection(IOConnection ioc) {
        this.m_ioConnection = ioc;
        this._rawIn = ioc.getInputStream();
        this._rawOut = ioc.getOutputStream();
        this.m_in = new TimeoutInputStream(ioc.getInputStream(), -1L);
        this.m_out = new TimeoutOutputStream(ioc.getOutputStream(), -1L);
        this.m_optionalRegexHandlers = new ArrayList<IOptionalRegexHandler>();
    }

    public static boolean isEnableDebug() {
        return enableDebug;
    }

    public static void setEnableDebug(boolean _enableDebug) {
        enableDebug = _enableDebug;
    }

    public void registerOptionalRegexHandler(IOptionalRegexHandler handler) {
        this.m_optionalRegexHandlers.add(handler);
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.m_maxBufferSize = maxBufferSize;
    }

    public boolean sendText(String text) {
        try {
            return this.sendText(text, -1L);
        }
        catch (IOTimeoutException e) {
            throw new IORuntimeException("Cannot write [" + text + "] to the output stream");
        }
    }

    public boolean sendText(String text, long timeoutms) throws IOTimeoutException {
        if (text == null) {
            throw new NullPointerException("text to send cannot be null");
        }
        if (enableDebug) {
            System.out.println("text => " + text + ", length => " + text.length() + ", length of bytes => " + text.getBytes().length);
        }
        this.m_out.setWriteTimeout(timeoutms);
        try {
            this.m_out.flush();
            this.m_out.write(text.getBytes());
            this.m_out.flush();
        }
        catch (InterruptedIOException e) {
            throw new IORuntimeException("Unable to write [" + text + "] due to InterruptedIOException");
        }
        catch (IOException e) {
            throw new IORuntimeException("Cannot write [" + text + "] to the output stream", e);
        }
        return true;
    }

    public String readUntilRegex(String regex) {
        try {
            return this.readUntilRegex(Pattern.compile(regex), -1L, false);
        }
        catch (IOTimeoutException e) {
            throw new IORuntimeException(e);
        }
    }

    public String readUntilRegex(String regex, long timeoutms) throws IOTimeoutException {
        return this.readUntilRegex(regex, timeoutms, false);
    }

    public String readUntilRegex(String regex, long timeoutms, boolean absolute) throws IOTimeoutException {
        return this.readUntilRegex(Pattern.compile(regex), timeoutms, absolute);
    }

    public String readUntilRegex(Pattern pattern) {
        try {
            return this.readUntilRegex(pattern, -1L, false);
        }
        catch (IOTimeoutException e) {
            throw new IORuntimeException(e);
        }
    }

    public synchronized String readUntilRegex(Pattern pattern, long timeoutms) throws IOTimeoutException {
        return this.readUntilRegex(pattern, timeoutms, false);
    }

    public synchronized String readUntilRegex(Pattern pattern, long timeoutms, boolean absolute) throws IOTimeoutException {
        StringBuffer buffer = new StringBuffer();
        this._bufferedOutput = null;
        try {
            boolean usingTimeout;
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeoutms;
            boolean bl = usingTimeout = timeoutms > 0L;
            if (!usingTimeout) {
                this.m_in.setReadTimeout(-1L);
            }
            long now = startTime;
            while (!usingTimeout || now < endTime) {
                int response;
                if (usingTimeout) {
                    this.m_in.setReadTimeout(endTime - now);
                }
                if ((response = this.m_in.read()) == -1) {
                    throw new IORuntimeException("Unable to read [" + pattern.pattern() + "] due to no more data available (EOF).  If your regex was to match more than the current maximum buffer size of [" + this.m_maxBufferSize + "] bytes, please update the buffer size by calling the setMaxBufferSize() method before attempting to match the regex.");
                }
                if (this.m_maxBufferSize > 0 && buffer.length() >= this.m_maxBufferSize) {
                    buffer.delete(0, buffer.length() - this.m_maxBufferSize + 1);
                }
                buffer.append((char)response);
                Matcher pm = pattern.matcher(buffer);
                if (pm.find(0)) {
                    this.m_optionalRegexHandlers.clear();
                    if (this._bEnableOutputBuffer) {
                        this._bufferedOutput = buffer;
                    }
                    return buffer.toString();
                }
                Iterator<IOptionalRegexHandler> iter = this.m_optionalRegexHandlers.iterator();
                while (iter.hasNext()) {
                    IOptionalRegexHandler orp = iter.next();
                    if (!orp.matches(buffer)) continue;
                    if (orp.process(this, buffer)) {
                        iter.remove();
                    }
                    buffer.setLength(0);
                    break;
                }
                if (usingTimeout) {
                    now = System.currentTimeMillis();
                }
                if (!usingTimeout || absolute) continue;
                endTime = System.currentTimeMillis() + timeoutms;
            }
        }
        catch (InterruptedIOException iioe) {
            throw new IOTimeoutException("Unable to read [" + pattern.pattern() + "] within [" + timeoutms + "] milliseconds");
        }
        catch (IOException ioe) {
            throw new IORuntimeException("Unable to read [" + pattern.pattern() + "] due to underlying stream error", ioe);
        }
        throw new IOTimeoutException("Unable to read [" + pattern.pattern() + "] within [" + timeoutms + "] milliseconds");
    }

    public String readLine() {
        try {
            return this.readLine(-1);
        }
        catch (IOTimeoutException e) {
            throw new IORuntimeException(e);
        }
    }

    public String readLine(int timeout) throws IOTimeoutException {
        return this.readUntilRegex("\n", (long)timeout);
    }

    public void enableOutputStorage() {
        this._bEnableOutputBuffer = true;
    }

    public void disableOutputStorage() {
        this._bEnableOutputBuffer = false;
    }

    public String getLastOutput() {
        if (this._bufferedOutput == null) {
            return null;
        }
        return this._bufferedOutput.toString();
    }

    public boolean waitForRegex(String regex) {
        return this.readUntilRegex(regex) != null;
    }

    public boolean waitForRegex(String regex, long timeoutms) throws IOTimeoutException {
        return this.readUntilRegex(regex, timeoutms) != null;
    }

    public boolean waitForRegex(Pattern pattern) {
        return this.readUntilRegex(pattern) != null;
    }

    public boolean waitForRegex(Pattern pattern, long timeoutms) throws IOTimeoutException {
        return this.waitForRegex(pattern, timeoutms, false);
    }

    public boolean waitForRegex(Pattern pattern, long timeoutms, boolean absolute) throws IOTimeoutException {
        return this.readUntilRegex(pattern, timeoutms, absolute) != null;
    }

    public String getConnectionName() {
        return "REGEX:" + this.m_ioConnection.getConnectionName();
    }

    public InputStream getInputStream() {
        return this.m_in;
    }

    public OutputStream getOutputStream() {
        return this.m_out;
    }

    public InputStream getRawInputStream() {
        return this._rawIn;
    }

    public OutputStream getRawOutputStream() {
        return this._rawOut;
    }

    public void close() throws IOException {
        this.m_in.close();
        this.m_out.close();
        this.m_ioConnection.close();
    }

    public boolean isClosed() {
        return this.m_ioConnection.isClosed();
    }
}

