/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import subzero.lib.exceptions.IORuntimeException;
import subzero.lib.io.IFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmbFileEntry
implements IFileEntry {
    private SmbFileEntry m_parent;
    private SmbFile m_file;
    private String m_path;
    private List<IFileEntry> m_children;

    public SmbFileEntry(SmbFile file) {
        this.m_file = file;
        this.m_parent = this.getParentFileEntry();
    }

    public SmbFileEntry(SmbFile parent, String path) throws UnknownHostException, MalformedURLException {
        this.m_parent = new SmbFileEntry(parent);
        this.m_path = path;
        this.m_file = new SmbFile(parent, path);
    }

    @Override
    public String getName() {
        return this.m_file.getName();
    }

    @Override
    public String getPath() {
        if (this.m_path != null) {
            return this.m_path;
        }
        return this.getSystemPath();
    }

    @Override
    public String getSystemPath() {
        if (this.m_parent == null) {
            return this.m_file.getName();
        }
        return this.m_parent.getSystemPath() + this.m_file.getName();
    }

    @Override
    public long getLastModified() {
        return this.m_file.getLastModified();
    }

    @Override
    public long getLength() {
        return this.m_file.getContentLength();
    }

    @Override
    public boolean exists() {
        try {
            return this.m_file.exists();
        }
        catch (SmbAuthException e) {
            throw new IORuntimeException(e);
        }
        catch (SmbException e) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.m_file.isFile();
        }
        catch (SmbException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.m_file.isDirectory();
        }
        catch (SmbException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public List<IFileEntry> getChildren() {
        return this.getChildren(true);
    }

    @Override
    public List<IFileEntry> getChildren(boolean refresh) {
        if (refresh || this.m_children == null) {
            try {
                SmbFile[] smbfiles = this.m_file.listFiles();
                this.m_children = new ArrayList<IFileEntry>(smbfiles.length);
                for (int i = 0; i < smbfiles.length; ++i) {
                    this.m_children.add(new SmbFileEntry(this.m_file, smbfiles[i].getName()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.m_children;
    }

    @Override
    public Object getParent() {
        return this.m_parent;
    }

    private SmbFileEntry getParentFileEntry() {
        if (this.m_file.getParent() == null || "smb://".equals(this.m_file.getParent())) {
            return null;
        }
        try {
            return new SmbFileEntry(new SmbFile(this.m_file.getParent()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IFileEntry newChild(String name) {
        if (!this.isDirectory()) {
            return null;
        }
        try {
            List<IFileEntry> children = this.getChildren();
            for (IFileEntry child : children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
            SmbFileEntry newentry = new SmbFileEntry(this.m_file, name);
            this.m_children.add(newentry);
            return newentry;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SmbFile getRealFile() {
        return this.m_file;
    }

    protected void setRealFile(SmbFile smbfile) {
        this.m_file = smbfile;
    }

    public boolean equals(Object o) {
        if (o instanceof SmbFileEntry) {
            return ((SmbFileEntry)o).getRealFile().equals((Object)this.m_file);
        }
        return false;
    }
}

