/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    private ClassLoader[] m_children;

    public MultiClassLoader(ClassLoader parent, ClassLoader[] children) {
        super(parent);
        this.m_children = children;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.m_children.length; ++i) {
            Class<?> c = this.m_children[i].loadClass(name);
            if (c == null) continue;
            return c;
        }
        return super.findClass(name);
    }

    protected URL findResource(String name) {
        for (int i = 0; i < this.m_children.length; ++i) {
            URL url = this.m_children[i].getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.findResource(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        HashSet<URL> set = new HashSet<URL>();
        for (int i = 0; i < this.m_children.length; ++i) {
            URL url = this.m_children[i].getResource(name);
            if (url == null) continue;
            set.add(url);
        }
        return new Vector(set).elements();
    }
}

