/*
 * Decompiled with CFR 0.152.
 */
package org.josql.internal;

import java.util.ArrayList;
import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.ValueExpression;
import org.josql.internal.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Limit {
    private ValueExpression start;
    private ValueExpression rowsCount;

    public void init(Query q) throws QueryParseException {
        Class c;
        if (this.start != null) {
            this.start.init(q);
            c = this.start.getExpectedReturnType(q);
            if (!Utilities.isNumber(c)) {
                throw new QueryParseException("The expected return type of the start expression: \"" + this.start + "\" of the LIMIT clause is: " + c.getName() + " however the expression when evaluated must return a numeric result.");
            }
        }
        this.rowsCount.init(q);
        c = this.rowsCount.getExpectedReturnType(q);
        if (!Utilities.isNumber(c)) {
            throw new QueryParseException("The expected return type of the rows count expression: \"" + this.rowsCount + "\" of the LIMIT clause is: " + c.getName() + " however the expression when evaluated must return a numeric result.");
        }
    }

    public List getSubList(List objs, Query q) throws QueryExecutionException {
        int ls;
        Object o = this.rowsCount.evaluate(null, q);
        int rows = -1;
        if (o != null && !(o instanceof Number)) {
            throw new QueryExecutionException("Return value of rows count expression: \"" + this.rowsCount + "\" for the LIMIT clause is of type: " + o.getClass().getName() + " expected it to return a numeric value.");
        }
        if (o != null) {
            rows = ((Number)o).intValue();
        }
        int start = 0;
        if (this.start != null) {
            Object s = this.start.evaluate(null, q);
            if (s != null && !(s instanceof Number)) {
                throw new QueryExecutionException("Return value of the start expression: \"" + this.start + "\" for the LIMIT clause is of type: " + s.getClass().getName() + " expected it to return a numeric value.");
            }
            if (s != null) {
                start = ((Number)s).intValue();
                --start;
            }
        }
        if (start > (ls = objs.size()) - 1) {
            return new ArrayList();
        }
        if (rows > 0) {
            if (start + rows > ls - 1) {
                return new ArrayList(objs.subList(start, ls));
            }
            return new ArrayList(objs.subList(start, start + rows));
        }
        return new ArrayList(objs.subList(start, ls));
    }

    public void setStart(ValueExpression v) {
        this.start = v;
    }

    public void setRowsCount(ValueExpression v) {
        this.rowsCount = v;
    }

    private final /* synthetic */ void this() {
        this.start = null;
        this.rowsCount = null;
    }

    public Limit() {
        this.this();
    }
}

