/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IDriver;
import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.IResultSetMetaData;
import ianywhere.ml.jdbcodbc.IStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class IPreparedStatement
extends IStatement
implements PreparedStatement {
    protected IPreparedStatement(long l) {
        super(l);
    }

    public void addBatch() throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native SQLWarning getWarnings() throws SQLException;

    public native void clearWarnings() throws SQLException;

    public native void clearParameters() throws SQLException;

    public native boolean execute() throws SQLException;

    public native ResultSet executeQuery() throws SQLException;

    public native int executeUpdate() throws SQLException;

    public ResultSetMetaData getMetaData() throws SQLException {
        return new IResultSetMetaData(this);
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native void setAsciiStream(int var1, InputStream var2, int var3) throws SQLException;

    public native void setBigDecimal(int var1, BigDecimal var2) throws SQLException;

    public native void setBinaryStream(int var1, InputStream var2, int var3) throws SQLException;

    public native void setBlob(int var1, Blob var2) throws SQLException;

    public native void setBoolean(int var1, boolean var2) throws SQLException;

    public native void setByte(int var1, byte var2) throws SQLException;

    public native void setBytes(int var1, byte[] var2) throws SQLException;

    public native void setCharacterStream(int var1, Reader var2, int var3) throws SQLException;

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native void setDate(int var1, Date var2) throws SQLException;

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, IDriver.calendarize(date, calendar));
    }

    public native void setDouble(int var1, double var2) throws SQLException;

    public native void setFloat(int var1, float var2) throws SQLException;

    public native void setInt(int var1, int var2) throws SQLException;

    public native void setLong(int var1, long var2) throws SQLException;

    public native void setNull(int var1, int var2) throws SQLException;

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else {
            this.setString(n, object.toString());
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, ((BigDecimal)object).setScale(n3));
            return;
        }
        this.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object instanceof Float) {
            this.setFloatObject(n, (Float)object, n2);
        } else if (object instanceof Double) {
            this.setDoubleObject(n, (Double)object, n2);
        } else {
            this.setObject(n, object);
        }
    }

    public void setFloatObject(int n, Float f, int n2) throws SQLException {
        if (n2 == 4) {
            int n3 = f.intValue();
            this.setInt(n, n3);
        } else if (n2 == 5) {
            short s = f.shortValue();
            this.setShort(n, s);
        } else if (n2 == -5) {
            long l = f.longValue();
            this.setLong(n, l);
        } else {
            this.setObject(n, f);
        }
    }

    public void setDoubleObject(int n, Double d, int n2) throws SQLException {
        if (n2 == 4) {
            int n3 = d.intValue();
            this.setInt(n, n3);
        } else if (n2 == 5) {
            short s = d.shortValue();
            this.setShort(n, s);
        } else if (n2 == -5) {
            long l = d.longValue();
            this.setLong(n, l);
        } else {
            this.setObject(n, d);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public native void setShort(int var1, short var2) throws SQLException;

    public native void setString(int var1, String var2) throws SQLException;

    public native void setTime(int var1, Time var2) throws SQLException;

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, IDriver.calendarize(time, calendar));
    }

    public native void setTimestamp(int var1, Timestamp var2) throws SQLException;

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, IDriver.calendarize(timestamp, calendar));
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }
}

