/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.testng.TestNGException;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.MessageHub;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public abstract class AbstractRemoteTestRunnerClient {
    protected IRemoteSuiteListener[] m_suiteListeners;
    protected IRemoteTestListener[] m_testListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private ServerConnection m_serverConnection;

    public synchronized void startListening(IRemoteSuiteListener[] suiteListeners, IRemoteTestListener[] testListeners, ServerConnection serverConnection) {
        this.m_suiteListeners = suiteListeners;
        this.m_testListeners = testListeners;
        this.m_serverConnection = serverConnection;
        serverConnection.start();
    }

    public IRemoteSuiteListener[] getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public IRemoteTestListener[] getTestListeners() {
        return this.m_testListeners;
    }

    private synchronized void shutdown() {
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.m_serverConnection.getMessageSender() != null;
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.m_serverConnection.getMessageSender().sendStop();
            this.shutdown();
        }
    }

    protected abstract void notifyStart(GenericMessage var1);

    protected abstract void notifySuiteEvents(SuiteMessage var1);

    protected abstract void notifyTestEvents(TestMessage var1);

    protected abstract void notifyResultEvents(TestResultMessage var1);

    public abstract class ServerConnection
    extends Thread {
        private MessageHub m_messageHub;

        public ServerConnection(IMessageSender messageMarshaller) {
            super("TestNG - ServerConnection");
            this.m_messageHub = new MessageHub(messageMarshaller);
        }

        IMessageSender getMessageSender() {
            return this.m_messageHub != null ? this.m_messageHub.getMessageSender() : null;
        }

        @Override
        public void run() {
            try {
                IMessage message = this.m_messageHub.receiveMessage();
                while (message != null) {
                    if (message instanceof GenericMessage) {
                        AbstractRemoteTestRunnerClient.this.notifyStart((GenericMessage)message);
                    } else if (message instanceof SuiteMessage) {
                        AbstractRemoteTestRunnerClient.this.notifySuiteEvents((SuiteMessage)message);
                    } else if (message instanceof TestMessage) {
                        AbstractRemoteTestRunnerClient.this.notifyTestEvents((TestMessage)message);
                    } else if (message instanceof TestResultMessage) {
                        AbstractRemoteTestRunnerClient.this.notifyResultEvents((TestResultMessage)message);
                    } else {
                        throw new TestNGException("Unknown message type:" + message);
                    }
                    message = this.m_messageHub.receiveMessage();
                }
            }
            finally {
                this.m_messageHub.shutDown();
                this.m_messageHub = null;
            }
        }

        protected abstract void handleThrowable(Throwable var1);
    }
}

