/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.ASAMessageHandler;
import ianywhere.ml.jdbcodbc.INative;
import ianywhere.ml.jdbcodbc.IStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class IConnection
extends INative
implements Connection {
    private Map typeMap;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private SimpleDateFormat simpleFormat;
    private Vector trueStrings;
    private String dateFormatString = "yyyy-MM-dd";
    private String timeFormatString = "HH:mm:ss";
    private String timestampFormatString = "yyyy-MM-dd HH:mm:ss.SSS";
    private ASAMessageHandler msgHandler;

    private IConnection(long l) {
        super(l);
        this.nhandle = l;
        this.typeMap = null;
        this.dateFormat = DateFormat.getDateInstance();
        this.timeFormat = DateFormat.getTimeInstance();
        this.timestampFormat = DateFormat.getDateTimeInstance();
        this.simpleFormat = new SimpleDateFormat();
        this.trueStrings = new Vector(3);
        this.trueStrings.add("1");
        this.trueStrings.add("true");
        this.trueStrings.add("TRUE");
    }

    protected synchronized native void nFree();

    public native void clearWarnings() throws SQLException;

    public native void close() throws SQLException;

    public native void commit() throws SQLException;

    public native Statement createStatement() throws SQLException;

    public native Statement createStatement(int var1, int var2) throws SQLException;

    public native boolean getAutoCommit() throws SQLException;

    public native String getCatalog() throws SQLException;

    public native DatabaseMetaData getMetaData() throws SQLException;

    public native int getTransactionIsolation() throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public native SQLWarning getWarnings() throws SQLException;

    public native boolean isClosed() throws SQLException;

    public native boolean isReadOnly() throws SQLException;

    public native String nativeSQL(String var1) throws SQLException;

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.nativePrepareCall(string, IStatement.isSelectStatement(string));
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.nativePrepareCall(string, IStatement.isSelectStatement(string), n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.nativePrepareStatement(string, IStatement.isSelectStatement(string));
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.nativePrepareStatement(string, IStatement.isSelectStatement(string), n, n2);
    }

    public native void rollback() throws SQLException;

    public native void setAutoCommit(boolean var1) throws SQLException;

    public native void setCatalog(String var1) throws SQLException;

    public native void setReadOnly(boolean var1) throws SQLException;

    public native void setTransactionIsolation(int var1) throws SQLException;

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public native String getStrAttr(int var1) throws SQLException;

    public native int getNumAttr(int var1) throws SQLException;

    public native void setAttribute(int var1, String var2) throws SQLException;

    public native void setIsolationOnOpen(int var1) throws SQLException;

    public void setAttributes(Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            try {
                if (string.equals("licpwd")) {
                    n = 1042;
                } else if (string.equals("licfile")) {
                    n = 1041;
                } else {
                    if (string.equals("timeFormat")) {
                        this.timeFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("dateFormat")) {
                        this.dateFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("timestampFormat")) {
                        this.timestampFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("user") || string.equals("password")) continue;
                    if (string.equals("ASAUseIsolationOnOpen")) {
                        String string2 = properties.getProperty(string);
                        this.setIsolationOnOpen(Integer.valueOf(string2));
                        continue;
                    }
                    n = Integer.valueOf(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.setAttribute(n, properties.getProperty(string));
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.timeFormat = dateFormat;
    }

    public void setTimestampFormat(DateFormat dateFormat) {
        this.timestampFormat = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public DateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public void callMessageHandler(SQLException sQLException) {
        this.msgHandler.messageHandler(sQLException);
    }

    public Calendar parseDate(String string) throws ParseException {
        Date date = this.dateFormat.parse(string);
        this.dateFormat.getCalendar().setTime(date);
        return this.dateFormat.getCalendar();
    }

    public Calendar parseTime(String string) throws ParseException {
        Date date = this.timeFormat.parse(string);
        this.timeFormat.getCalendar().setTime(date);
        return this.timeFormat.getCalendar();
    }

    public Calendar parseTimestamp(String string) throws ParseException {
        this.timestampFormat.getCalendar().setTime(Timestamp.valueOf(string));
        return this.timestampFormat.getCalendar();
    }

    public String formatDate(int n, int n2, int n3) {
        Calendar calendar = this.dateFormat.getCalendar();
        calendar.set(n, n2, n3);
        this.simpleFormat.applyPattern(this.dateFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatTime(int n, int n2, int n3) {
        Calendar calendar = this.timeFormat.getCalendar();
        calendar.set(0, 0, 0, n, n2, n3);
        this.simpleFormat.applyPattern(this.timeFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = this.timestampFormat.getCalendar();
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.set(14, n7);
        this.simpleFormat.applyPattern(this.timestampFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatDate(Object object) {
        return this.dateFormat.format(object);
    }

    public String formatTime(Object object) {
        return this.timeFormat.format(object);
    }

    public String formatTimestamp(Object object) {
        return this.timestampFormat.format(object);
    }

    public boolean isTrue(String string) {
        return this.trueStrings.contains(string.trim());
    }

    public void addTrueString(String string) {
        this.trueStrings.add(string);
    }

    public void removeTrueString(String string) {
        this.trueStrings.removeElement(string);
    }

    public native void setDefaultFetchSize(int var1);

    public native void setAllowTransactionControl(boolean var1);

    public native long getODBCHandle();

    public native CallableStatement nativePrepareCall(String var1, boolean var2) throws SQLException;

    public native CallableStatement nativePrepareCall(String var1, boolean var2, int var3, int var4) throws SQLException;

    public native PreparedStatement nativePrepareStatement(String var1, boolean var2) throws SQLException;

    public native PreparedStatement nativePrepareStatement(String var1, boolean var2, int var3, int var4) throws SQLException;

    public native void setASAMessageHandler() throws SQLException;

    public void setASAMessageHandler(ASAMessageHandler aSAMessageHandler) throws SQLException {
        this.msgHandler = aSAMessageHandler;
        this.setASAMessageHandler();
    }
}

