/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IConnection;
import ianywhere.ml.jdbcodbc.IResource;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;

public final class IDriver
implements Driver {
    private static final int PREFIX_JOIN_CONN = 0;
    private static final int PREFIX_NEW_CONN = 1;
    private static final String LONG_HEX_PARM_START = ":0x";
    private static final String[] PROTOCOL_PREFIX = new String[]{"jdbc:joinodbc:", "jdbc:odbc:"};
    private static SQLException driverInitException = null;
    private static Class resource_class = class$ianywhere$ml$jdbcodbc$IResource == null ? (class$ianywhere$ml$jdbcodbc$IResource = IDriver.class$("ianywhere.ml.jdbcodbc.IResource")) : class$ianywhere$ml$jdbcodbc$IResource;
    static /* synthetic */ Class class$ianywhere$ml$jdbcodbc$IResource;

    private static UnsatisfiedLinkError try_load(String string, String string2) {
        String string3 = "dbjodbc9";
        String string4 = "mljodbc9";
        try {
            if (string == null) {
                System.loadLibrary(string3);
            } else {
                System.load(string + string2 + string3 + ".dll");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                if (string == null) {
                    System.loadLibrary(string4);
                } else {
                    System.load(string + string2 + string4 + ".dll");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                return unsatisfiedLinkError;
            }
        }
        return null;
    }

    public static void throwIfDriverInitFailed() throws SQLException {
        if (driverInitException != null) {
            throw driverInitException;
        }
    }

    private int protocolNumber(String string) {
        int n = 0;
        while (n < PROTOCOL_PREFIX.length) {
            if (string.startsWith(PROTOCOL_PREFIX[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private long extractLongParm(String string, int n) throws SQLException {
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if ((n2 = string.indexOf(LONG_HEX_PARM_START, n2 + 1)) == -1) {
                return 0L;
            }
            ++n3;
        }
        int n4 = n2 + LONG_HEX_PARM_START.length();
        int n5 = string.indexOf(LONG_HEX_PARM_START, n4);
        if (n5 < 0) {
            n5 = string.length();
        }
        String string2 = string.substring(n4, n5);
        try {
            long l = Long.parseLong(string2, 16);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(IResource.getString("INVALID_HDBC", string));
        }
    }

    public static native int getNativeLibraryMajorVersion();

    public static native int getNativeLibraryMinorVersion();

    private static native IConnection joinODBCConnection(long var0, long var2, long var4) throws SQLException;

    private static native IConnection makeODBCConnection(String var0) throws SQLException;

    private static native void initEnv();

    public static native void finiEnv();

    public boolean acceptsURL(String string) {
        return this.protocolNumber(string) >= 0;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        IDriver.throwIfDriverInitFailed();
        int n = this.protocolNumber(string);
        IConnection iConnection = null;
        switch (this.protocolNumber(string)) {
            case -1: {
                return null;
            }
            case 0: {
                long l = this.extractLongParm(string, 1);
                if (l == 0L) {
                    return null;
                }
                long l2 = this.extractLongParm(string, 2);
                long l3 = this.extractLongParm(string, 3);
                iConnection = IDriver.joinODBCConnection(l, l2, l3);
                break;
            }
            case 1: {
                String string2 = string.substring(PROTOCOL_PREFIX[1].length());
                if (properties != null) {
                    Object v = ((Hashtable)properties).get("user");
                    Object v2 = ((Hashtable)properties).get("password");
                    if (v != null) {
                        string2 = string2 + ";uid=" + v.toString();
                    }
                    if (v2 != null) {
                        string2 = string2 + ";pwd=" + v2.toString();
                    }
                }
                iConnection = IDriver.makeODBCConnection(string2);
            }
        }
        iConnection.setAttributes(properties);
        return iConnection;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return null;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static Date calendarize(Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        return new Date(calendar.get(1) - 1900, calendar.get(2), calendar.get(5));
    }

    public static Time calendarize(Time time, Calendar calendar) {
        if (time == null) {
            return null;
        }
        calendar.setTime(time);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp calendarize(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0 + 0.5));
        return new Timestamp(calendar.get(1) - 1900, calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            UnsatisfiedLinkError unsatisfiedLinkError;
            String string = System.getProperty("asa.location", null);
            if (string != null && (unsatisfiedLinkError = System.getProperty("java.vm.name").indexOf("64-Bit") != -1 ? IDriver.try_load(string, "ia64\\") : IDriver.try_load(string, "win32\\")) != null) {
                string = null;
            }
            if (string == null && (unsatisfiedLinkError = IDriver.try_load(null, null)) != null) {
                throw unsatisfiedLinkError;
            }
            int n = IDriver.getNativeLibraryMajorVersion();
            if (n != 1) {
                throw new SQLException(IResource.getString("MAJOR_VERSION_MISMATCH", String.valueOf(1), String.valueOf(n)));
            }
            DriverManager.registerDriver(new IDriver());
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                driverInitException = (SQLException)exception;
            }
            driverInitException = new SQLException(IResource.getString("DRIVER_INIT_FAILED", exception.toString() + " : " + exception.getMessage()));
            driverInitException.fillInStackTrace();
        }
        if (driverInitException == null) {
            IDriver.initEnv();
        }
    }
}

