/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.util.regex.Pattern;
import subzero.lib.exceptions.IOTimeoutException;
import subzero.lib.io.IOptionalRegexHandler;
import subzero.lib.io.RegexConnection;

public class CommandRegexHandler
implements IOptionalRegexHandler {
    private final Pattern m_pattern;
    private final String m_command;
    private final boolean m_matchMultipleTimes;

    public CommandRegexHandler(String regex, String command, boolean matchMultipleTimes) {
        this(Pattern.compile(regex), command, matchMultipleTimes);
    }

    public CommandRegexHandler(Pattern pattern, String command, boolean matchMultipleTimes) {
        this.m_pattern = pattern;
        this.m_command = command;
        this.m_matchMultipleTimes = matchMultipleTimes;
    }

    public boolean matches(CharSequence sequence) {
        return this.m_pattern.matcher(sequence).find();
    }

    public boolean process(RegexConnection connection, CharSequence sequence) throws IOTimeoutException {
        connection.sendText(this.m_command + (Object)((Object)connection.m_returnChar));
        return !this.m_matchMultipleTimes;
    }
}

