/*
 * Decompiled with CFR 0.152.
 */
package subzero.lib.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import subzero.lib.exceptions.EOFExpectException;
import subzero.lib.exceptions.ExpectException;
import subzero.lib.exceptions.ExpectTimeoutException;
import subzero.lib.io.IOCommands;
import subzero.lib.io.IOConnection;
import subzero.lib.io.TimeoutInputStream;

public class Expect {
    private final IOConnection m_conn;
    private final TimeoutInputStream m_in;
    private final OutputStream m_out;
    private String m_before;
    private String m_after;
    private int m_timeoutms = 30000;
    private IOCommands m_returnChar = IOCommands.LF;

    public Expect(IOConnection conn) {
        this.m_conn = conn;
        this.m_in = new TimeoutInputStream(this.m_conn.getInputStream(), -1L);
        this.m_out = this.m_conn.getOutputStream();
    }

    public String after() {
        return this.m_after;
    }

    public String before() {
        return this.m_before;
    }

    public void close(boolean wait) {
        try {
            this.m_conn.close();
        }
        catch (Exception e) {
            throw new ExpectException("close() failed: error", e);
        }
    }

    public void expect(String pattern) {
        this.expect(pattern, -1);
    }

    public void expect(String pattern, int timeoutms) {
        this.expect(new String[]{pattern}, timeoutms);
    }

    public void expect(Pattern pattern) {
        this.expect(pattern, -1);
    }

    public void expect(Pattern pattern, int timeoutms) {
        this.expect(new Pattern[]{pattern}, timeoutms);
    }

    public int expect(String[] patterns) {
        return this.expect(patterns, -1);
    }

    public int expect(String[] patterns, int timeoutms) {
        Pattern[] p = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            p[i] = Pattern.compile(patterns[i], 8);
        }
        return this.expect(p, timeoutms);
    }

    public int expect(Pattern[] patterns) {
        return this.expect(patterns, -1);
    }

    public int expect(Pattern[] patterns, int timeoutms) {
        if (timeoutms <= 0) {
            timeoutms = this.m_timeoutms;
        }
        StringBuffer buffer = new StringBuffer(1024);
        try {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + (long)timeoutms;
            if (timeoutms <= 0 || endTime < startTime) {
                endTime = Long.MAX_VALUE;
            }
            long now = startTime;
            while (now < endTime) {
                this.m_in.setReadTimeout(endTime - now);
                int response = this.m_in.read();
                if (response == -1) {
                    this.m_before = buffer.toString();
                    throw new EOFExpectException("ExpectIOConnection failed: EOF", null);
                }
                buffer.append((char)response);
                for (int i = 0; i < patterns.length; ++i) {
                    Matcher pm = patterns[i].matcher(buffer);
                    if (!pm.find(0)) continue;
                    int startLoc = pm.start();
                    this.m_before = buffer.substring(0, startLoc);
                    this.m_after = buffer.substring(startLoc);
                    return i;
                }
                now = System.currentTimeMillis();
            }
        }
        catch (InterruptedIOException iioe) {
            this.m_before = buffer.toString();
            throw new ExpectTimeoutException("ExpectIOConnection failed: interrupted", iioe);
        }
        catch (IOException ioe) {
            this.m_before = buffer.toString();
            throw new ExpectException("ExpectIOConnection failed: stream error", ioe);
        }
        this.m_before = buffer.toString();
        throw new ExpectTimeoutException("ExpectIOConnection failed: timeout", null);
    }

    public String read() {
        return this.read(-1);
    }

    public String read(int size) {
        this.m_in.setReadTimeout(this.m_timeoutms);
        try {
            int response;
            StringBuffer buf = new StringBuffer();
            while ((response = this.m_in.read()) != -1) {
                buf.append((char)response);
                if (size <= 0 || buf.length() != size) continue;
                break;
            }
            return buf.toString();
        }
        catch (IOException ioe) {
            throw new ExpectException("read() failed: stream error", ioe);
        }
    }

    public String readLine() {
        this.m_before = null;
        this.m_after = null;
        this.m_in.setReadTimeout(this.m_timeoutms);
        try {
            int response;
            StringBuffer buf = new StringBuffer();
            while ((response = this.m_in.read()) != -1) {
                if (response == 13) {
                    if (this.m_in.available() <= 0 || !this.m_in.markSupported()) break;
                    this.m_in.mark(1);
                    int read = this.m_in.read();
                    if (read == 10) break;
                    this.m_in.reset();
                    break;
                }
                if (response == 10) break;
                buf.append((char)response);
            }
            return buf.toString();
        }
        catch (IOException ioe) {
            throw new ExpectException("readLine() failed: stream error", ioe);
        }
    }

    public String[] readLines(int num) {
        String[] results = new String[num];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.readLine();
            if (results[i].length() != 0) continue;
            String[] temp = new String[i];
            if (i > 0) {
                System.arraycopy(results, 0, temp, 0, i);
            }
            return temp;
        }
        return results;
    }

    public void send(String text) {
        try {
            this.m_out.write(text.getBytes());
            this.m_out.flush();
        }
        catch (IOException ioe) {
            throw new ExpectException("Error sending data", ioe);
        }
    }

    public void sendLine(String text) {
        this.send(text + (Object)((Object)this.m_returnChar));
    }

    public void setReturnCharacter(IOCommands rc) {
        this.m_returnChar = rc;
    }

    public void timeout(int timeoutms) {
        this.m_timeoutms = timeoutms;
    }
}

